/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.chameleon.block.ChamTileEntity;
import com.jaquadro.minecraft.chameleon.block.tiledata.CustomNameData;
import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.ISealable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityDrawers
extends ChamTileEntity
implements ISealable,
IProtectable,
IDrawerGroup,
IWorldNameable {
    private CustomNameData customNameData = new CustomNameData("storagedrawers.container.drawers");
    private MaterialData materialData = new MaterialData();
    private UpgradeData upgradeData = new DrawerUpgradeData();
    public final ControllerData controllerData = new ControllerData();
    private int direction;
    private String material;
    private int drawerCapacity = 1;
    private boolean taped = false;
    private UUID owner;
    private String securityKey;
    private IDrawerAttributesModifiable drawerAttributes = new DrawerAttributes();
    private long lastClickTime;
    private UUID lastClickUUID;
    @CapabilityInject(value=IDrawerGroup.class)
    public static Capability<IDrawerGroup> DRAWER_GROUP_CAPABILITY = null;

    protected TileEntityDrawers() {
        this.upgradeData.setDrawerAttributes(this.drawerAttributes);
        this.injectPortableData((TileDataShim)this.customNameData);
        this.injectPortableData(this.upgradeData);
        this.injectPortableData(this.materialData);
        this.injectData(this.controllerData);
    }

    public abstract IDrawerGroup getGroup();

    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    public MaterialData material() {
        return this.materialData;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction % 6;
    }

    public String getMaterial() {
        return this.material;
    }

    public String getMaterialOrDefault() {
        String mat = this.getMaterial();
        return mat != null ? mat : "oak";
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public int getDrawerCapacity() {
        return this.drawerCapacity;
    }

    public int getEffectiveDrawerCapacity() {
        if (this.upgradeData.hasOneStackUpgrade()) {
            return 1;
        }
        return this.getDrawerCapacity();
    }

    @Override
    public UUID getOwner() {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return null;
        }
        return this.owner;
    }

    @Override
    public boolean setOwner(UUID owner) {
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        if (this.owner != null && !this.owner.equals(owner) || owner != null && !owner.equals(this.owner)) {
            this.owner = owner;
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    @Override
    public ISecurityProvider getSecurityProvider() {
        return StorageDrawers.securityRegistry.getProvider(this.securityKey);
    }

    @Override
    public boolean setSecurityProvider(ISecurityProvider provider) {
        String newKey;
        if (!StorageDrawers.config.cache.enablePersonalUpgrades) {
            return false;
        }
        String string = newKey = provider == null ? null : provider.getProviderID();
        if (newKey != null && !newKey.equals(this.securityKey) || this.securityKey != null && !this.securityKey.equals(newKey)) {
            this.securityKey = newKey;
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    protected void onAttributeChanged() {
    }

    @Override
    public boolean isSealed() {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        return this.taped;
    }

    @Override
    public boolean setIsSealed(boolean sealed) {
        if (!StorageDrawers.config.cache.enableTape) {
            return false;
        }
        if (this.taped != sealed) {
            this.taped = sealed;
            if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                this.markBlockForUpdate();
            }
        }
        return true;
    }

    public boolean isRedstone() {
        if (!StorageDrawers.config.cache.enableRedstoneUpgrades) {
            return false;
        }
        return this.upgradeData.getRedstoneType() != null;
    }

    public int getRedstoneLevel() {
        int n;
        EnumUpgradeRedstone type = this.upgradeData.getRedstoneType();
        if (type == null) {
            return 0;
        }
        switch (type) {
            case COMBINED: {
                n = this.getCombinedRedstoneLevel();
                break;
            }
            case MAX: {
                n = this.getMaxRedstoneLevel();
                break;
            }
            case MIN: {
                n = this.getMinRedstoneLevel();
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    protected int getCombinedRedstoneLevel() {
        int active = 0;
        float fillRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            if (drawer.getMaxCapacity() > 0) {
                fillRatio += (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity();
            }
            ++active;
        }
        if (active == 0) {
            return 0;
        }
        if (fillRatio == (float)active) {
            return 15;
        }
        return (int)Math.ceil(fillRatio / (float)active * 14.0f);
    }

    protected int getMinRedstoneLevel() {
        float minRatio = 2.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            minRatio = drawer.getMaxCapacity() > 0 ? Math.min(minRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity()) : 0.0f;
        }
        if (minRatio > 1.0f) {
            return 0;
        }
        if (minRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(minRatio * 14.0f);
    }

    protected int getMaxRedstoneLevel() {
        float maxRatio = 0.0f;
        for (int i = 0; i < this.getDrawerCount(); ++i) {
            IDrawer drawer = this.getDrawer(i);
            if (!drawer.isEnabled() || drawer.getMaxCapacity() <= 0) continue;
            maxRatio = Math.max(maxRatio, (float)drawer.getStoredItemCount() / (float)drawer.getMaxCapacity());
        }
        if (maxRatio == 1.0f) {
            return 15;
        }
        return (int)Math.ceil(maxRatio * 14.0f);
    }

    @Nonnull
    public ItemStack takeItemsFromSlot(int slot, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled() || drawer.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = drawer.getStoredItemPrototype().func_77946_l();
        stack.func_190920_e(Math.min(count, drawer.getStoredItemCount()));
        drawer.setStoredItemCount(drawer.getStoredItemCount() - stack.func_190916_E());
        if (this.isRedstone() && this.func_145831_w() != null) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
            this.func_145831_w().func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q(), false);
        }
        return stack;
    }

    public int putItemsIntoSlot(int slot, @Nonnull ItemStack stack, int count) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            drawer = drawer.setStoredItem(stack);
        }
        if (!drawer.canItemBeStored(stack)) {
            return 0;
        }
        int countAdded = Math.min(count, stack.func_190916_E());
        if (!this.drawerAttributes.isVoid()) {
            countAdded = Math.min(countAdded, drawer.getRemainingCapacity());
        }
        drawer.setStoredItemCount(drawer.getStoredItemCount() + countAdded);
        stack.func_190918_g(countAdded);
        return countAdded;
    }

    public int interactPutCurrentItemIntoSlot(int slot, EntityPlayer player) {
        IDrawer drawer = this.getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        ItemStack playerStack = player.field_71071_by.func_70448_g();
        if (!playerStack.func_190926_b()) {
            count = this.putItemsIntoSlot(slot, playerStack, playerStack.func_190916_E());
        }
        return count;
    }

    public int interactPutCurrentInventoryIntoSlot(int slot, EntityPlayer player) {
        IDrawer drawer = this.getGroup().getDrawer(slot);
        if (!drawer.isEnabled()) {
            return 0;
        }
        int count = 0;
        if (!drawer.isEmpty()) {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack.func_190926_b()) continue;
                int subCount = this.putItemsIntoSlot(slot, subStack, subStack.func_190916_E());
                if (subCount > 0 && subStack.func_190916_E() == 0) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                count += subCount;
            }
        }
        if (count > 0) {
            StorageDrawers.proxy.updatePlayerInventory(player);
        }
        return count;
    }

    public int interactPutItemsIntoSlot(int slot, EntityPlayer player) {
        int count = this.func_145831_w().func_82737_E() - this.lastClickTime < 10L && player.getPersistentID().equals(this.lastClickUUID) ? this.interactPutCurrentInventoryIntoSlot(slot, player) : this.interactPutCurrentItemIntoSlot(slot, player);
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.getPersistentID();
        return count;
    }

    protected void readFromFixedNBT(NBTTagCompound tag) {
        super.readFromFixedNBT(tag);
        this.setDirection(tag.func_74771_c("Dir"));
        this.taped = false;
        if (tag.func_74764_b("Tape")) {
            this.taped = tag.func_74767_n("Tape");
        }
    }

    protected NBTTagCompound writeToFixedNBT(NBTTagCompound tag) {
        tag = super.writeToFixedNBT(tag);
        tag.func_74774_a("Dir", (byte)this.direction);
        if (this.taped) {
            tag.func_74757_a("Tape", true);
        }
        return tag;
    }

    public void readFromPortableNBT(NBTTagCompound tag) {
        EnumSet<LockAttribute> attrs;
        super.readFromPortableNBT(tag);
        this.material = null;
        if (tag.func_74764_b("Mat")) {
            this.material = tag.func_74779_i("Mat");
        }
        this.drawerCapacity = tag.func_74762_e("Cap");
        this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
        this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        if (tag.func_74764_b("Lock") && (attrs = LockAttribute.getEnumSet(tag.func_74771_c("Lock"))) != null) {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains((Object)LockAttribute.LOCK_EMPTY));
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains((Object)LockAttribute.LOCK_POPULATED));
        }
        this.drawerAttributes.setIsConcealed(false);
        if (tag.func_74764_b("Shr")) {
            this.drawerAttributes.setIsConcealed(tag.func_74767_n("Shr"));
        }
        this.drawerAttributes.setIsShowingQuantity(false);
        if (tag.func_74764_b("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(tag.func_74767_n("Qua"));
        }
        this.owner = null;
        if (tag.func_74764_b("Own")) {
            this.owner = UUID.fromString(tag.func_74779_i("Own"));
        }
        this.securityKey = null;
        if (tag.func_74764_b("Sec")) {
            this.securityKey = tag.func_74779_i("Sec");
        }
    }

    public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
        tag = super.writeToPortableNBT(tag);
        tag.func_74768_a("Cap", this.getDrawerCapacity());
        if (this.material != null) {
            tag.func_74778_a("Mat", this.material);
        }
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.func_74774_a("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.func_74757_a("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.func_74757_a("Qua", true);
        }
        if (this.owner != null) {
            tag.func_74778_a("Own", this.owner.toString());
        }
        if (this.securityKey != null) {
            tag.func_74778_a("Sec", this.securityKey);
        }
        return tag;
    }

    public void func_70296_d() {
        if (this.isRedstone() && this.func_145831_w() != null) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
            this.func_145831_w().func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q(), false);
        }
        super.func_70296_d();
    }

    protected void syncClientCount(int slot, int count) {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 500.0);
        StorageDrawers.network.sendToAllAround((IMessage)new CountUpdateMessage(this.func_174877_v(), slot, count), point);
    }

    @SideOnly(value=Side.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_152344_a(() -> this.clientUpdateCountAsync(slot, count));
    }

    @SideOnly(value=Side.CLIENT)
    private void clientUpdateCountAsync(int slot, int count) {
        IDrawer drawer = this.getDrawer(slot);
        if (drawer.isEnabled() && drawer.getStoredItemCount() != count) {
            drawer.setStoredItemCount(count);
        }
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    @Deprecated
    public int getDrawerCount() {
        return this.getGroup().getDrawerCount();
    }

    @Override
    @Nonnull
    @Deprecated
    public IDrawer getDrawer(int slot) {
        return this.getGroup().getDrawer(slot);
    }

    @Override
    @Nonnull
    @Deprecated
    public int[] getAccessibleDrawerSlots() {
        return this.getGroup().getAccessibleDrawerSlots();
    }

    public String func_70005_c_() {
        return this.customNameData.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.customNameData.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.customNameData.func_145748_c_();
    }

    public void setInventoryName(String name) {
        this.customNameData.setName(name);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return (T)this.getGroup();
        }
        if (this.getGroup().hasCapability(capability, facing)) {
            return this.getGroup().getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == DRAWER_GROUP_CAPABILITY) {
            return true;
        }
        if (this.getGroup().hasCapability(capability, facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        @Override
        public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.func_77973_b() == ModItems.upgradeOneStack) {
                int lostStackCapacity = TileEntityDrawers.this.upgradeData.getStorageMultiplier() * (TileEntityDrawers.this.getEffectiveDrawerCapacity() - 1);
                return this.stackCapacityCheck(lostStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.func_77973_b() == ModItems.upgradeStorage) {
                int storageLevel = EnumUpgradeStorage.byMetadata(upgrade.func_77960_j()).getLevel();
                int storageMult = StorageDrawers.config.getStorageUpgradeMultiplier(storageLevel);
                int effectiveStorageMult = TileEntityDrawers.this.upgradeData.getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                int addedStackCapacity = storageMult * TileEntityDrawers.this.getEffectiveDrawerCapacity();
                return this.stackCapacityCheck(addedStackCapacity);
            }
            return true;
        }

        @Override
        public boolean canSwapUpgrade(int slot, @NotNull ItemStack add) {
            if (!this.canRemoveUpgrade(slot) || !this.canAddUpgrade(add)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.func_77973_b() == ModItems.upgradeOneStack) {
                return true;
            }
            if (add.func_77973_b() == ModItems.upgradeStorage) {
                return true;
            }
            int currentUpgradeMult = TileEntityDrawers.this.upgradeData.getStorageMultiplier();
            int storageLevel = EnumUpgradeStorage.byMetadata(upgrade.func_77960_j()).getLevel();
            int storageMult = StorageDrawers.config.getStorageUpgradeMultiplier(storageLevel);
            int removedStacks = Math.min(currentUpgradeMult * TileEntityDrawers.this.getEffectiveDrawerCapacity() - 1, currentUpgradeMult * (TileEntityDrawers.this.getEffectiveDrawerCapacity() - 1) + storageMult);
            return this.stackCapacityCheck(removedStacks);
        }

        @Override
        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (TileEntityDrawers.this.func_145831_w() != null && !TileEntityDrawers.this.func_145831_w().field_72995_K) {
                TileEntityDrawers.this.func_70296_d();
                TileEntityDrawers.this.markBlockForUpdate();
            }
        }

        private boolean stackCapacityCheck(int stackCapacity) {
            for (int i = 0; i < TileEntityDrawers.this.getDrawerCount(); ++i) {
                IDrawer drawer = TileEntityDrawers.this.getDrawer(i);
                if (!drawer.isEnabled() || drawer.isEmpty()) continue;
                int addedItemCapacity = stackCapacity * drawer.getStoredItemStackSize();
                if (drawer.getMaxCapacity() - addedItemCapacity >= drawer.getStoredItemCount()) continue;
                return false;
            }
            return true;
        }
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        @Override
        protected void onAttributeChanged() {
            TileEntityDrawers.this.onAttributeChanged();
            if (TileEntityDrawers.this.func_145831_w() != null && !TileEntityDrawers.this.func_145831_w().field_72995_K) {
                TileEntityDrawers.this.func_70296_d();
                TileEntityDrawers.this.markBlockForUpdate();
            }
        }
    }
}

