/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.util;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final FontRenderer fontRenderer = RenderUtils.mc.field_71466_p;

    public static void drawSplitStringOnHUD(String str, int x, int y, int wrapWidth) {
        RenderUtils.renderSplitString(str, x, y, wrapWidth, true);
    }

    public static void renderSplitString(String string, int x, int y, int wrapWidth, boolean addShadow) {
        for (String s : fontRenderer.func_78271_c(string, wrapWidth)) {
            fontRenderer.func_175065_a(s, (float)x, (float)y, 0xFFFFFF, addShadow);
            y += RenderUtils.fontRenderer.field_78288_b;
        }
    }

    public static int getSplitStringWidth(String string, int wrapWidth) {
        List lines = fontRenderer.func_78271_c(string, wrapWidth);
        int width = 0;
        for (String line : lines) {
            int stringWidth = fontRenderer.func_78256_a(line);
            if (stringWidth <= width) continue;
            width = stringWidth;
        }
        return width;
    }

    public static int getSplitStringHeight(String string, int wrapWidth) {
        return RenderUtils.fontRenderer.field_78288_b * fontRenderer.func_78271_c(string, wrapWidth).size();
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        int temp;
        if (left < right) {
            temp = left;
            left = right;
            right = temp;
        }
        if (top < bottom) {
            temp = top;
            top = bottom;
            bottom = temp;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        buffer.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static int getRenderWidth(String position, int width, ScaledResolution res) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("center_left") || positionLower.equals("bottom_left")) {
            return 10;
        }
        return res.func_78326_a() - width;
    }

    public static int getRenderHeight(String position, int height, ScaledResolution res) {
        String positionLower = position.toLowerCase();
        if (positionLower.equals("top_left") || positionLower.equals("top_right")) {
            return 5;
        }
        if (positionLower.equals("bottom_left") || positionLower.equals("bottom_right")) {
            return res.func_78328_b() - height - 5;
        }
        return res.func_78328_b() / 2 - height / 2;
    }
}

