/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.util.RenderUtils;
import com.chaosthedude.notes.util.StringUtils;
import com.chaosthedude.notes.util.WrappedString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiNoteTextField
extends Gui {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private int margin;
    private String text;
    private int topVisibleLine;
    private int bottomVisibleLine;
    private int maxVisibleLines;
    private int wrapWidth;
    private final FontRenderer fontRenderer;
    public int xPosition;
    public int yPosition;
    public int width;
    public int height;
    private int cursorCounter;
    private boolean canLoseFocus = true;
    private boolean isFocused;
    private boolean isEnabled = true;
    private int cursorPos;
    private int selectionPos;
    private int enabledColor = 0xE0E0E0;
    private int disabledColor = 0x707070;
    private boolean visible = true;

    public GuiNoteTextField(FontRenderer fontRenderer, int x, int y, int width, int height, int margin) {
        this.fontRenderer = fontRenderer;
        this.xPosition = x;
        this.yPosition = y;
        this.width = width;
        this.height = height;
        this.margin = margin;
        this.text = "";
        this.maxVisibleLines = MathHelper.func_76141_d((float)((height - margin * 2) / fontRenderer.field_78288_b)) - 1;
        this.wrapWidth = width - margin * 2;
        this.selectionPos = -1;
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (GuiScreen.func_175280_f((int)keyCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
        } else if (GuiScreen.func_175277_d((int)keyCode)) {
            if (this.getSelectionDifference() != 0) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                this.deleteSelectedText();
            }
        } else if (GuiScreen.func_175279_e((int)keyCode)) {
            this.insert(GuiScreen.func_146277_j());
        } else if (this.isKeyComboCtrlBack(keyCode)) {
            this.deletePrevWord();
        } else {
            switch (keyCode) {
                case 14: {
                    if (this.getSelectionDifference() != 0) {
                        this.deleteSelectedText();
                    } else {
                        this.deletePrev();
                    }
                    return;
                }
                case 211: {
                    if (this.getSelectionDifference() != 0) {
                        this.deleteSelectedText();
                    } else {
                        this.deleteNext();
                    }
                    return;
                }
                case 15: {
                    this.insert("    ");
                }
                case 156: {
                    this.insertNewLine();
                    return;
                }
                case 28: {
                    this.insertNewLine();
                    return;
                }
                case 199: {
                    this.updateSelectionPos();
                    this.setCursorPos(0);
                    return;
                }
                case 207: {
                    this.updateSelectionPos();
                    this.setCursorPos(this.text.length());
                    return;
                }
                case 200: {
                    this.updateSelectionPos();
                    this.moveUp();
                    return;
                }
                case 208: {
                    this.updateSelectionPos();
                    this.moveDown();
                    return;
                }
                case 203: {
                    boolean moveLeft = true;
                    if (GuiScreen.func_146272_n()) {
                        if (this.selectionPos < 0) {
                            this.selectionPos = this.cursorPos;
                        }
                    } else {
                        if (this.selectionPos > -1) {
                            this.setCursorPos(this.getSelectionStart());
                            moveLeft = false;
                        }
                        this.selectionPos = -1;
                    }
                    if (moveLeft) {
                        this.moveLeft();
                    }
                    return;
                }
                case 205: {
                    boolean moveRight = true;
                    if (GuiScreen.func_146272_n()) {
                        if (this.selectionPos < 0) {
                            this.selectionPos = this.cursorPos;
                        }
                    } else {
                        if (this.selectionPos > -1) {
                            this.setCursorPos(this.getSelectionEnd());
                            moveRight = false;
                        }
                        this.selectionPos = -1;
                    }
                    if (moveRight) {
                        this.moveRight();
                    }
                    return;
                }
            }
            if (ChatAllowedCharacters.func_71566_a((char)typedChar)) {
                this.insert(Character.toString(typedChar));
            }
        }
        this.updateVisibleLines();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        RenderUtils.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, 0x7F000000);
        this.renderVisibleText();
        this.renderCursor();
        this.renderScrollBar();
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean isWithinBounds = this.isWithinBounds(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocused(isWithinBounds);
        }
        if (this.isFocused && isWithinBounds && mouseButton == 0) {
            int relativeMouseX = mouseX - this.xPosition - this.margin;
            int relativeMouseY = mouseY - this.yPosition - this.margin;
            int y = MathHelper.func_76125_a((int)(relativeMouseY / this.fontRenderer.field_78288_b + this.topVisibleLine), (int)0, (int)this.getFinalLineIndex());
            int x = this.fontRenderer.func_78269_a(this.getLine(y), relativeMouseX).length();
            this.setCursorPos(this.countCharacters(y) + x);
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
        boolean isWithinBounds = this.isWithinBounds(mouseX, mouseY);
        if (this.canLoseFocus) {
            this.setFocused(isWithinBounds);
        }
        if (this.isFocused && isWithinBounds && state == 0) {
            int relativeMouseX = mouseX - this.xPosition - this.margin;
            int relativeMouseY = mouseY - this.yPosition - this.margin;
            int y = MathHelper.func_76125_a((int)(relativeMouseY / this.fontRenderer.field_78288_b + this.topVisibleLine), (int)0, (int)this.getFinalLineIndex());
            int x = this.fontRenderer.func_78269_a(this.getLine(y), relativeMouseX).length();
            int pos = MathHelper.func_76125_a((int)(this.countCharacters(y) + x), (int)0, (int)this.text.length());
            if (pos != this.cursorPos) {
                this.selectionPos = this.cursorPos;
                this.setCursorPos(pos);
            } else {
                this.selectionPos = -1;
            }
        }
    }

    public void handleMouseInput() {
        int scroll = Mouse.getEventDWheel();
        if (scroll < 0) {
            this.incrementVisibleLines();
        } else if (scroll > 0) {
            this.decrementVisibleLines();
        }
    }

    public void updateScreen() {
        ++this.cursorCounter;
    }

    public List<String> toLines() {
        return StringUtils.wrapToWidth(this.text, this.wrapWidth);
    }

    public List<WrappedString> toLinesWithIndication() {
        return StringUtils.wrapToWidthWithIndication(this.text, this.wrapWidth);
    }

    public String getLine(int line) {
        return line >= 0 && line < this.toLines().size() ? this.toLines().get(line) : this.getFinalLine();
    }

    public String getFinalLine() {
        return this.getLine(this.getFinalLineIndex());
    }

    public String getCurrentLine() {
        return this.getLine(this.getCursorY());
    }

    public List<String> getVisibleLines() {
        List<String> lines = this.toLines();
        ArrayList<String> visibleLines = new ArrayList<String>();
        for (int i = this.topVisibleLine; i <= this.bottomVisibleLine; ++i) {
            if (i >= lines.size()) continue;
            visibleLines.add(lines.get(i));
        }
        return visibleLines;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.updateVisibleLines();
    }

    public int getFinalLineIndex() {
        return this.toLines().size() - 1;
    }

    public boolean cursorIsValid() {
        int y = this.getCursorY();
        return y >= this.topVisibleLine && y <= this.bottomVisibleLine;
    }

    public int getRenderSafeCursorY() {
        return this.getCursorY() - this.topVisibleLine;
    }

    public int getAbsoluteBottomVisibleLine() {
        return this.topVisibleLine + (this.maxVisibleLines - 1);
    }

    public int getCursorWidth(int pos) {
        String line = this.getCurrentLine();
        return this.fontRenderer.func_78256_a(line.substring(0, MathHelper.func_76125_a((int)this.getCursorX(), (int)0, (int)line.length())));
    }

    public int getCursorWidth() {
        return this.getCursorWidth(this.cursorPos);
    }

    public boolean isWithinBounds(int mouseX, int mouseY) {
        return mouseX >= this.xPosition && mouseX < this.xPosition + this.width && mouseY >= this.yPosition && mouseY < this.yPosition + this.height;
    }

    public boolean atBeginningOfLine() {
        return this.getCursorX() == 0;
    }

    public boolean atEndOfLine() {
        return this.getCursorX() == this.getCurrentLine().length();
    }

    public boolean atBeginningOfNote() {
        return this.cursorPos == 0;
    }

    public boolean atEndOfNote() {
        return this.cursorPos >= this.text.length();
    }

    public int getVisibleLineCount() {
        return this.bottomVisibleLine - this.topVisibleLine + 1;
    }

    public void updateVisibleLines() {
        while (this.getVisibleLineCount() <= this.maxVisibleLines && this.bottomVisibleLine < this.getFinalLineIndex()) {
            ++this.bottomVisibleLine;
        }
    }

    public boolean needsScrollBar() {
        return this.toLines().size() > this.getVisibleLineCount();
    }

    public int getWidth() {
        return this.width - this.margin * 2;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setFocused(boolean focused) {
        if (focused && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = focused;
    }

    public boolean isKeyComboCtrlBack(int keyCode) {
        return keyCode == 14 && GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s();
    }

    public void insert(String newText) {
        this.deleteSelectedText();
        String finalText = StringUtils.insertStringAt(StringUtils.filter(newText), this.text, this.cursorPos);
        this.setText(finalText);
        this.moveCursorPosBy(newText.length());
    }

    public void insertNewLine() {
        this.insert(String.valueOf('\n'));
    }

    private void deleteNext() {
        String currentText = this.text;
        if (!this.atEndOfNote() && !currentText.isEmpty()) {
            StringBuilder sb = new StringBuilder(currentText);
            sb.deleteCharAt(this.cursorPos);
            this.setText(sb.toString());
            --this.selectionPos;
        }
    }

    private void deletePrev() {
        String currentText = this.text;
        if (!this.atBeginningOfNote() && !currentText.isEmpty()) {
            StringBuilder sb = new StringBuilder(currentText);
            sb.deleteCharAt(this.cursorPos - 1);
            this.setText(sb.toString());
            this.moveLeft();
        }
    }

    private void deletePrevWord() {
        block6: {
            if (this.atBeginningOfNote()) break block6;
            char prev = this.text.charAt(this.cursorPos - 1);
            if (prev == ' ') {
                while (prev == ' ') {
                    this.deletePrev();
                    if (this.atBeginningOfNote()) {
                        return;
                    }
                    prev = this.text.charAt(this.cursorPos - 1);
                }
            } else {
                while (prev != ' ') {
                    this.deletePrev();
                    if (this.atBeginningOfNote()) {
                        return;
                    }
                    prev = this.text.charAt(this.cursorPos - 1);
                }
            }
        }
    }

    private void deleteSelectedText() {
        while (this.getSelectionDifference() > 0) {
            this.deletePrev();
        }
        while (this.getSelectionDifference() < 0) {
            this.deleteNext();
        }
        this.selectionPos = -1;
    }

    private void incrementVisibleLines() {
        if (this.bottomVisibleLine < this.getFinalLineIndex()) {
            ++this.topVisibleLine;
            ++this.bottomVisibleLine;
        }
    }

    private void decrementVisibleLines() {
        if (this.topVisibleLine > 0) {
            --this.topVisibleLine;
            --this.bottomVisibleLine;
        }
    }

    private int countCharacters(int maxLineIndex) {
        List<WrappedString> wrappedLines = this.toLinesWithIndication();
        int count = 0;
        for (int i = 0; i < maxLineIndex; ++i) {
            WrappedString wrappedLine = wrappedLines.get(i);
            count += wrappedLine.getText().length();
            if (wrappedLine.isWrapped()) continue;
            ++count;
        }
        return count;
    }

    private int getCursorX(int pos) {
        List<WrappedString> wrappedLines = this.toLinesWithIndication();
        int y = this.getCursorY();
        boolean currentLineIsWrapped = false;
        int count = 0;
        for (int i = 0; i <= y; ++i) {
            if (i >= wrappedLines.size()) continue;
            WrappedString wrappedLine = wrappedLines.get(i);
            if (i < y) {
                count += wrappedLine.getText().length();
                if (!wrappedLine.isWrapped()) {
                    ++count;
                }
            }
            if (!wrappedLine.isWrapped() || i != y || i <= 0) continue;
            currentLineIsWrapped = true;
        }
        if (currentLineIsWrapped) {
            --count;
        }
        return pos - count;
    }

    private int getCursorX() {
        return this.getCursorX(this.cursorPos);
    }

    private int getCursorY(int pos) {
        List<WrappedString> wrappedLines = this.toLinesWithIndication();
        int count = 0;
        for (int i = 0; i < wrappedLines.size(); ++i) {
            WrappedString wrappedLine = wrappedLines.get(i);
            count += wrappedLine.getText().length();
            if (!wrappedLine.isWrapped()) {
                ++count;
            }
            if (count <= pos) continue;
            return i;
        }
        return this.getFinalLineIndex();
    }

    private int getCursorY() {
        return this.getCursorY(this.cursorPos);
    }

    private int getSelectionDifference() {
        return this.selectionPos > -1 ? this.cursorPos - this.selectionPos : 0;
    }

    private boolean hasSelectionOnLine(int line) {
        if (this.selectionPos > -1) {
            List<WrappedString> wrappedLines = this.toLinesWithIndication();
            int count = 0;
            for (int i = 0; i <= line; ++i) {
                WrappedString wrappedLine = wrappedLines.get(i);
                for (int j = 0; j < wrappedLine.getText().length(); ++j) {
                    if (line != i || !this.isInSelection(++count)) continue;
                    return true;
                }
                if (wrappedLine.isWrapped()) continue;
                ++count;
            }
        }
        return false;
    }

    private void setCursorPos(int pos) {
        this.cursorPos = MathHelper.func_76125_a((int)pos, (int)0, (int)this.text.length());
        if (this.getCursorY() > this.bottomVisibleLine) {
            this.incrementVisibleLines();
        } else if (this.getCursorY() < this.topVisibleLine) {
            this.decrementVisibleLines();
        }
    }

    private void moveCursorPosBy(int amount) {
        this.setCursorPos(this.cursorPos + amount);
    }

    private void moveRight() {
        if (!this.atEndOfNote()) {
            this.moveCursorPosBy(1);
        }
    }

    private void moveLeft() {
        if (!this.atBeginningOfNote()) {
            this.moveCursorPosBy(-1);
        }
    }

    private void moveUp() {
        int width = this.getCursorWidth();
        int y = this.getCursorY();
        while (this.cursorPos > 0 && (this.getCursorY() == y || this.getCursorWidth() > width)) {
            this.moveLeft();
        }
    }

    private void moveDown() {
        int width = this.getCursorWidth();
        int y = this.getCursorY();
        while (this.cursorPos < this.text.length() && (this.getCursorY() == y || this.getCursorWidth() < width)) {
            this.moveRight();
        }
    }

    private void updateSelectionPos() {
        if (GuiScreen.func_146272_n()) {
            if (this.selectionPos < 0) {
                this.selectionPos = this.cursorPos;
            }
        } else {
            this.selectionPos = -1;
        }
    }

    private boolean isInSelection(int pos) {
        if (this.selectionPos > -1) {
            return pos >= this.getSelectionStart() && pos <= this.getSelectionEnd();
        }
        return false;
    }

    private int getSelectionStart() {
        if (this.selectionPos > -1) {
            if (this.selectionPos > this.cursorPos) {
                return this.cursorPos;
            }
            if (this.cursorPos > this.selectionPos) {
                return this.selectionPos;
            }
        }
        return -1;
    }

    private int getSelectionEnd() {
        if (this.selectionPos > -1) {
            if (this.selectionPos > this.cursorPos) {
                return this.selectionPos;
            }
            if (this.cursorPos > this.selectionPos) {
                return this.cursorPos;
            }
        }
        return -1;
    }

    private String getSelectedText() {
        if (this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0) {
            return this.text.substring(this.getSelectionStart(), this.getSelectionEnd());
        }
        return "";
    }

    private void drawSelectionBox(int startX, int startY, int endX, int endY) {
        int temp;
        if (startX < endX) {
            temp = startX;
            startX = endX;
            endX = temp;
        }
        if (startY < endY) {
            temp = startY;
            startY = endY;
            endY = temp;
        }
        if (endX > this.xPosition + this.width) {
            endX = this.xPosition + this.width;
        }
        if (startX > this.xPosition + this.width) {
            startX = this.xPosition + this.width;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        buffer.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        buffer.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        buffer.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    private void renderSelectionBox(int y, int renderY, String line) {
        if (this.hasSelectionOnLine(y)) {
            int end;
            int start;
            String absoluteLine = this.getLine(y);
            int count = 0;
            List<WrappedString> wrappedLines = this.toLinesWithIndication();
            for (int i = 0; i < y; ++i) {
                WrappedString wrappedLine = wrappedLines.get(i);
                count += wrappedLine.getText().length();
                if (wrappedLine.isWrapped()) continue;
                ++count;
            }
            if (wrappedLines.get(y).isWrapped()) {
                --count;
            }
            if ((start = this.getSelectionStart() - count) < 0) {
                start = 0;
            }
            if ((end = this.getSelectionEnd() - count) > line.length()) {
                end = line.length();
            }
            if (start >= end) {
                this.selectionPos = -1;
            } else {
                String selection = absoluteLine.substring(start, end);
                int startX = this.xPosition + this.margin + this.fontRenderer.func_78256_a(absoluteLine.substring(0, start));
                int endX = startX + this.fontRenderer.func_78256_a(selection);
                this.drawSelectionBox(startX, renderY, endX, renderY + this.fontRenderer.field_78288_b);
            }
        }
    }

    private void renderVisibleText() {
        int renderY = this.yPosition + this.margin;
        int y = this.topVisibleLine;
        for (String line : this.getVisibleLines()) {
            this.fontRenderer.func_175063_a(line, (float)(this.xPosition + this.margin), (float)renderY, 0xE0E0E0);
            this.renderSelectionBox(y, renderY, line);
            renderY += this.fontRenderer.field_78288_b;
            ++y;
        }
    }

    private void renderCursor() {
        boolean shouldDisplayCursor;
        boolean bl = shouldDisplayCursor = this.isFocused && this.cursorCounter / 6 % 2 == 0 && this.cursorIsValid();
        if (shouldDisplayCursor) {
            String line = this.getCurrentLine();
            int renderCursorX = this.xPosition + this.margin + this.fontRenderer.func_78256_a(line.substring(0, MathHelper.func_76125_a((int)this.getCursorX(), (int)0, (int)line.length())));
            int renderCursorY = this.yPosition + this.margin + this.getRenderSafeCursorY() * this.fontRenderer.field_78288_b;
            GuiNoteTextField.func_73734_a((int)renderCursorX, (int)(renderCursorY - 1), (int)(renderCursorX + 1), (int)(renderCursorY + this.fontRenderer.field_78288_b + 1), (int)-3092272);
        }
    }

    private void renderScrollBar() {
        if (this.needsScrollBar()) {
            List<String> lines = this.toLines();
            int effectiveHeight = this.height - this.margin / 2;
            int scrollBarHeight = MathHelper.func_76128_c((double)((double)effectiveHeight * ((double)this.getVisibleLineCount() / (double)lines.size())));
            int scrollBarTop = this.yPosition + this.margin / 4 + MathHelper.func_76128_c((double)((double)this.topVisibleLine / (double)lines.size() * (double)effectiveHeight));
            int diff = scrollBarTop + scrollBarHeight - (this.yPosition + this.height);
            if (diff > 0) {
                scrollBarTop -= diff;
            }
            GuiNoteTextField.func_73734_a((int)(this.xPosition + this.width - this.margin * 3 / 4), (int)scrollBarTop, (int)(this.xPosition + this.width - this.margin / 4), (int)(scrollBarTop + scrollBarHeight), (int)-3092272);
        }
    }
}

