/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.GuiDisplayNote;
import com.chaosthedude.notes.gui.GuiEditNote;
import com.chaosthedude.notes.gui.GuiListNotes;
import com.chaosthedude.notes.gui.GuiNotesYesNo;
import com.chaosthedude.notes.gui.GuiSelectNote;
import com.chaosthedude.notes.note.Note;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiListNotesEntry
implements GuiListExtended.IGuiListEntry {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    private final Minecraft mc;
    private final GuiSelectNote guiNotes;
    private final Note note;
    private final GuiListNotes notesList;
    private long lastClickTime;

    public GuiListNotesEntry(GuiListNotes notesList, Note note) {
        this.notesList = notesList;
        this.note = note;
        this.guiNotes = notesList.getGuiNotes();
        this.mc = Minecraft.func_71410_x();
    }

    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        this.mc.field_71466_p.func_78276_b(this.note.getTitle(), x + 1, y + 1, 0xFFFFFF);
        this.mc.field_71466_p.func_78276_b(this.note.getScope().format(), x + 4 + this.mc.field_71466_p.func_78256_a(this.note.getTitle()), y + 1, 0x808080);
        this.mc.field_71466_p.func_78276_b(this.note.getPreview(MathHelper.func_76128_c((double)((double)listWidth * 0.9))), x + 1, y + this.mc.field_71466_p.field_78288_b + 3, 0x808080);
        this.mc.field_71466_p.func_78276_b(this.note.getLastModifiedString(), x + 1, y + this.mc.field_71466_p.field_78288_b + 14, 0x808080);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        this.notesList.selectNote(slotIndex);
        if (Minecraft.func_71386_F() - this.lastClickTime < 250L) {
            this.loadNote();
            return true;
        }
        this.lastClickTime = Minecraft.func_71386_F();
        return false;
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }

    public void func_192633_a(int par1, int par2, int par3, float par4) {
    }

    public void editNote() {
        if (ConfigHandler.useInGameEditor) {
            this.mc.func_147108_a((GuiScreen)new GuiEditNote(this.guiNotes, this.note));
        } else {
            this.note.openExternal();
        }
    }

    public void copyNote() {
        this.note.copy();
        this.notesList.refreshList();
    }

    public void loadNote() {
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        if (ConfigHandler.useInGameViewer) {
            this.mc.func_147108_a((GuiScreen)new GuiDisplayNote(this.guiNotes, this.note));
        } else {
            this.note.openExternal();
        }
    }

    public void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
        } else {
            Notes.pinnedNote = this.note;
            this.mc.func_147108_a(null);
        }
    }

    public boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    public void deleteNote() {
        this.mc.func_147108_a((GuiScreen)new GuiNotesYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                if (result) {
                    GuiListNotesEntry.this.mc.func_147108_a((GuiScreen)new GuiScreenWorking());
                    GuiListNotesEntry.this.note.delete();
                    GuiListNotesEntry.this.notesList.refreshList();
                }
                GuiListNotesEntry.this.mc.func_147108_a((GuiScreen)GuiListNotesEntry.this.guiNotes);
            }
        }, "Delete this note?", this.note.getTitle(), 0));
    }
}

