/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.gui.GuiDisplayNote;
import com.chaosthedude.notes.gui.GuiNoteTextField;
import com.chaosthedude.notes.gui.GuiNoteTitleField;
import com.chaosthedude.notes.gui.GuiNotesButton;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.note.Scope;
import com.chaosthedude.notes.util.StringUtils;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEditNote
extends GuiScreen {
    private final GuiScreen parentScreen;
    private GuiNotesButton saveButton;
    private GuiNotesButton globalButton;
    private GuiNotesButton insertBiomeButton;
    private GuiNotesButton insertChunkButton;
    private GuiNotesButton insertCoordsButton;
    private GuiNotesButton cancelButton;
    private GuiNoteTitleField noteTitleField;
    private GuiNoteTextField noteTextField;
    private String saveDirName;
    private Note note;
    private String guiTitle;
    private Scope scope;
    private boolean pinned;

    public GuiEditNote(GuiScreen parentScreen, @Nullable Note note) {
        this.parentScreen = parentScreen;
        if (note != null) {
            this.note = note;
            this.guiTitle = I18n.func_135052_a((String)"notes.editNote", (Object[])new Object[0]);
        } else {
            this.note = new Note("New Note", "", Scope.getCurrentScope());
            this.guiTitle = I18n.func_135052_a((String)"notes.newNote", (Object[])new Object[0]);
        }
        this.scope = Scope.getCurrentScope();
        this.pinned = this.note.isPinned();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.setupTextFields();
        this.setupButtons();
    }

    public void func_73876_c() {
        this.noteTitleField.updateCursorCounter();
        this.noteTextField.updateScreen();
        this.insertChunkButton.field_146124_l = this.insertCoordsButton.field_146124_l = this.noteTextField.isFocused();
        this.insertBiomeButton.field_146124_l = this.insertCoordsButton.field_146124_l;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button == this.saveButton) {
                this.updateNote();
                this.note.save();
                this.field_146297_k.func_147108_a((GuiScreen)new GuiDisplayNote(this.parentScreen, this.note));
                if (this.pinned) {
                    Notes.pinnedNote = this.note;
                }
            } else if (button == this.insertBiomeButton) {
                this.insertBiome();
            } else if (button == this.insertChunkButton) {
                this.insertChunk();
            } else if (button == this.insertCoordsButton) {
                this.insertCoords();
            } else if (button == this.cancelButton) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else if (button == this.globalButton) {
                this.scope = this.scope == Scope.GLOBAL ? Scope.getCurrentScope() : Scope.GLOBAL;
                this.globalButton.field_146126_j = I18n.func_135052_a((String)"notes.global", (Object[])new Object[0]) + (this.scope == Scope.GLOBAL ? ": " + I18n.func_135052_a((String)"notes.on", (Object[])new Object[0]) : ": " + I18n.func_135052_a((String)"notes.off", (Object[])new Object[0]));
                this.updateNote();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.parentScreen);
        } else if (keyCode == 15 && this.noteTitleField.isFocused()) {
            this.noteTitleField.setFocused(false);
            this.noteTextField.setFocused(true);
        } else if (this.noteTitleField.isFocused()) {
            this.noteTitleField.textboxKeyTyped(typedChar, keyCode);
        } else if (this.noteTextField.isFocused()) {
            this.noteTextField.keyTyped(typedChar, keyCode);
        }
        this.updateNote();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.noteTitleField.mouseClicked(mouseX, mouseY, mouseButton);
        this.noteTextField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.noteTitleField.mouseReleased(mouseX, mouseY, state);
        this.noteTextField.mouseReleased(mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.noteTextField.handleMouseInput();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.guiTitle, this.field_146294_l / 2 + 60, 15, 0xFFFFFF);
        this.noteTitleField.drawTextBox();
        this.noteTextField.drawScreen(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"notes.saveAs", (Object[])new Object[]{this.note.getUncollidingSaveName(this.note.getTitle())}), this.field_146294_l / 2 + 55, 65, 0x808080);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.saveButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(0, 10, 40, 110, 20, I18n.func_135052_a((String)"notes.save", (Object[])new Object[0])));
        this.globalButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(1, 10, 65, 110, 20, I18n.func_135052_a((String)"notes.global", (Object[])new Object[0]) + ": " + (this.note.getScope() == Scope.GLOBAL ? I18n.func_135052_a((String)"notes.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"notes.off", (Object[])new Object[0]))));
        this.insertBiomeButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(2, 10, 90, 110, 20, I18n.func_135052_a((String)"notes.biome", (Object[])new Object[0])));
        this.insertChunkButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(3, 10, 115, 110, 20, I18n.func_135052_a((String)"notes.chunk", (Object[])new Object[0])));
        this.insertCoordsButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(4, 10, 140, 110, 20, I18n.func_135052_a((String)"notes.coordinates", (Object[])new Object[0])));
        this.cancelButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(5, 10, this.field_146295_m - 30, 110, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.insertBiomeButton.field_146124_l = false;
        this.insertChunkButton.field_146124_l = false;
        this.insertCoordsButton.field_146124_l = false;
    }

    private void setupTextFields() {
        this.noteTitleField = new GuiNoteTitleField(9, this.field_146289_q, 130, 40, this.field_146294_l - 140, 20);
        this.noteTitleField.setText(this.note.getTitle());
        this.noteTitleField.setFocused(true);
        this.noteTextField = new GuiNoteTextField(this.field_146289_q, 130, 85, this.field_146294_l - 140, 136, 5);
        this.noteTextField.setText(this.note.getFilteredText());
    }

    private void updateNote() {
        this.note.setTitle(this.noteTitleField.getText());
        this.note.setText(this.noteTextField.getText());
        this.note.setScope(this.scope);
    }

    private void insertBiome() {
        this.noteTextField.insert(StringUtils.fixBiomeName(this.field_146297_k.field_71441_e.func_180494_b(new BlockPos(this.field_146297_k.field_71439_g.field_70165_t, this.field_146297_k.field_71439_g.field_70163_u, this.field_146297_k.field_71439_g.field_70161_v))));
    }

    private void insertChunk() {
        this.noteTextField.insert(this.field_146297_k.field_71439_g.field_70176_ah + ", " + this.field_146297_k.field_71439_g.field_70162_ai + ", " + this.field_146297_k.field_71439_g.field_70164_aj);
    }

    private void insertCoords() {
        this.noteTextField.insert((int)this.field_146297_k.field_71439_g.field_70165_t + ", " + (int)this.field_146297_k.field_71439_g.field_70163_u + ", " + (int)this.field_146297_k.field_71439_g.field_70161_v);
    }
}

