/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.GuiEditNote;
import com.chaosthedude.notes.gui.GuiNotesButton;
import com.chaosthedude.notes.gui.GuiNotesYesNo;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDisplayNote
extends GuiScreen {
    private final GuiScreen parentScreen;
    private GuiNotesButton doneButton;
    private GuiNotesButton pinButton;
    private GuiNotesButton editButton;
    private GuiNotesButton deleteButton;
    private GuiNotesButton prevButton;
    private GuiNotesButton nextButton;
    private Note note;
    private int page;
    private List<String> pages;

    public GuiDisplayNote(GuiScreen parentScreen, Note note) {
        this.parentScreen = parentScreen;
        this.note = note;
        this.page = 0;
        this.pages = new ArrayList<String>();
        this.pages.add("");
    }

    public void func_73866_w_() {
        this.setupButtons();
        this.setupPages();
    }

    public void func_73876_c() {
        this.prevButton.field_146124_l = this.page > 0;
        this.nextButton.field_146124_l = this.page < this.pages.size() - 1;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button == this.editButton) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiEditNote(this.parentScreen, this.note));
            } else if (button == this.deleteButton) {
                this.deleteNote();
            } else if (button == this.pinButton) {
                this.togglePin();
                if (this.isPinned()) {
                    this.field_146297_k.func_147108_a(null);
                }
            } else if (button == this.doneButton) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else if (button == this.prevButton) {
                if (this.page > 0) {
                    --this.page;
                }
            } else if (button == this.nextButton && this.page < this.pages.size() - 1) {
                ++this.page;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.note.getTitle(), this.field_146294_l / 2 + 60, 15, -1);
        this.displayNote();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void displayNote() {
        this.field_146289_q.func_78279_b(this.pages.get(this.page), 160, 40, this.field_146294_l - 200, 0xFFFFFF);
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.editButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(0, 10, 40, 110, 20, I18n.func_135052_a((String)"notes.edit", (Object[])new Object[0])));
        this.deleteButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(1, 10, 65, 110, 20, I18n.func_135052_a((String)"notes.delete", (Object[])new Object[0])));
        this.pinButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(2, 10, 90, 110, 20, this.isPinned() ? I18n.func_135052_a((String)"notes.unpin", (Object[])new Object[0]) : I18n.func_135052_a((String)"notes.pin", (Object[])new Object[0])));
        this.doneButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(3, 10, this.field_146295_m - 30, 110, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.prevButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(4, 130, this.field_146295_m - 30, 20, 20, I18n.func_135052_a((String)"<", (Object[])new Object[0])));
        this.nextButton = (GuiNotesButton)this.func_189646_b(new GuiNotesButton(5, this.field_146294_l - 30, this.field_146295_m - 30, 20, 20, I18n.func_135052_a((String)">", (Object[])new Object[0])));
    }

    private void setupPages() {
        if (this.note != null) {
            List lines = ConfigHandler.wrapNote ? this.field_146289_q.func_78271_c(this.note.getFilteredText(), this.field_146294_l - 200) : StringUtils.wrapToWidth(this.note.getFilteredText(), this.field_146294_l - 200);
            this.pages = new ArrayList<String>();
            int lineCount = 0;
            String page = "";
            for (String line : lines) {
                if (lineCount > 15) {
                    this.pages.add(page);
                    page = "";
                    lineCount = 0;
                }
                page = page + line + "\n";
                ++lineCount;
            }
            if (!page.isEmpty()) {
                this.pages.add(page);
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
    }

    private boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    private void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
            this.pinButton.field_146126_j = I18n.func_135052_a((String)"notes.pin", (Object[])new Object[0]);
        } else {
            Notes.pinnedNote = this.note;
            this.pinButton.field_146126_j = I18n.func_135052_a((String)"notes.unpin", (Object[])new Object[0]);
        }
    }

    private void deleteNote() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiNotesYesNo(new GuiYesNoCallback(){

            public void func_73878_a(boolean result, int id) {
                if (result) {
                    GuiDisplayNote.this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenWorking());
                    GuiDisplayNote.this.note.delete();
                }
                GuiDisplayNote.this.field_146297_k.func_147108_a(GuiDisplayNote.this.parentScreen);
            }
        }, I18n.func_135052_a((String)"notes.confirmDelete", (Object[])new Object[0]), this.note.getTitle(), 0));
    }
}

