/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.config;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    public static String dateFormat;
    public static boolean useInGameEditor;
    public static boolean useInGameViewer;
    public static String pinnedNotePosition;
    public static double pinnedWidthScale;
    public static double pinnedHeightScale;
    public static boolean wrapNote;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "The date format used in timestamps.";
        dateFormat = ConfigHandler.loadString("notes.dateFormat", comment, dateFormat);
        comment = "If false, the system's default text editor will be used to edit notes.";
        useInGameEditor = ConfigHandler.loadBool("notes.inGameEditor", comment, useInGameEditor);
        comment = "If false, the system's default text viewer will be used to open notes.";
        useInGameViewer = ConfigHandler.loadBool("notes.inGameViewer", comment, useInGameViewer);
        comment = "The HUD position of a pinned note. Values: top_left, top_right, center_left, center_right, bottom_left, bottom_right";
        pinnedNotePosition = ConfigHandler.loadString("notes.pinnedNotePosition", comment, pinnedNotePosition);
        comment = "The maximum width of a pinned note relative to the screen's width.";
        pinnedWidthScale = ConfigHandler.loadDouble("notes.pinnedWidthScale", comment, pinnedWidthScale);
        comment = "The maximum percentage of the screen's display height that a pinned note can take up.";
        pinnedHeightScale = ConfigHandler.loadDouble("notes.pinnedHeightScale", comment, pinnedHeightScale);
        comment = "Whether or not displayed notes will be word wrapped.";
        wrapNote = ConfigHandler.loadBool("notes.wrapNote", comment, wrapNote);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static String loadString(String name, String comment, String def) {
        Property prop = config.get("general", name, def);
        prop.setComment(comment);
        return prop.getString();
    }

    public static int loadInt(String name, String comment, int def) {
        Property prop = config.get("general", name, def);
        prop.setComment(comment);
        int val = prop.getInt(def);
        if (val <= 0) {
            val = def;
            prop.set(def);
        }
        return val;
    }

    public static double loadDouble(String name, String comment, double def) {
        Property prop = config.get("general", name, def);
        prop.setComment(comment);
        double val = prop.getDouble(def);
        if (val <= 0.0) {
            val = def;
            prop.set(def);
        }
        return val;
    }

    public static boolean loadBool(String name, String comment, boolean def) {
        Property prop = config.get("general", name, def);
        prop.setComment(comment);
        return prop.getBoolean(def);
    }

    static {
        dateFormat = "M/d/yy h:mm a";
        useInGameEditor = true;
        useInGameViewer = true;
        pinnedNotePosition = "center_right";
        pinnedWidthScale = 0.2;
        pinnedHeightScale = 1.0;
        wrapNote = true;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("notes")) {
                ConfigHandler.init();
            }
        }
    }
}

