/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPGems;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.enums.BOPWoods;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.BOPBiome;
import biomesoplenty.common.biome.overworld.BOPOverworldBiome;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorLakes;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorMangroveTree;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeGenMangrove
extends BOPOverworldBiome {
    public BiomeGenMangrove() {
        super("mangrove", new BOPBiome.PropsBuilder("Mangrove").withTemperature(Float.valueOf(0.85f)).withRainfall(Float.valueOf(0.3f)).withGuiColour(7251289).withWaterColor(13500241));
        this.terrainSettings.avgHeight(62.0).heightVariation(8.0, 2.0).octaves(0.0, 1.0, 2.0, 2.0, 1.0, 0.0);
        this.addWeight(BOPClimates.HOT_SWAMP, 7);
        this.seaFloorBlock = BOPBlocks.mud.func_176223_P();
        this.field_76752_A = BOPBlocks.mud.func_176223_P();
        this.field_76753_B = BOPBlocks.mud.func_176223_P();
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.canGenerateRivers = false;
        this.field_76762_K.clear();
        this.beachBiomeLocation = null;
        this.addGenerator("quicksand", GeneratorStage.SAND, ((GeneratorLakes.Builder)new GeneratorLakes.Builder().amountPerChunk(0.2f)).liquid(BOPBlocks.sand).frozenLiquid((IBlockState)null).create());
        IBlockPosQuery emptyMud = BlockQuery.buildAnd().states(this.field_76752_A).create();
        GeneratorWeighted treeGenerator = new GeneratorWeighted(5.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("mangrove", 1, ((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)((GeneratorMangroveTree.Builder)new GeneratorMangroveTree.Builder().placeOn(emptyMud)).log(BOPWoods.MANGROVE)).leaves(BOPTrees.MANGROVE)).create());
        this.addGenerator("sapphire", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(BOPGems.SAPPHIRE)).create());
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noise) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 255; k >= 0; --k) {
                if (primer.func_177856_a(j, k, i).func_185904_a() == Material.field_151579_a) continue;
                if (k != 62 || primer.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                primer.func_177855_a(j, k, i, field_185372_h);
                break;
            }
        }
        this.func_180628_b(world, rand, primer, x, z, noise);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }
}

