/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.world.generator;

import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.WeightedRandomEnum;
import cofh.cofhworld.util.WeightedRandomNBTTag;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class WorldGenStructure
extends WorldGenerator {
    private final PlacementSettings placementSettings = new PlacementSettings();
    private final Template template = new Template();
    private final List<WeightedRandomNBTTag> templates;
    private final List<WeightedRandomBlock> ignoredBlocks;
    private List<WeightedRandomEnum<Rotation>> rots;
    private List<WeightedRandomEnum<Mirror>> mirrors;
    private INumberProvider integrity = new ConstantProvider(Float.valueOf(2.0f));

    public WorldGenStructure(List<WeightedRandomNBTTag> templates, List<WeightedRandomBlock> ignoredBlocks, boolean ignoreEntities) {
        if (templates.size() > 1) {
            this.templates = templates;
        } else {
            this.templates = null;
            this.template.func_186256_b(templates.get(0).getCompoundTag());
        }
        if (ignoredBlocks.size() > 1) {
            this.ignoredBlocks = ignoredBlocks;
        } else {
            this.ignoredBlocks = null;
            if (ignoredBlocks.size() > 0) {
                this.placementSettings.func_186225_a(ignoredBlocks.get((int)0).block);
            }
        }
        this.placementSettings.func_186222_a(ignoreEntities);
    }

    public WorldGenStructure setIntegrity(INumberProvider itg) {
        this.integrity = itg;
        return this;
    }

    public WorldGenStructure setDetails(List<WeightedRandomEnum<Rotation>> rot, List<WeightedRandomEnum<Mirror>> mir) {
        if (rot.size() == 1) {
            this.placementSettings.func_186220_a((Rotation)rot.get((int)0).value);
            rot = null;
        }
        this.rots = rot;
        if (mir.size() == 1) {
            this.placementSettings.func_186214_a((Mirror)mir.get((int)0).value);
            mir = null;
        }
        this.mirrors = mir;
        return this;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (this.templates != null) {
            this.template.func_186256_b(((WeightedRandomNBTTag)WeightedRandom.func_76271_a((Random)random, this.templates)).getCompoundTag());
        }
        this.placementSettings.func_189950_a(random);
        if (this.rots != null) {
            this.placementSettings.func_186220_a((Rotation)((WeightedRandomEnum)WeightedRandom.func_76271_a((Random)random, this.rots)).value);
        }
        if (this.mirrors != null) {
            this.placementSettings.func_186214_a((Mirror)((WeightedRandomEnum)WeightedRandom.func_76271_a((Random)random, this.mirrors)).value);
        }
        if (this.ignoredBlocks != null) {
            this.placementSettings.func_186225_a(((WeightedRandomBlock)WeightedRandom.func_76271_a((Random)random, this.ignoredBlocks)).block);
        }
        BlockPos start = this.template.func_189961_a(pos, this.placementSettings.func_186212_b(), this.placementSettings.func_186215_c());
        this.placementSettings.func_189946_a(this.integrity.floatValue(world, random, pos));
        this.template.func_189962_a(world, start, this.placementSettings, 20);
        return true;
    }
}

