/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.init;

import cofh.cofhworld.CoFHWorld;
import cofh.cofhworld.decoration.parser.BoulderParser;
import cofh.cofhworld.decoration.parser.ClusterParser;
import cofh.cofhworld.decoration.parser.DungeonParser;
import cofh.cofhworld.decoration.parser.GeodeParser;
import cofh.cofhworld.decoration.parser.LakeParser;
import cofh.cofhworld.decoration.parser.LargeVeinParser;
import cofh.cofhworld.decoration.parser.PlateParser;
import cofh.cofhworld.decoration.parser.SequentialGenParser;
import cofh.cofhworld.decoration.parser.SmallTreeParser;
import cofh.cofhworld.decoration.parser.SpikeParser;
import cofh.cofhworld.decoration.parser.StalagmiteParser;
import cofh.cofhworld.decoration.parser.StructureParser;
import cofh.cofhworld.feature.parser.CaveParser;
import cofh.cofhworld.feature.parser.DecorationParser;
import cofh.cofhworld.feature.parser.FractalParser;
import cofh.cofhworld.feature.parser.GaussianParser;
import cofh.cofhworld.feature.parser.SequentialParser;
import cofh.cofhworld.feature.parser.SurfaceParser;
import cofh.cofhworld.feature.parser.UnderfluidParser;
import cofh.cofhworld.feature.parser.UniformParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class WorldProps {
    public static File configDir;
    public static Path worldGenPath;
    public static File worldGenDir;
    public static String cannonicalWorldGenDir;
    public static File standardGenFile;
    public static final String FILE_GEN_STANDARD_INTERNAL = "00_minecraft.json";
    public static final String PATH_GEN_STANDARD_INTERNAL = "assets/cofhworld/world/00_minecraft.json";
    public static boolean disableFeatureGeneration;
    public static boolean replaceStandardGeneration;
    public static boolean enableRetroactiveGeneration;
    public static boolean enableFlatBedrock;
    public static boolean enableRetroactiveFlatBedrock;
    public static boolean forceFullRegeneration;
    public static int chanceTreeGrowth;
    public static int numBedrockLayers;
    public static int maxBedrockLayers;

    private WorldProps() {
    }

    public static void preInit() {
        WorldProps.config();
        WorldProps.initFeatures();
    }

    private static void config() {
        String category = "World";
        String comment = "If TRUE, CoFH World will not generate features at all. This option is intended for use when you want another mod to handle ore generation but do not want to blank out the various .json files yourself. Flat Bedrock may still be used.";
        disableFeatureGeneration = CoFHWorld.config.getBoolean("DisableAllGeneration", category, disableFeatureGeneration, comment);
        comment = "If TRUE, standard Minecraft ore generation will be REPLACED. Configure in the 00_minecraft.json file; standard Minecraft defaults have been provided. If you rename the 00_minecraft.json file, this option WILL NOT WORK.";
        replaceStandardGeneration = CoFHWorld.config.getBoolean("ReplaceStandardGeneration", category, replaceStandardGeneration, comment);
        comment = "If TRUE, world generation handled by CoFH World will be retroactively applied to existing chunks.";
        enableRetroactiveGeneration = CoFHWorld.config.getBoolean("RetroactiveGeneration", category, enableRetroactiveGeneration, comment);
        comment = "This adjusts the % chance that a tree will grow as normal when it is meant to. Reducing this value will mean that trees take longer to grow, on average.";
        chanceTreeGrowth = CoFHWorld.config.getInt("TreeGrowthChance", category, chanceTreeGrowth, 1, 100, comment);
        category = "World.Bedrock";
        comment = "If TRUE, the bedrock layer will be flattened.";
        enableFlatBedrock = CoFHWorld.config.getBoolean("EnableFlatBedrock", category, enableFlatBedrock, comment);
        comment = "This adjusts the number of layers of Flat Bedrock, if enabled.";
        numBedrockLayers = CoFHWorld.config.getInt("NumBedrockLayers", category, 2, 1, maxBedrockLayers, comment);
        comment = "If TRUE, Flat Bedrock will retroactively be applied to existing chunks, if retroactive generation is enabled.";
        enableRetroactiveFlatBedrock = CoFHWorld.config.getBoolean("EnableRetroactiveFlatBedrock", category, enableRetroactiveFlatBedrock, comment);
    }

    private static void initFeatures() {
        CoFHWorld.log.info("Registering default Feature Templates...");
        FeatureParser.registerTemplate("gaussian", new GaussianParser());
        FeatureParser.registerTemplate("uniform", new UniformParser());
        FeatureParser.registerTemplate("surface", new SurfaceParser());
        FeatureParser.registerTemplate("fractal", new FractalParser());
        FeatureParser.registerTemplate("decoration", new DecorationParser());
        FeatureParser.registerTemplate("underwater", new UnderfluidParser(true));
        FeatureParser.registerTemplate("underfluid", new UnderfluidParser(false));
        FeatureParser.registerTemplate("cave", new CaveParser());
        FeatureParser.registerTemplate("sequential", new SequentialParser());
        CoFHWorld.log.info("Registering default World Generators...");
        FeatureParser.registerGenerator(null, new ClusterParser(false));
        FeatureParser.registerGenerator("", new ClusterParser(false));
        FeatureParser.registerGenerator("cluster", new ClusterParser(false));
        FeatureParser.registerGenerator("sparse-cluster", new ClusterParser(true));
        FeatureParser.registerGenerator("large-vein", new LargeVeinParser());
        FeatureParser.registerGenerator("decoration", new DecorationParser());
        FeatureParser.registerGenerator("lake", new LakeParser());
        FeatureParser.registerGenerator("plate", new PlateParser());
        FeatureParser.registerGenerator("geode", new GeodeParser());
        FeatureParser.registerGenerator("spike", new SpikeParser());
        FeatureParser.registerGenerator("boulder", new BoulderParser());
        FeatureParser.registerGenerator("dungeon", new DungeonParser());
        FeatureParser.registerGenerator("stalagmite", new StalagmiteParser(false));
        FeatureParser.registerGenerator("stalactite", new StalagmiteParser(true));
        FeatureParser.registerGenerator("small-tree", new SmallTreeParser());
        FeatureParser.registerGenerator("sequential", new SequentialGenParser());
        FeatureParser.registerGenerator("structure", new StructureParser());
        CoFHWorld.log.info("Verifying or creating base world generation directory...");
        worldGenDir = new File(configDir, "/cofh/world/");
        worldGenPath = Paths.get(configDir.getPath(), new String[0]);
        try {
            cannonicalWorldGenDir = worldGenDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!worldGenDir.exists()) {
            try {
                if (!worldGenDir.mkdir()) {
                    throw new Error("Could not create directory (unspecified error).");
                }
                CoFHWorld.log.info("Created world generation directory.");
            }
            catch (Throwable t) {
                CoFHWorld.log.fatal("Could not create world generation directory:", t);
                return;
            }
        }
        standardGenFile = new File(worldGenDir, FILE_GEN_STANDARD_INTERNAL);
        try {
            if (standardGenFile.createNewFile()) {
                Utils.copyFileUsingStream(PATH_GEN_STANDARD_INTERNAL, standardGenFile);
                CoFHWorld.log.info("Created standard generation json.");
            } else if (!standardGenFile.exists()) {
                throw new Error("Unable to create standard generation json (unspecified error).");
            }
        }
        catch (Throwable t) {
            replaceStandardGeneration = false;
            CoFHWorld.log.error("Could not create standard generation json.", t);
        }
        CoFHWorld.log.info("Complete.");
    }

    static {
        disableFeatureGeneration = false;
        replaceStandardGeneration = false;
        enableRetroactiveGeneration = false;
        enableFlatBedrock = false;
        enableRetroactiveFlatBedrock = false;
        forceFullRegeneration = false;
        chanceTreeGrowth = 100;
        numBedrockLayers = 1;
        maxBedrockLayers = 8;
    }
}

