/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.parser;

import cofh.cofhworld.feature.IConfigurableFeatureGenerator;
import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.feature.generator.FeatureGenUniform;
import cofh.cofhworld.feature.parser.SequentialParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.exceptions.InvalidGeneratorException;
import cofh.cofhworld.util.numbers.INumberProvider;
import cofh.shade.com.typesafe.config.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class UniformParser
extends SequentialParser {
    protected final List<WeightedRandomBlock> defaultMaterial = this.generateDefaultMaterial();

    protected List<WeightedRandomBlock> generateDefaultMaterial() {
        return Arrays.asList(new WeightedRandomBlock(Blocks.field_150348_b, -1));
    }

    @Override
    public FeatureBase getFeature(String featureName, Config genObject, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean retrogen, IConfigurableFeatureGenerator.GenRestriction dimRes, Logger log) {
        WorldGenerator generator;
        INumberProvider numClusters = FeatureParser.parseNumberValue(genObject.getValue("cluster-count"), 0, Long.MAX_VALUE);
        try {
            generator = FeatureParser.parseGenerator(this.getDefaultGenerator(), genObject, this.defaultMaterial);
        }
        catch (InvalidGeneratorException e) {
            log.warn("Invalid generator for '{}' on line {}!", (Object)featureName, (Object)e.origin().lineNumber());
            return null;
        }
        return this.getFeature(featureName, genObject, generator, numClusters, biomeRes, retrogen, dimRes, log);
    }

    protected FeatureBase getFeature(String featureName, Config genObject, WorldGenerator gen, INumberProvider numClusters, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean retrogen, IConfigurableFeatureGenerator.GenRestriction dimRes, Logger log) {
        if (!genObject.hasPath("min-height") || !genObject.hasPath("max-height")) {
            log.error("Height parameters for 'uniform' template not specified in \"" + featureName + "\"");
            return null;
        }
        INumberProvider minHeight = FeatureParser.parseNumberValue(genObject.root().get("min-height"));
        INumberProvider maxHeight = FeatureParser.parseNumberValue(genObject.root().get("max-height"));
        return new FeatureGenUniform(featureName, gen, numClusters, minHeight, maxHeight, biomeRes, retrogen, dimRes);
    }

    protected String getDefaultGenerator() {
        return "cluster";
    }
}

