/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.generator;

import cofh.cofhworld.feature.IConfigurableFeatureGenerator;
import cofh.cofhworld.feature.generator.FeatureBase;
import cofh.cofhworld.util.numbers.ConstantProvider;
import cofh.cofhworld.util.numbers.INumberProvider;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenUniform
extends FeatureBase {
    final WorldGenerator worldGen;
    final INumberProvider count;
    final INumberProvider minY;
    final INumberProvider maxY;

    public FeatureGenUniform(String name, WorldGenerator worldGen, int count, int minY, int maxY, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        this(name, worldGen, new ConstantProvider(count), new ConstantProvider(minY), new ConstantProvider(maxY), biomeRes, regen, dimRes);
    }

    public FeatureGenUniform(String name, WorldGenerator worldGen, INumberProvider count, INumberProvider minY, INumberProvider maxY, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        int maxY;
        BlockPos pos = new BlockPos(blockX, 64, blockZ);
        int count = this.count.intValue(world, random, pos);
        int minY = Math.max(this.minY.intValue(world, random, pos), 0);
        if (minY > (maxY = this.maxY.intValue(world, random, pos))) {
            return false;
        }
        boolean generated = false;
        for (int i = 0; i < count; ++i) {
            int x = blockX + random.nextInt(16);
            int y = minY + (minY != maxY ? random.nextInt(maxY - minY) : 0);
            int z = blockZ + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z, random)) continue;
            generated |= this.worldGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        return generated;
    }
}

