/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.feature.generator;

import cofh.cofhworld.biome.BiomeInfo;
import cofh.cofhworld.biome.BiomeInfoSet;
import cofh.cofhworld.feature.IConfigurableFeatureGenerator;
import cofh.cofhworld.feature.generator.FeatureBase;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class FeatureGenSequential
extends FeatureBase {
    private final IConfigurableFeatureGenerator[] features;

    public FeatureGenSequential(String name, List<IConfigurableFeatureGenerator> features, IConfigurableFeatureGenerator.GenRestriction biomeRes, boolean regen, IConfigurableFeatureGenerator.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.features = features.toArray(new IConfigurableFeatureGenerator[features.size()]);
    }

    @Override
    public FeatureBase addBiome(BiomeInfo biome) {
        super.addBiome(biome);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.addBiome(biome);
        }
        return this;
    }

    @Override
    public FeatureBase addBiomes(BiomeInfoSet biomes) {
        super.addBiomes(biomes);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.addBiomes(biomes);
        }
        return this;
    }

    @Override
    public FeatureBase setWithVillage(boolean inVillage) {
        super.setWithVillage(inVillage);
        for (IConfigurableFeatureGenerator feature : this.features) {
            feature.setWithVillage(inVillage);
        }
        return this;
    }

    @Override
    public boolean generateFeature(Random random, int blockX, int blockZ, World world) {
        boolean r = false;
        for (IConfigurableFeatureGenerator feature : this.features) {
            r |= feature.generateFeature(random, blockX, blockZ, world);
        }
        return false;
    }
}

