/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.decoration.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.WeightedRandomEnum;
import cofh.cofhworld.util.WeightedRandomNBTTag;
import cofh.cofhworld.util.WeightedRandomString;
import cofh.cofhworld.util.exceptions.InvalidGeneratorException;
import cofh.cofhworld.world.generator.WorldGenStructure;
import cofh.shade.com.typesafe.config.Config;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class StructureParser
implements IGeneratorParser {
    protected static ArrayList<WeightedRandomEnum<Rotation>> ALL_ROTATION = Lists.newArrayList((Object[])new WeightedRandomEnum[]{new WeightedRandomEnum<Rotation>(Rotation.NONE, 1), new WeightedRandomEnum<Rotation>(Rotation.CLOCKWISE_90, 1), new WeightedRandomEnum<Rotation>(Rotation.CLOCKWISE_180, 1), new WeightedRandomEnum<Rotation>(Rotation.COUNTERCLOCKWISE_90, 1)});
    protected static ArrayList<WeightedRandomEnum<Mirror>> NO_MIRROR = new ArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) throws InvalidGeneratorException {
        ArrayList<WeightedRandomNBTTag> tags = new ArrayList<WeightedRandomNBTTag>();
        if (!genObject.hasPath("structure")) {
            log.error("Tag `structure` missing for `structure` generator!");
            throw new InvalidGeneratorException("Missing `structure` tag", genObject.origin());
        }
        ArrayList<WeightedRandomString> files = new ArrayList<WeightedRandomString>();
        String dir = FilenameUtils.getFullPath((String)genObject.origin().filename());
        if (!FeatureParser.parseWeightedStringList(genObject.getValue("structure"), files)) {
            log.error("Tag `structure` invalid!");
            throw new InvalidGeneratorException("Invalid `structure` tag", genObject.getValue("structure").origin());
        }
        if (files.size() == 0) {
            log.error("No structures provided for `structure` geenrator!");
            throw new InvalidGeneratorException("Empty `structure` array", genObject.getValue("structure").origin());
        }
        tags.ensureCapacity(files.size());
        for (WeightedRandomString file : files) {
            String path = FilenameUtils.normalize((String)(dir + file.value));
            try {
                if (!FilenameUtils.directoryContains((String)WorldProps.cannonicalWorldGenDir, (String)path)) {
                    throw new InvalidGeneratorException("Structure NBT file not contained in worldgen folder", genObject.getValue("structure").origin());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                FileInputStream stream = new FileInputStream(new File(path));
                tags.add(new WeightedRandomNBTTag(file.field_76292_a, (NBTBase)CompressedStreamTools.func_74796_a((InputStream)stream)));
                IOUtils.closeQuietly((InputStream)stream);
            }
            catch (IOException e) {
                throw new InvalidGeneratorException("Structure NBT file cannot be read.", genObject.getValue("structure").origin()).causedBy(e);
            }
        }
        resList.clear();
        if (genObject.hasPath("ignored-block") && !FeatureParser.parseResList(genObject.getValue("ignored-block"), resList, false)) {
            log.warn("Error parsing `ignored-block`, generating all template blocks instead");
            resList.clear();
        }
        boolean ignoreEntities = false;
        if (genObject.hasPath("ignore-entities")) {
            ignoreEntities = genObject.getBoolean("ignore-entities");
        }
        WorldGenStructure gen = new WorldGenStructure(tags, resList, ignoreEntities);
        if (genObject.hasPath("integrity")) {
            gen.setIntegrity(FeatureParser.parseNumberValue(genObject.getValue("integrity"), 0.0, 1.01));
        }
        ArrayList rots = ALL_ROTATION;
        if (genObject.hasPath("rotation")) {
            rots = new ArrayList(4);
            if (!FeatureParser.parseWeightedEnumList(genObject.getValue("rotation"), rots, Rotation.class)) {
                rots.clear();
            }
        }
        ArrayList mirror = NO_MIRROR;
        if (genObject.hasPath("mirror")) {
            mirror = new ArrayList(3);
            if (!FeatureParser.parseWeightedEnumList(genObject.getValue("mirror"), mirror, Mirror.class)) {
                mirror.clear();
            }
        }
        gen.setDetails(rots, mirror);
        return gen;
    }

    @Override
    public boolean isMeta() {
        return true;
    }
}

