/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.decoration.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.init.FeatureParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.exceptions.InvalidGeneratorException;
import cofh.cofhworld.world.generator.WorldGenSequential;
import cofh.shade.com.typesafe.config.Config;
import cofh.shade.com.typesafe.config.ConfigValue;
import cofh.shade.com.typesafe.config.ConfigValueType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class SequentialGenParser
implements IGeneratorParser {
    @Override
    public boolean isMeta() {
        return true;
    }

    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) throws InvalidGeneratorException {
        ArrayList<WorldGenerator> gens;
        ConfigValue genData = genObject.getValue("generators");
        if (genData.valueType() == ConfigValueType.LIST) {
            List<? extends Config> list = genObject.getConfigList("generators");
            gens = new ArrayList(list.size());
            for (Config config : list) {
                WorldGenerator gen = FeatureParser.parseGenerator(name, config.atKey("generator"), matList);
                gens.add(gen);
            }
        } else if (genData.valueType() == ConfigValueType.OBJECT) {
            gens = new ArrayList<WorldGenerator>(1);
            WorldGenerator gen = FeatureParser.parseGenerator(name, genObject.getConfig("generators").atKey("generator"), matList);
            gens.add(gen);
        } else {
            log.error("Invalid object type for generator on line {}.", (Object)genData.origin().lineNumber());
            throw new InvalidGeneratorException("Invalid object type", genData.origin());
        }
        return new WorldGenSequential(gens);
    }
}

