/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.decoration.parser;

import cofh.cofhworld.decoration.IGeneratorParser;
import cofh.cofhworld.util.WeightedRandomBlock;
import cofh.cofhworld.util.exceptions.InvalidGeneratorException;
import cofh.cofhworld.world.generator.WorldGenMinableCluster;
import cofh.cofhworld.world.generator.WorldGenSparseMinableCluster;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class ClusterParser
implements IGeneratorParser {
    private final boolean sparse;

    public ClusterParser(boolean sparse) {
        this.sparse = sparse;
    }

    @Override
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedRandomBlock> resList, List<WeightedRandomBlock> matList) throws InvalidGeneratorException {
        int clusterSize = genObject.getInt("cluster-size");
        if (clusterSize <= 0) {
            log.warn("Invalid `cluster-size` for generator '{}'", (Object)name);
            throw new InvalidGeneratorException("Invalid `cluster-size`", genObject.getValue("cluster-size").origin());
        }
        if (this.sparse) {
            return new WorldGenSparseMinableCluster(resList, clusterSize, matList);
        }
        return new WorldGenMinableCluster(resList, clusterSize, matList);
    }
}

