/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.net.Message;
import net.montoyo.wd.net.client.CMessageACResult;
import net.montoyo.wd.utilities.NameUUIDPair;

@Message(messageId=5, side=Side.SERVER)
public class SMessageACQuery
implements IMessage,
Runnable {
    private EntityPlayerMP player;
    private String beginning;
    private boolean matchExact;

    public SMessageACQuery() {
    }

    public SMessageACQuery(String beg, boolean exact) {
        this.beginning = beg;
        this.matchExact = exact;
    }

    public void fromBytes(ByteBuf buf) {
        this.beginning = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.matchExact = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.beginning);
        buf.writeBoolean(this.matchExact);
    }

    @Override
    public void run() {
        NameUUIDPair[] result;
        GameProfile[] profiles = WebDisplays.PROXY.getOnlineGameProfiles();
        if (this.matchExact) {
            result = (NameUUIDPair[])Arrays.stream(profiles).filter(gp -> gp.getName().equalsIgnoreCase(this.beginning)).map(NameUUIDPair::new).toArray(NameUUIDPair[]::new);
        } else {
            String lBeg = this.beginning.toLowerCase();
            result = (NameUUIDPair[])Arrays.stream(profiles).filter(gp -> gp.getName().toLowerCase().startsWith(lBeg)).map(NameUUIDPair::new).toArray(NameUUIDPair[]::new);
        }
        WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageACResult(result), this.player);
    }

    public static class Handler
    implements IMessageHandler<SMessageACQuery, IMessage> {
        public IMessage onMessage(SMessageACQuery msg, MessageContext ctx) {
            msg.player = ctx.getServerHandler().field_147369_b;
            ((WorldServer)((SMessageACQuery)msg).player.field_70170_p).func_152344_a((Runnable)msg);
            return null;
        }
    }
}

