/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryCallback;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.api.MCEFApi;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.JSQueryDispatcher;
import net.montoyo.wd.client.ResourceModelPair;
import net.montoyo.wd.client.StaticStateMapper;
import net.montoyo.wd.client.WDScheme;
import net.montoyo.wd.client.gui.GuiMinePad;
import net.montoyo.wd.client.gui.GuiScreenConfig;
import net.montoyo.wd.client.gui.GuiSetURL2;
import net.montoyo.wd.client.gui.RenderRecipe;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.renderers.IItemRenderer;
import net.montoyo.wd.client.renderers.IModelBaker;
import net.montoyo.wd.client.renderers.LaserPointerRenderer;
import net.montoyo.wd.client.renderers.MinePadRenderer;
import net.montoyo.wd.client.renderers.ScreenBaker;
import net.montoyo.wd.client.renderers.ScreenRenderer;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.HasAdvancement;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.item.ItemMulti;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.net.server.SMessagePadCtrl;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;
import org.lwjgl.input.Keyboard;
import paulscode.sound.SoundSystemConfig;

public class ClientProxy
extends SharedProxy
implements IResourceManagerReloadListener,
IDisplayHandler,
IJSQueryHandler {
    private Minecraft mc;
    private final ArrayList<ResourceModelPair> modelBakers = new ArrayList();
    private API mcef;
    private MinePadRenderer minePadRenderer;
    private JSQueryDispatcher jsDispatcher;
    private LaserPointerRenderer laserPointerRenderer;
    private GuiScreen nextScreen;
    private boolean isF1Down;
    private int miniservPort;
    private boolean msClientStarted;
    private final Field advancementToProgressField = ClientProxy.findAdvancementToProgressField();
    private ClientAdvancementManager lastAdvMgr;
    private Map advancementToProgress;
    private TileEntityScreen pointedScreen;
    private BlockSide pointedScreenSide;
    private long lastPointPacket;
    private final ArrayList<TileEntityScreen> screenTracking = new ArrayList();
    private int lastTracked = 0;
    private final HashMap<Integer, PadData> padMap = new HashMap();
    private final ArrayList<PadData> padList = new ArrayList();
    private int minePadTickCounter = 0;

    @Override
    public void preInit() {
        this.mc = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerCustomBlockBaker(new ScreenBaker(), (Block)WebDisplays.INSTANCE.blockScreen);
        this.mcef = MCEFApi.getAPI();
        if (this.mcef != null) {
            this.mcef.registerScheme("wd", WDScheme.class, true, false, false);
        }
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityScreen.class, (TileEntitySpecialRenderer)new ScreenRenderer());
        this.jsDispatcher = new JSQueryDispatcher(this);
        this.minePadRenderer = new MinePadRenderer();
        this.laserPointerRenderer = new LaserPointerRenderer();
    }

    @Override
    public void postInit() {
        ((SimpleReloadableResourceManager)this.mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        if (this.mcef == null) {
            throw new RuntimeException("MCEF is missing");
        }
        this.mcef.registerDisplayHandler((IDisplayHandler)this);
        this.mcef.registerJSQueryHandler((IJSQueryHandler)this);
        ClientProxy.findAdvancementToProgressField();
    }

    @Override
    public World getWorld(int dim) {
        WorldClient ret = this.mc.field_71441_e;
        if (dim == Integer.MAX_VALUE) {
            return ret;
        }
        if (ret.field_73011_w.getDimension() != dim) {
            throw new RuntimeException("Can't get non-current dimension " + dim + " from client.");
        }
        return ret;
    }

    @Override
    public void enqueue(Runnable r) {
        this.mc.func_152344_a(r);
    }

    @Override
    public void displayGui(GuiData data) {
        GuiScreen gui = data.createGui(this.mc.field_71462_r, (World)this.mc.field_71441_e);
        if (gui != null) {
            this.mc.func_147108_a(gui);
        }
    }

    @Override
    public void trackScreen(TileEntityScreen tes, boolean track) {
        int idx = -1;
        for (int i = 0; i < this.screenTracking.size(); ++i) {
            if (this.screenTracking.get(i) != tes) continue;
            idx = i;
            break;
        }
        if (track) {
            if (idx < 0) {
                this.screenTracking.add(tes);
            }
        } else if (idx >= 0) {
            this.screenTracking.remove(idx);
        }
    }

    @Override
    public void onAutocompleteResult(NameUUIDPair[] pairs) {
        if (this.mc.field_71462_r != null && this.mc.field_71462_r instanceof WDScreen) {
            if (pairs.length == 0) {
                ((WDScreen)this.mc.field_71462_r).onAutocompleteFailure();
            } else {
                ((WDScreen)this.mc.field_71462_r).onAutocompleteResult(pairs);
            }
        }
    }

    @Override
    public GameProfile[] getOnlineGameProfiles() {
        return new GameProfile[]{this.mc.field_71439_g.func_146103_bH()};
    }

    @Override
    public void screenUpdateResolutionInGui(Vector3i pos, BlockSide side, Vector2i res) {
        GuiScreenConfig gsc;
        if (this.mc.field_71462_r != null && this.mc.field_71462_r instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)this.mc.field_71462_r).isForBlock(pos.toBlock(), side)) {
            gsc.updateResolution(res);
        }
    }

    @Override
    public void screenUpdateRotationInGui(Vector3i pos, BlockSide side, Rotation rot) {
        GuiScreenConfig gsc;
        if (this.mc.field_71462_r != null && this.mc.field_71462_r instanceof GuiScreenConfig && (gsc = (GuiScreenConfig)this.mc.field_71462_r).isForBlock(pos.toBlock(), side)) {
            gsc.updateRotation(rot);
        }
    }

    @Override
    public void displaySetPadURLGui(String padURL) {
        this.mc.func_147108_a((GuiScreen)new GuiSetURL2(padURL));
    }

    @Override
    public void openMinePadGui(int padId) {
        PadData pd = this.padMap.get(padId);
        if (pd != null && pd.view != null) {
            this.mc.func_147108_a((GuiScreen)new GuiMinePad(pd));
        }
    }

    @Override
    @Nonnull
    public HasAdvancement hasClientPlayerAdvancement(@Nonnull ResourceLocation rl) {
        if (this.advancementToProgressField != null && this.mc.field_71439_g != null && this.mc.field_71439_g.field_71174_a != null) {
            ClientAdvancementManager cam = this.mc.field_71439_g.field_71174_a.func_191982_f();
            Advancement adv = cam.func_194229_a().func_192084_a(rl);
            if (adv == null) {
                return HasAdvancement.DONT_KNOW;
            }
            if (this.lastAdvMgr != cam) {
                this.lastAdvMgr = cam;
                try {
                    this.advancementToProgress = (Map)this.advancementToProgressField.get(cam);
                }
                catch (Throwable t) {
                    Log.warningEx("Could not get ClientAdvancementManager.advancementToProgress field", t, new Object[0]);
                    this.advancementToProgress = null;
                    return HasAdvancement.DONT_KNOW;
                }
            }
            if (this.advancementToProgress == null) {
                return HasAdvancement.DONT_KNOW;
            }
            Object progress = this.advancementToProgress.get(adv);
            if (progress == null) {
                return HasAdvancement.NO;
            }
            if (!(progress instanceof AdvancementProgress)) {
                Log.warning("The ClientAdvancementManager.advancementToProgress map does not contain AdvancementProgress instances", new Object[0]);
                this.advancementToProgress = null;
                return HasAdvancement.DONT_KNOW;
            }
            return ((AdvancementProgress)progress).func_192105_a() ? HasAdvancement.YES : HasAdvancement.NO;
        }
        return HasAdvancement.DONT_KNOW;
    }

    @Override
    public MinecraftServer getServer() {
        return this.mc.func_71401_C();
    }

    @Override
    public void handleJSResponseSuccess(int reqId, JSServerRequest type, byte[] data) {
        JSQueryDispatcher.ServerQuery q = this.jsDispatcher.fulfillQuery(reqId);
        if (q == null) {
            Log.warning("Received success response for invalid query ID %d of type %s", reqId, type.toString());
        } else if (type == JSServerRequest.CLEAR_REDSTONE || type == JSServerRequest.SET_REDSTONE_AT) {
            q.success("{\"status\":\"success\"}");
        } else {
            Log.warning("Received success response for query ID %d, but type is invalid", reqId);
        }
    }

    @Override
    public void handleJSResponseError(int reqId, JSServerRequest type, int errCode, String err) {
        JSQueryDispatcher.ServerQuery q = this.jsDispatcher.fulfillQuery(reqId);
        if (q == null) {
            Log.warning("Received error response for invalid query ID %d of type %s", reqId, type.toString());
        } else {
            q.error(errCode, err);
        }
    }

    @Override
    public void setMiniservClientPort(int port) {
        this.miniservPort = port;
    }

    @Override
    public void startMiniservClient() {
        if (this.miniservPort <= 0) {
            Log.warning("Can't start miniserv client: miniserv is disabled", new Object[0]);
            return;
        }
        if (this.mc.field_71439_g == null) {
            Log.warning("Can't start miniserv client: player is null", new Object[0]);
            return;
        }
        SocketAddress saddr = this.mc.field_71439_g.field_71174_a.func_147298_b().channel().remoteAddress();
        if (saddr == null || !(saddr instanceof InetSocketAddress)) {
            Log.warning("Miniserv client: remote address is not inet, assuming local address", new Object[0]);
            saddr = new InetSocketAddress("127.0.0.1", 1234);
        }
        InetSocketAddress msAddr = new InetSocketAddress(((InetSocketAddress)saddr).getAddress(), this.miniservPort);
        Client.getInstance().start(msAddr);
        this.msClientStarted = true;
    }

    @Override
    public boolean isMiniservDisabled() {
        return this.miniservPort <= 0;
    }

    @Override
    public void closeGui(BlockPos bp, BlockSide bs) {
        WDScreen scr;
        if (this.mc.field_71462_r instanceof WDScreen && (scr = (WDScreen)this.mc.field_71462_r).isForBlock(bp, bs)) {
            this.mc.func_147108_a(null);
        }
    }

    @Override
    public void renderRecipes() {
        this.nextScreen = new RenderRecipe();
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public void func_110549_a(@Nonnull IResourceManager rm) {
        Log.info("Resource manager reload: clearing GUI cache...", new Object[0]);
        GuiLoader.clearCache();
    }

    public void onAddressChange(IBrowser browser, String url) {
        if (browser != null) {
            long t = System.currentTimeMillis();
            for (PadData pd : this.padList) {
                if (pd.view != browser || t - pd.lastURLSent < 1000L) continue;
                if (WebDisplays.isSiteBlacklisted(url)) {
                    pd.view.loadURL("mod://webdisplays/blacklisted.html");
                    break;
                }
                pd.lastURLSent = t;
                WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessagePadCtrl(pd.id, url));
                break;
            }
            for (TileEntityScreen tes : this.screenTracking) {
                tes.updateClientSideURL(browser, url);
            }
        }
    }

    public void onTitleChange(IBrowser browser, String title) {
    }

    public void onTooltip(IBrowser browser, String text) {
    }

    public void onStatusMessage(IBrowser browser, String value) {
    }

    public boolean handleQuery(IBrowser browser, long queryId, String query, boolean persistent, IJSQueryCallback cb) {
        if (browser != null && persistent && query != null && cb != null && (query = query.toLowerCase()).startsWith("webdisplays_")) {
            String args;
            int parenthesis = (query = query.substring(12)).indexOf(40);
            if (parenthesis < 0) {
                args = null;
            } else {
                if (query.indexOf(41) != query.length() - 1) {
                    cb.failure(400, "Malformed request");
                    return true;
                }
                args = query.substring(parenthesis + 1, query.length() - 1);
                query = query.substring(0, parenthesis);
            }
            if (this.jsDispatcher.canHandleQuery(query)) {
                this.jsDispatcher.enqueueQuery(browser, query, args, cb);
            } else {
                cb.failure(404, "Unknown WebDisplays query");
            }
            return true;
        }
        return false;
    }

    public void cancelQuery(IBrowser browser, long queryId) {
    }

    @SubscribeEvent
    public void onStitchTextures(TextureStitchEvent.Pre ev) {
        TextureMap texMap = ev.getMap();
        if (texMap == this.mc.func_147117_R()) {
            for (ResourceModelPair pair : this.modelBakers) {
                pair.getModel().loadTextures(texMap);
            }
        }
    }

    @SubscribeEvent
    public void onBakeModel(ModelBakeEvent ev) {
        for (ResourceModelPair pair : this.modelBakers) {
            ev.getModelRegistry().func_82595_a((Object)pair.getResourceLocation(), (Object)pair.getModel());
        }
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent ev) {
        WebDisplays wd = WebDisplays.INSTANCE;
        this.registerItemModel((Item)wd.blockScreen.getItem(), 0, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)wd.blockPeripheral.getItem(), (int)0, (ModelResourceLocation)new ModelResourceLocation("webdisplays:kb_inv", "normal"));
        this.registerItemModel((Item)wd.blockPeripheral.getItem(), 1, "facing=2,type=ccinterface");
        this.registerItemModel((Item)wd.blockPeripheral.getItem(), 2, "facing=2,type=cointerface");
        this.registerItemModel((Item)wd.blockPeripheral.getItem(), 3, "facing=0,type=remotectrl");
        this.registerItemModel((Item)wd.blockPeripheral.getItem(), 7, "facing=0,type=redstonectrl");
        this.registerItemModel((Item)wd.blockPeripheral.getItem(), 11, "facing=0,type=server");
        this.registerItemModel(wd.itemScreenCfg, 0, "normal");
        this.registerItemModel(wd.itemOwnerThief, 0, "normal");
        this.registerItemModel(wd.itemLinker, 0, "normal");
        this.registerItemModel(wd.itemMinePad, 0, "normal");
        this.registerItemModel(wd.itemMinePad, 1, "normal");
        this.registerItemModel(wd.itemLaserPointer, 0, "normal");
        this.registerItemMultiModels(wd.itemUpgrade);
        this.registerItemMultiModels(wd.itemCraftComp);
        this.registerItemMultiModels(wd.itemAdvIcon);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            if (Keyboard.isKeyDown((int)59)) {
                if (!this.isF1Down) {
                    Slot slot;
                    this.isF1Down = true;
                    String wikiName = null;
                    if (this.mc.field_71462_r instanceof WDScreen) {
                        wikiName = ((WDScreen)this.mc.field_71462_r).getWikiPageName();
                    } else if (this.mc.field_71462_r instanceof GuiContainer && (slot = ((GuiContainer)this.mc.field_71462_r).getSlotUnderMouse()) != null && slot.func_75216_d() && slot.func_75211_c().func_77973_b() instanceof WDItem) {
                        wikiName = ((WDItem)slot.func_75211_c().func_77973_b()).getWikiName(slot.func_75211_c());
                    }
                    if (wikiName != null) {
                        this.mcef.openExampleBrowser("https://montoyo.net/wdwiki/index.php/" + wikiName);
                    }
                }
            } else if (this.isF1Down) {
                this.isF1Down = false;
            }
            if (this.nextScreen != null && this.mc.field_71462_r == null) {
                this.mc.func_147108_a(this.nextScreen);
                this.nextScreen = null;
            }
            if (this.mc.field_71439_g != null && !this.screenTracking.isEmpty()) {
                int id = this.lastTracked % this.screenTracking.size();
                ++this.lastTracked;
                TileEntityScreen tes = this.screenTracking.get(id);
                double dist2 = this.mc.field_71439_g.func_174818_b(tes.func_174877_v());
                if (tes.isLoaded()) {
                    if (dist2 > WebDisplays.INSTANCE.unloadDistance2) {
                        tes.unload();
                    } else if (WebDisplays.INSTANCE.enableSoundDistance) {
                        tes.updateTrackDistance(dist2, SoundSystemConfig.getMasterGain());
                    }
                } else if (dist2 <= WebDisplays.INSTANCE.loadDistance2) {
                    tes.load();
                }
            }
            if (++this.minePadTickCounter >= 10) {
                this.minePadTickCounter = 0;
                EntityPlayerSP ep = this.mc.field_71439_g;
                for (PadData pd : this.padList) {
                    pd.isInHotbar = false;
                }
                if (ep != null) {
                    this.updateInventory((NonNullList<ItemStack>)ep.field_71071_by.field_70462_a, ep.func_184586_b(EnumHand.MAIN_HAND), 9);
                    this.updateInventory((NonNullList<ItemStack>)ep.field_71071_by.field_184439_c, ep.func_184586_b(EnumHand.OFF_HAND), 1);
                }
                for (int i = this.padList.size() - 1; i >= 0; --i) {
                    PadData pd = this.padList.get(i);
                    if (pd.isInHotbar) continue;
                    pd.view.close();
                    pd.view = null;
                    this.padList.remove(i);
                    this.padMap.remove(pd.id);
                }
            }
            boolean raycastHit = false;
            if (this.mc.field_71439_g != null && this.mc.field_71441_e != null && this.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == WebDisplays.INSTANCE.itemLaserPointer && this.mc.field_71474_y.field_74313_G.func_151470_d() && (this.mc.field_71476_x == null || this.mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK)) {
                this.laserPointerRenderer.isOn = true;
                RayTraceResult result = this.raycast(64.0);
                if (result != null) {
                    BlockPos bpos = result.func_178782_a();
                    if (result.field_72313_a == RayTraceResult.Type.BLOCK && this.mc.field_71441_e.func_180495_p(bpos).func_177230_c() == WebDisplays.INSTANCE.blockScreen) {
                        Vector3i pos = new Vector3i(result.func_178782_a());
                        BlockSide side = BlockSide.values()[result.field_178784_b.ordinal()];
                        Multiblock.findOrigin((IBlockAccess)this.mc.field_71441_e, pos, side, null);
                        TileEntityScreen te = (TileEntityScreen)this.mc.field_71441_e.func_175625_s(pos.toBlock());
                        if (te != null && te.hasUpgrade(side, DefaultUpgrade.LASER_MOUSE)) {
                            Vector2i tmp;
                            float hitZ;
                            float hitY;
                            float hitX;
                            TileEntityScreen.Screen scr = te.getScreen(side);
                            if (scr.browser != null && BlockScreen.hit2pixels(side, bpos, pos, scr, hitX = (float)result.field_72307_f.field_72450_a - (float)bpos.func_177958_n(), hitY = (float)result.field_72307_f.field_72448_b - (float)bpos.func_177956_o(), hitZ = (float)result.field_72307_f.field_72449_c - (float)bpos.func_177952_p(), tmp = new Vector2i())) {
                                this.laserClick(te, side, scr, tmp);
                                raycastHit = true;
                            }
                        }
                    }
                }
            } else {
                this.laserPointerRenderer.isOn = false;
            }
            if (!raycastHit) {
                this.deselectScreen();
            }
            this.jsDispatcher.handleQueries();
            if (this.msClientStarted && this.mc.field_71439_g == null) {
                this.msClientStarted = false;
                Client.getInstance().stop();
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayerHand(RenderSpecificHandEvent ev) {
        IItemRenderer renderer;
        Item item = ev.getItemStack().func_77973_b();
        if (item == WebDisplays.INSTANCE.itemMinePad) {
            renderer = this.minePadRenderer;
        } else if (item == WebDisplays.INSTANCE.itemLaserPointer) {
            renderer = this.laserPointerRenderer;
        } else {
            return;
        }
        EnumHandSide handSide = this.mc.field_71439_g.func_184591_cq();
        if (ev.getHand() == EnumHand.OFF_HAND) {
            handSide = handSide.func_188468_a();
        }
        renderer.render(ev.getItemStack(), handSide == EnumHandSide.RIGHT ? 1.0f : -1.0f, ev.getSwingProgress(), ev.getEquipProgress());
        ev.setCanceled(true);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload ev) {
        Log.info("World unloaded; killing screens...", new Object[0]);
        int dim = ev.getWorld().field_73011_w.getDimension();
        for (int i = this.screenTracking.size() - 1; i >= 0; --i) {
            if (this.screenTracking.get((int)i).func_145831_w().field_73011_w.getDimension() != dim) continue;
            this.screenTracking.remove(i).unload();
        }
    }

    private void laserClick(TileEntityScreen tes, BlockSide side, TileEntityScreen.Screen scr, Vector2i hit) {
        if (this.pointedScreen == tes && this.pointedScreenSide == side) {
            long t = System.currentTimeMillis();
            if (t - this.lastPointPacket >= 100L) {
                this.lastPointPacket = t;
                WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.vec2(tes, side, 9, hit));
            }
        } else {
            this.deselectScreen();
            this.pointedScreen = tes;
            this.pointedScreenSide = side;
            WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.vec2(tes, side, 8, hit));
        }
    }

    private void deselectScreen() {
        if (this.pointedScreen != null && this.pointedScreenSide != null) {
            WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.laserUp(this.pointedScreen, this.pointedScreenSide));
            this.pointedScreen = null;
            this.pointedScreenSide = null;
        }
    }

    private RayTraceResult raycast(double dist) {
        Vec3d start = this.mc.field_71439_g.func_174824_e(1.0f);
        Vec3d lookVec = this.mc.field_71439_g.func_70676_i(1.0f);
        Vec3d end = start.func_72441_c(lookVec.field_72450_a * dist, lookVec.field_72448_b * dist, lookVec.field_72449_c * dist);
        return this.mc.field_71441_e.func_147447_a(start, end, true, true, false);
    }

    private void updateInventory(NonNullList<ItemStack> inv, ItemStack heldStack, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            NBTTagCompound tag;
            ItemStack item = (ItemStack)inv.get(i);
            if (item.func_77973_b() != WebDisplays.INSTANCE.itemMinePad || (tag = item.func_77978_p()) == null || !tag.func_74764_b("PadID")) continue;
            this.updatePad(tag.func_74762_e("PadID"), tag, item == heldStack);
        }
    }

    private void registerCustomBlockBaker(IModelBaker baker, Block block0) {
        ModelResourceLocation normalLoc = new ModelResourceLocation(block0.getRegistryName(), "normal");
        ResourceModelPair pair = new ResourceModelPair(normalLoc, baker);
        this.modelBakers.add(pair);
        ModelLoader.setCustomStateMapper((Block)block0, (IStateMapper)new StaticStateMapper(normalLoc));
    }

    private void registerItemModel(Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    private void registerItemMultiModels(ItemMulti item) {
        Enum[] values = item.getEnumValues();
        for (int i = 0; i < values.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString() + '_' + values[i], "normal"));
        }
    }

    private void updatePad(int id, NBTTagCompound tag, boolean isSelected) {
        PadData pd = this.padMap.get(id);
        if (pd != null) {
            pd.isInHotbar = true;
        } else if (isSelected && tag.func_74764_b("PadURL")) {
            pd = new PadData(tag.func_74779_i("PadURL"), id);
            this.padMap.put(id, pd);
            this.padList.add(pd);
        }
    }

    public MinePadRenderer getMinePadRenderer() {
        return this.minePadRenderer;
    }

    public PadData getPadByID(int id) {
        return this.padMap.get(id);
    }

    public API getMCEF() {
        return this.mcef;
    }

    public boolean findScreenFromBrowser(IBrowser browser, ScreenSidePair pair) {
        for (TileEntityScreen tes : this.screenTracking) {
            for (int i = 0; i < tes.screenCount(); ++i) {
                TileEntityScreen.Screen scr = tes.getScreen(i);
                if (scr.browser != browser) continue;
                pair.tes = tes;
                pair.side = scr.side;
                return true;
            }
        }
        return false;
    }

    private static Field findAdvancementToProgressField() {
        Field[] fields = ClientAdvancementManager.class.getDeclaredFields();
        Optional<Field> result = Arrays.stream(fields).filter(f -> f.getType() == Map.class).findAny();
        if (result.isPresent()) {
            try {
                Field ret = result.get();
                ret.setAccessible(true);
                return ret;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Log.warning("ClientAdvancementManager.advancementToProgress field could not be found", new Object[0]);
        return null;
    }

    public static final class ScreenSidePair {
        public TileEntityScreen tes;
        public BlockSide side;
    }

    public class PadData {
        public IBrowser view;
        private boolean isInHotbar;
        private final int id;
        private long lastURLSent;

        private PadData(String url, int id) {
            this.view = ClientProxy.this.mcef.createBrowser(WebDisplays.applyBlacklist(url));
            this.view.resize((int)WebDisplays.INSTANCE.padResX, (int)WebDisplays.INSTANCE.padResY);
            this.isInHotbar = true;
            this.id = id;
        }
    }
}

