/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.block.BlockKeyboardRight;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.core.AdvancementIcon;
import net.montoyo.wd.core.CraftComponent;
import net.montoyo.wd.core.Criterion;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.core.HasAdvancement;
import net.montoyo.wd.core.WDCreativeTab;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.item.ItemCraftComponent;
import net.montoyo.wd.item.ItemLaserPointer;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.item.ItemMinePad2;
import net.montoyo.wd.item.ItemMulti;
import net.montoyo.wd.item.ItemOwnershipThief;
import net.montoyo.wd.item.ItemScreenConfigurator;
import net.montoyo.wd.item.ItemUpgrade;
import net.montoyo.wd.miniserv.server.Server;
import net.montoyo.wd.net.Messages;
import net.montoyo.wd.net.client.CMessageServerInfo;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Util;

@Mod(modid="webdisplays", version="1.0", dependencies="required-after:mcef;after:opencomputers;", acceptedMinecraftVersions="[1.12.2]")
public class WebDisplays {
    public static final String MOD_VERSION = "1.0";
    @Mod.Instance(owner="webdisplays")
    public static WebDisplays INSTANCE;
    @SidedProxy(serverSide="net.montoyo.wd.SharedProxy", clientSide="net.montoyo.wd.client.ClientProxy")
    public static SharedProxy PROXY;
    public static SimpleNetworkWrapper NET_HANDLER;
    public static WDCreativeTab CREATIVE_TAB;
    public static final ResourceLocation ADV_PAD_BREAK;
    public static final String BLACKLIST_URL = "mod://webdisplays/blacklisted.html";
    public BlockScreen blockScreen;
    public BlockPeripheral blockPeripheral;
    public BlockKeyboardRight blockKbRight;
    public ItemScreenConfigurator itemScreenCfg;
    public ItemOwnershipThief itemOwnerThief;
    public ItemLinker itemLinker;
    public ItemMinePad2 itemMinePad;
    public ItemUpgrade itemUpgrade;
    public ItemLaserPointer itemLaserPointer;
    public ItemCraftComponent itemCraftComp;
    public ItemMulti itemAdvIcon;
    public SoundEvent soundTyping;
    public SoundEvent soundUpgradeAdd;
    public SoundEvent soundUpgradeDel;
    public SoundEvent soundScreenCfg;
    public SoundEvent soundServer;
    public SoundEvent soundIronic;
    public Criterion criterionPadBreak;
    public Criterion criterionUpgradeScreen;
    public Criterion criterionLinkPeripheral;
    public Criterion criterionKeyboardCat;
    public static final double PAD_RATIO = 1.9666666666666666;
    public String homePage;
    public double padResX;
    public double padResY;
    private int lastPadId = 0;
    public boolean doHardRecipe;
    private boolean hasOC;
    private String[] blacklist;
    public boolean disableOwnershipThief;
    public double unloadDistance2;
    public double loadDistance2;
    public int maxResX;
    public int maxResY;
    public int maxScreenX;
    public int maxScreenY;
    public int miniservPort;
    public long miniservQuota;
    public boolean enableSoundDistance;
    public float ytVolume;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent ev) {
        Configuration cfg = new Configuration(ev.getSuggestedConfigurationFile());
        cfg.load();
        Property blacklist = cfg.get("main", "blacklist", new String[0]);
        Property padHeight = cfg.get("main", "padHeight", 480);
        Property hardRecipe = cfg.get("main", "hardRecipes", true);
        Property homePage = cfg.get("main", "homepage", "mod://webdisplays/main.html");
        Property disableOT = cfg.get("main", "disableOwnershipThief", false);
        Property maxResX = cfg.get("main", "maxResolutionX", 1920);
        Property maxResY = cfg.get("main", "maxResolutionY", 1080);
        Property miniservPort = cfg.get("main", "miniservPort", 25566);
        Property miniservQuota = cfg.get("main", "miniservQuota", 1024);
        Property maxScreenX = cfg.get("main", "maxScreenSizeX", 16);
        Property maxScreenY = cfg.get("main", "maxScreenSizeY", 16);
        Property loadDistance = cfg.get("client", "loadDistance", 30.0);
        Property unloadDistance = cfg.get("client", "unloadDistance", 32.0);
        Property enableSndDist = cfg.get("client", "enableSoundDistance", true);
        Property ytVolume = cfg.get("client", "ytVolume", 100.0);
        blacklist.setComment("An array of domain names you don't want to load.");
        padHeight.setComment("The minePad Y resolution in pixels. padWidth = padHeight * 1.9666666666666666");
        hardRecipe.setComment("If true, breaking the minePad is required to craft upgrades.");
        homePage.setComment("The URL that will be loaded each time you create a screen");
        disableOT.setComment("If true, the ownership thief item will be disabled");
        loadDistance.setComment("All screens outside this range will be unloaded");
        unloadDistance.setComment("All unloaded screens inside this range will be loaded");
        maxResX.setComment("Maximum horizontal screen resolution, in pixels");
        maxResY.setComment("Maximum vertical screen resolution, in pixels");
        miniservPort.setComment("The port used by miniserv. 0 to disable.");
        miniservPort.setMaxValue(Short.MAX_VALUE);
        miniservQuota.setComment("The amount of data that can be uploaded to miniserv, in KiB (so 1024 = 1 MiO)");
        maxScreenX.setComment("Maximum screen width, in blocks. Resolution will be clamped by maxResolutionX.");
        maxScreenY.setComment("Maximum screen height, in blocks. Resolution will be clamped by maxResolutionY.");
        enableSndDist.setComment("If true, the volume of YouTube videos will change depending on how far you are");
        ytVolume.setComment("Volume for YouTube videos. This will have no effect if enableSoundDistance is set to false");
        ytVolume.setMinValue(0.0);
        ytVolume.setMaxValue(100.0);
        if (unloadDistance.getDouble() < loadDistance.getDouble() + 2.0) {
            unloadDistance.set(loadDistance.getDouble() + 2.0);
        }
        cfg.save();
        this.blacklist = blacklist.getStringList();
        this.doHardRecipe = hardRecipe.getBoolean();
        this.homePage = homePage.getString();
        this.disableOwnershipThief = disableOT.getBoolean();
        this.unloadDistance2 = unloadDistance.getDouble() * unloadDistance.getDouble();
        this.loadDistance2 = loadDistance.getDouble() * loadDistance.getDouble();
        this.maxResX = maxResX.getInt();
        this.maxResY = maxResY.getInt();
        this.miniservPort = miniservPort.getInt();
        this.miniservQuota = miniservQuota.getLong() * 1024L;
        this.maxScreenX = maxScreenX.getInt();
        this.maxScreenY = maxScreenY.getInt();
        this.enableSoundDistance = enableSndDist.getBoolean();
        this.ytVolume = (float)ytVolume.getDouble();
        CREATIVE_TAB = new WDCreativeTab();
        this.criterionPadBreak = new Criterion("pad_break");
        this.criterionUpgradeScreen = new Criterion("upgrade_screen");
        this.criterionLinkPeripheral = new Criterion("link_peripheral");
        this.criterionKeyboardCat = new Criterion("keyboard_cat");
        WebDisplays.registerTrigger(this.criterionPadBreak, this.criterionUpgradeScreen, this.criterionLinkPeripheral, this.criterionKeyboardCat);
        this.padResY = padHeight.getInt();
        this.padResX = this.padResY * 1.9666666666666666;
        this.blockScreen = new BlockScreen();
        this.blockScreen.makeItemBlock();
        this.blockPeripheral = new BlockPeripheral();
        this.blockPeripheral.makeItemBlock();
        this.blockKbRight = new BlockKeyboardRight();
        this.itemScreenCfg = new ItemScreenConfigurator();
        this.itemOwnerThief = new ItemOwnershipThief();
        this.itemLinker = new ItemLinker();
        this.itemMinePad = new ItemMinePad2();
        this.itemUpgrade = new ItemUpgrade();
        this.itemLaserPointer = new ItemLaserPointer();
        this.itemCraftComp = new ItemCraftComponent();
        this.itemAdvIcon = new ItemMulti(AdvancementIcon.class);
        this.itemAdvIcon.func_77655_b("webdisplays.advicon");
        this.itemAdvIcon.setRegistryName("advicon");
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent ev) {
        GameRegistry.registerTileEntity(TileEntityScreen.class, (String)"webdisplays:screen");
        for (DefaultPeripheral dp : DefaultPeripheral.values()) {
            if (dp.getTEClass() == null) continue;
            GameRegistry.registerTileEntity(dp.getTEClass(), (String)("webdisplays:" + dp.func_176610_l()));
        }
        PROXY.init();
        NET_HANDLER = NetworkRegistry.INSTANCE.newSimpleChannel("webdisplays");
        Messages.registerAll(NET_HANDLER);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent ev) {
        PROXY.postInit();
        this.hasOC = Loader.isModLoaded((String)"opencomputers");
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> ev) {
        ev.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{this.blockScreen, this.blockPeripheral, this.blockKbRight});
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> ev) {
        ev.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{this.blockScreen.getItem(), this.blockPeripheral.getItem()});
        ev.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{this.itemScreenCfg, this.itemOwnerThief, this.itemLinker, this.itemMinePad, this.itemUpgrade, this.itemLaserPointer, this.itemCraftComp, this.itemAdvIcon});
    }

    @SubscribeEvent
    public void onRegisterSounds(RegistryEvent.Register<SoundEvent> ev) {
        this.soundTyping = WebDisplays.registerSound(ev, "keyboardType");
        this.soundUpgradeAdd = WebDisplays.registerSound(ev, "upgradeAdd");
        this.soundUpgradeDel = WebDisplays.registerSound(ev, "upgradeDel");
        this.soundScreenCfg = WebDisplays.registerSound(ev, "screencfgOpen");
        this.soundServer = WebDisplays.registerSound(ev, "server");
        this.soundIronic = WebDisplays.registerSound(ev, "ironic");
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load ev) {
        if (ev.getWorld().field_72995_K || ev.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        File worldDir = ev.getWorld().func_72860_G().func_75765_b();
        File f = new File(worldDir, "wd_next.txt");
        if (f.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(f));
                String idx = br.readLine();
                Util.silentClose(br);
                if (idx == null) {
                    throw new RuntimeException("Seems like the file is empty (1)");
                }
                if ((idx = idx.trim()).isEmpty()) {
                    throw new RuntimeException("Seems like the file is empty (2)");
                }
                this.lastPadId = Integer.parseInt(idx);
            }
            catch (Throwable t) {
                Log.warningEx("Could not read last minePad ID from %s. I'm afraid this might break all minePads.", t, f.getAbsolutePath());
            }
        }
        if (this.miniservPort != 0) {
            Server sv = Server.getInstance();
            sv.setPort(this.miniservPort);
            sv.setDirectory(new File(worldDir, "wd_filehost"));
            sv.start();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save ev) {
        if (ev.getWorld().field_72995_K || ev.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        File f = new File(ev.getWorld().func_72860_G().func_75765_b(), "wd_next.txt");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            bw.write("" + this.lastPadId + "\n");
            Util.silentClose(bw);
        }
        catch (Throwable t) {
            Log.warningEx("Could not save last minePad ID (%d) to %s. I'm afraid this might break all minePads.", t, this.lastPadId, f.getAbsolutePath());
        }
    }

    @SubscribeEvent
    public void onToss(ItemTossEvent ev) {
        ItemStack is;
        if (!ev.getEntityItem().field_70170_p.field_72995_K && (is = ev.getEntityItem().func_92059_d()).func_77973_b() == this.itemMinePad) {
            NBTTagCompound tag = is.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                is.func_77982_d(tag);
            }
            UUID thrower = ev.getPlayer().func_146103_bH().getId();
            tag.func_74772_a("ThrowerMSB", thrower.getMostSignificantBits());
            tag.func_74772_a("ThrowerLSB", thrower.getLeastSignificantBits());
            tag.func_74780_a("ThrowHeight", ev.getPlayer().field_70163_u + (double)ev.getPlayer().func_70047_e());
        }
    }

    @SubscribeEvent
    public void onPlayerCraft(PlayerEvent.ItemCraftedEvent ev) {
        if (this.doHardRecipe && ev.crafting.func_77973_b() == this.itemCraftComp && ev.crafting.func_77960_j() == CraftComponent.EXTENSION_CARD.ordinal() && (ev.player instanceof EntityPlayerMP && !this.hasPlayerAdvancement((EntityPlayerMP)ev.player, ADV_PAD_BREAK) || PROXY.hasClientPlayerAdvancement(ADV_PAD_BREAK) != HasAdvancement.YES)) {
            ev.crafting.func_77964_b(CraftComponent.BAD_EXTENSION_CARD.ordinal());
            if (!ev.player.field_70170_p.field_72995_K) {
                ev.player.field_70170_p.func_184148_a(null, ev.player.field_70165_t, ev.player.field_70163_u, ev.player.field_70161_v, SoundEvents.field_187635_cQ, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Mod.EventHandler
    public void onServerStop(FMLServerStoppingEvent ev) {
        Server.getInstance().stopServer();
    }

    @SubscribeEvent
    public void onLogIn(PlayerEvent.PlayerLoggedInEvent ev) {
        if (!ev.player.field_70170_p.field_72995_K && ev.player instanceof EntityPlayerMP) {
            NET_HANDLER.sendTo((IMessage)new CMessageServerInfo(this.miniservPort), (EntityPlayerMP)ev.player);
        }
    }

    @SubscribeEvent
    public void onLogOut(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (!ev.player.field_70170_p.field_72995_K) {
            Server.getInstance().getClientManager().revokeClientKey(ev.player.func_146103_bH().getId());
        }
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent ev) {
        String msg = ev.getMessage().trim().replaceAll("\\s+", " ").toLowerCase();
        StringBuilder sb = new StringBuilder(msg.length());
        for (int i = 0; i < msg.length(); ++i) {
            char chr = msg.charAt(i);
            if (chr == '.' || chr == ',' || chr == ';' || chr == '!' || chr == '?' || chr == ':' || chr == '\'' || chr == '\"' || chr == '`') continue;
            sb.append(chr);
        }
        if (sb.toString().equals("ironic he could save others from death but not himself")) {
            EntityPlayerMP ply = ev.getPlayer();
            ply.field_70170_p.func_184148_a(null, ply.field_70165_t, ply.field_70163_u, ply.field_70161_v, this.soundIronic, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatEvent ev) {
        if (ev.getMessage().equals("!WD render recipes")) {
            PROXY.renderRecipes();
        }
    }

    private boolean hasPlayerAdvancement(EntityPlayerMP ply, ResourceLocation rl) {
        MinecraftServer server = PROXY.getServer();
        if (server == null) {
            return false;
        }
        Advancement adv = server.func_191949_aK().func_192778_a(rl);
        return adv != null && ply.func_192039_O().func_192747_a(adv).func_192105_a();
    }

    public static int getNextAvailablePadID() {
        return WebDisplays.INSTANCE.lastPadId++;
    }

    private static SoundEvent registerSound(RegistryEvent.Register<SoundEvent> ev, String resName) {
        ResourceLocation resLoc = new ResourceLocation("webdisplays", resName);
        SoundEvent ret = new SoundEvent(resLoc);
        ret.setRegistryName(resLoc);
        ev.getRegistry().register((IForgeRegistryEntry)ret);
        return ret;
    }

    private static void registerTrigger(Criterion ... criteria) {
        for (Criterion c : criteria) {
            CriteriaTriggers.func_192118_a((ICriterionTrigger)c);
        }
    }

    public static boolean isOpenComputersAvailable() {
        return WebDisplays.INSTANCE.hasOC;
    }

    public static boolean isSiteBlacklisted(String url) {
        try {
            URL url2 = new URL(Util.addProtocol(url));
            return Arrays.stream(WebDisplays.INSTANCE.blacklist).anyMatch(str -> str.equalsIgnoreCase(url2.getHost()));
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static String applyBlacklist(String url) {
        return WebDisplays.isSiteBlacklisted(url) ? BLACKLIST_URL : url;
    }

    static {
        ADV_PAD_BREAK = new ResourceLocation("webdisplays", "webdisplays/pad_break");
    }
}

