/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.block;

import java.util.Random;
import logictechcorp.libraryex.block.BlockModPortal;
import logictechcorp.libraryex.block.property.BlockProperties;
import logictechcorp.libraryex.utility.BlockHelper;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.world.TeleporterNetherEx;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class BlockNetherPortal
extends BlockModPortal {
    public BlockNetherPortal() {
        super(NetherEx.getResource("nether_portal"), new BlockProperties(Material.field_151567_E, MapColor.field_151678_z).sound(SoundType.field_185853_f).lightLevel(0.75f).hardness(-1.0f).tickRandomly());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        super.func_180650_b(world, pos, state, random);
        if (world.field_73011_w.func_76569_d() && world.func_82736_K().func_82766_b("doMobSpawning") && NetherExConfig.block.netherPortal.pigmanSpawnRarity > 0 && random.nextInt(NetherExConfig.block.netherPortal.pigmanSpawnRarity) < world.func_175659_aa().func_151525_a()) {
            Entity entity;
            int posY = pos.func_177956_o();
            BlockPos blockPos = pos;
            while (!world.func_180495_p(blockPos).isSideSolid((IBlockAccess)world, blockPos, EnumFacing.UP) && blockPos.func_177956_o() > 0) {
                blockPos = blockPos.func_177977_b();
            }
            if (posY > 0 && !world.func_180495_p(blockPos.func_177984_a()).func_185915_l() && (entity = ItemMonsterPlacer.func_77840_a((World)world, (ResourceLocation)EntityList.func_191306_a(EntityPigZombie.class), (double)((double)blockPos.func_177958_n() + 0.5), (double)((double)blockPos.func_177956_o() + 1.1), (double)((double)blockPos.func_177952_p() + 0.5))) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            MinecraftServer server;
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else if (!world.field_72995_K && (server = world.func_73046_m()) != null) {
                PlayerList playerList = server.func_184103_al();
                int fromDimension = entity.field_71093_bK;
                int toDimension = entity.field_71093_bK == DimensionType.NETHER.func_186068_a() ? DimensionType.OVERWORLD.func_186068_a() : DimensionType.NETHER.func_186068_a();
                TeleporterNetherEx teleporter = TeleporterNetherEx.getTeleporterForWorld(server, toDimension);
                entity.func_181015_d(pos);
                entity.field_71088_bW = entity.func_82147_ab();
                if (entity instanceof EntityPlayerMP) {
                    playerList.transferPlayerToDimension((EntityPlayerMP)entity, toDimension, (ITeleporter)teleporter);
                } else {
                    playerList.transferEntityToWorld(entity, fromDimension, server.func_71218_a(fromDimension), server.func_71218_a(toDimension), (ITeleporter)teleporter);
                }
            }
        }
    }

    public boolean isPortalIgniter(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == NetherExBlocks.BLUE_FIRE;
    }

    public boolean isPortalPart(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return BlockHelper.isOreDict((Block)block, (String)"obsidian") || block == NetherExBlocks.BLUE_FIRE || block == this;
    }
}

