/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import java.util.function.Consumer;
import net.minecraft.util.text.ITextComponent;

public abstract class ObjectBaseWidget<T>
extends BaseWidget {
    protected T object;
    private final boolean alwaysRenewObject;

    public ObjectBaseWidget(int x, int y, int width, int height, boolean alwaysRenewObject) {
        super(x, y, width, height);
        this.alwaysRenewObject = alwaysRenewObject;
    }

    public ObjectBaseWidget(int x, int y, int width, int height) {
        this(x, y, width, height, false);
    }

    protected abstract T getObject(T var1);

    protected abstract boolean validateObject(T var1);

    protected boolean validateObjectOrClose() {
        if (this.alwaysRenewObject || !this.validateObject(this.object)) {
            this.object = this.getObject(this.object);
            if (!this.validateObject(this.object)) {
                ClientUtils.closeScreen();
                return false;
            }
        }
        return true;
    }

    @Override
    public final ITextComponent getNarrationMessage() {
        return this.validateObjectOrClose() ? this.getNarrationMessage(this.object) : null;
    }

    protected abstract ITextComponent getNarrationMessage(T var1);

    @Override
    public final int width() {
        return this.validateObjectOrClose() ? this.width(this.object) : 0;
    }

    protected int width(T object) {
        return super.width();
    }

    @Override
    public final int height() {
        return this.validateObjectOrClose() ? this.height(this.object) : 0;
    }

    protected int height(T object) {
        return super.height();
    }

    @Override
    public final int left() {
        return this.validateObjectOrClose() ? this.width(this.object) : 0;
    }

    protected int left(T object) {
        return super.left();
    }

    @Override
    public final int top() {
        return this.validateObjectOrClose() ? this.top(this.object) : 0;
    }

    protected int top(T object) {
        return super.top();
    }

    @Override
    public final void initialize() {
        if (this.validateObjectOrClose()) {
            this.initialize(this.object);
        }
    }

    protected void initialize(T object) {
        super.initialize();
    }

    @Override
    protected void addWidgets() {
        if (this.validateObjectOrClose()) {
            this.addWidgets(this.object);
        }
    }

    protected void addWidgets(T object) {
        super.addWidgets();
    }

    @Override
    public final void update() {
        if (this.validateObjectOrClose()) {
            this.update(this.object);
        }
    }

    protected void update(T object) {
        super.update();
    }

    @Override
    public final void renderBackground(int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderBackground(mouseX, mouseY, this.object);
        }
    }

    protected void renderBackground(int mouseX, int mouseY, T object) {
        super.renderBackground(mouseX, mouseY);
    }

    @Override
    public final void render(int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.render(mouseX, mouseY, this.object);
        }
    }

    protected void render(int mouseX, int mouseY, T object) {
        super.render(mouseX, mouseY);
    }

    @Override
    public final void renderForeground(int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderForeground(mouseX, mouseY, this.object);
        }
    }

    protected void renderForeground(int mouseX, int mouseY, T object) {
        super.renderForeground(mouseX, mouseY);
    }

    @Override
    public final void renderOverlay(int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderOverlay(mouseX, mouseY, this.object);
        }
    }

    protected void renderOverlay(int mouseX, int mouseY, T object) {
        super.renderOverlay(mouseX, mouseY);
    }

    @Override
    public final void renderTooltips(int mouseX, int mouseY) {
        if (this.validateObjectOrClose()) {
            this.renderTooltips(mouseX, mouseY, this.object);
        }
    }

    protected void renderTooltips(int mouseX, int mouseY, T object) {
        super.renderTooltips(mouseX, mouseY);
    }

    @Override
    protected void getTooltips(Consumer<ITextComponent> tooltips) {
        if (this.validateObjectOrClose()) {
            this.getTooltips(tooltips, this.object);
        }
    }

    protected void getTooltips(Consumer<ITextComponent> tooltips, T object) {
        super.getTooltips(tooltips);
    }

    @Override
    public final boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mousePressed(mouseX, mouseY, button, hasBeenHandled, this.object);
    }

    protected boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled, T object) {
        return super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
    }

    @Override
    public final boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mouseReleased(mouseX, mouseY, button, hasBeenHandled, this.object);
    }

    protected boolean mouseReleased(int mouseX, int mouseY, int button, boolean hasBeenHandled, T object) {
        return super.mouseReleased(mouseX, mouseY, button, hasBeenHandled);
    }

    @Override
    public final boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled, this.object);
    }

    protected boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled, T object) {
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }

    @Override
    public final boolean keyPressed(int keyCode, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.keyPressed(keyCode, hasBeenHandled, this.object);
    }

    protected boolean keyPressed(int keyCode, boolean hasBeenHandled, T object) {
        return super.keyPressed(keyCode, hasBeenHandled);
    }

    @Override
    public final boolean keyReleased(int keyCode, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.keyReleased(keyCode, hasBeenHandled, this.object);
    }

    protected boolean keyReleased(int keyCode, boolean hasBeenHandled, T object) {
        return super.keyReleased(keyCode, hasBeenHandled);
    }

    @Override
    public final boolean charTyped(char character, boolean hasBeenHandled) {
        return this.validateObjectOrClose() && this.charTyped(character, hasBeenHandled, this.object);
    }

    protected boolean charTyped(char character, boolean hasBeenHandled, T object) {
        return super.charTyped(character, hasBeenHandled);
    }
}

