/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.util;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import toughasnails.init.ModConfig;

public class TerrainUtils {
    public static boolean isUnderground(World world, BlockPos pos) {
        int verticalSurface = world.func_189649_b(pos.func_177958_n(), pos.func_177952_p());
        if (pos.func_177956_o() >= verticalSurface) {
            return false;
        }
        int undergroundWidth = 5;
        for (int x = pos.func_177958_n() - undergroundWidth; x < pos.func_177958_n() + undergroundWidth; ++x) {
            if (!world.func_175678_i(new BlockPos(x, pos.func_177956_o(), pos.func_177952_p()))) continue;
            return false;
        }
        for (int z = pos.func_177952_p() - undergroundWidth; z < pos.func_177952_p() + undergroundWidth; ++z) {
            if (!world.func_175678_i(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z))) continue;
            return false;
        }
        return true;
    }

    public static float getUndergroundCoefficient(World world, BlockPos pos) {
        int equilibriumDepth;
        if (!TerrainUtils.isUnderground(world, pos)) {
            return 1.0f;
        }
        int verticalSurface = world.func_189649_b(pos.func_177958_n(), pos.func_177952_p());
        int depth = verticalSurface - pos.func_177956_o();
        if (depth >= (equilibriumDepth = ModConfig.temperature.equilibriumDepth)) {
            return 0.0f;
        }
        return 1.0f - (float)depth / (float)equilibriumDepth;
    }

    public static float getAverageUndergroundCoefficient(World world, BlockPos pos) {
        float buffer = 0.0f;
        int width = 3;
        int divider = 2;
        int count = 0;
        for (int x = pos.func_177958_n() - width; x <= pos.func_177958_n() + width; ++x) {
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 2 * width; ++y) {
                for (int z = pos.func_177952_p() - width; z <= pos.func_177952_p() + width; ++z) {
                    if (count % divider == 0) {
                        float coeff = TerrainUtils.getUndergroundCoefficient(world, new BlockPos(x, pos.func_177956_o(), z));
                        buffer += coeff;
                    }
                    ++count;
                }
            }
        }
        float avgCoeff = buffer / ((float)((int)Math.pow(2.0f * (float)width + 1.0f, 3.0) / divider) + 1.0f);
        return avgCoeff;
    }
}

