/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.init.ModConfig;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.config.NBTUtilExt;

public class ArmorModifier
extends TemperatureModifier {
    public ArmorModifier(String id) {
        super(id);
    }

    @Override
    public Temperature applyPlayerModifiers(EntityPlayer player, Temperature initialTemperature, IModifierMonitor monitor) {
        int newTemperatureLevel = initialTemperature.getRawValue();
        InventoryPlayer inventory = player.field_71071_by;
        int modifier = IntStream.range(0, 4).map(i -> ModConfig.armorTemperatureData.stream().filter(atd -> atd.names.contains(((ItemStack)inventory.field_70460_b.get(i)).func_77973_b().getRegistryName().toString())).filter(atd -> {
            int index = atd.names.indexOf(((ItemStack)inventory.field_70460_b.get(i)).func_77973_b().getRegistryName().toString());
            NBTTagCompound compare = atd.nbts == null ? null : atd.getNBTTagCompounds().get(index);
            return NBTUtilExt.areNBTsEqualOrNull(((ItemStack)inventory.field_70460_b.get(i)).func_77978_p(), compare);
        }).findFirst().map(atd -> atd.modifier).orElse(0)).sum();
        monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Armor", initialTemperature, new Temperature(newTemperatureLevel += modifier)));
        return new Temperature(newTemperatureLevel);
    }

    @Override
    public boolean isPlayerSpecific() {
        return true;
    }
}

