/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.temperature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import toughasnails.api.TANCapabilities;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureHandler;

public class TemperatureStatTableHandler {
    private static ArrayList<StatTable> statTables = Lists.newArrayList();
    private static final StatTable TEMPERATURE_TABLE = new StatTable("Target");
    private static final StatTable RATE_TABLE = new StatTable("Rate");

    @SubscribeEvent
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        TemperatureHandler temperatureHandler = (TemperatureHandler)player.getCapability(TANCapabilities.TEMPERATURE, null);
        TemperatureDebugger debugger = temperatureHandler.debugger;
        int currentTemp = temperatureHandler.getTemperature().getRawValue();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && debugger.isGuiVisible()) {
            int extremityModifier;
            String targetProgress = "Target " + TextFormatting.RED + currentTemp + "/" + debugger.targetTemperature + TemperatureStatTableHandler.getCappedText(debugger.targetTemperature);
            String rateProgress = "Rate " + TextFormatting.RED + debugger.temperatureTimer + "/" + debugger.changeTicks;
            TEMPERATURE_TABLE.reset(targetProgress);
            RATE_TABLE.reset(rateProgress);
            for (Map.Entry<String, IModifierMonitor.Context> entry : debugger.modifiers.entrySet()) {
                TEMPERATURE_TABLE.addRow(entry.getValue().description, entry.getValue().endTemperature.getRawValue() - entry.getValue().startTemperature.getRawValue());
            }
            int gradient = TemperatureScale.getRateForTemperatures(currentTemp, debugger.targetTemperature) - TemperatureScale.getAdjustedBaseRate(currentTemp);
            if (gradient != 0) {
                RATE_TABLE.addRow("Gradient", gradient);
            }
            if ((extremityModifier = TemperatureScale.getAdjustedBaseRate(currentTemp) - TemperatureScale.getBaseTemperatureChangeTicks()) != 0) {
                RATE_TABLE.addRow("Extremity", extremityModifier);
            }
            this.drawTables(event.getResolution());
        }
    }

    private void drawTables(ScaledResolution resolution) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int screenWidth = resolution.func_78326_a();
        int screenHeight = resolution.func_78328_b();
        int totalTableHeight = 2 * (statTables.size() - 1);
        for (StatTable statTable : statTables) {
            totalTableHeight += statTable.getHeight();
        }
        int startY = screenHeight / 2 - totalTableHeight / 2;
        int accumulatedHeight = 0;
        for (int i = 0; i < statTables.size(); ++i) {
            StatTable currentTable = statTables.get(i);
            currentTable.drawTable(1, startY + accumulatedHeight);
            accumulatedHeight += currentTable.getHeight() + 2;
        }
    }

    private static String getCappedText(int targetTemperature) {
        return TextFormatting.BLUE + " " + (targetTemperature < 0 ? "(0)" : (targetTemperature > TemperatureScale.getScaleTotal() ? "(" + TemperatureScale.getScaleTotal() + ")" : ""));
    }

    private static String getFormattedInt(int i) {
        TextFormatting format = i > 0 ? TextFormatting.RED : (i < 0 ? TextFormatting.BLUE : TextFormatting.RESET);
        return "" + format + TemperatureStatTableHandler.getNumberSign(i) + i;
    }

    private static char getNumberSign(int i) {
        return i > 0 ? (char)'+' : ' ';
    }

    static {
        statTables.add(TEMPERATURE_TABLE);
        statTables.add(RATE_TABLE);
    }

    @SideOnly(value=Side.CLIENT)
    private static class StatTable {
        private ArrayList<Pair<String, Integer>> rows = Lists.newArrayList();
        private String title;

        public StatTable(String title) {
            this.title = title;
        }

        public void addRow(String fieldName, int value) {
            this.rows.add((Pair<String, Integer>)Pair.of((Object)fieldName, (Object)value));
        }

        public void reset(String title) {
            this.rows.clear();
            this.title = title;
        }

        public void drawTable(int x, int y) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int lineWidth = this.getRowWidth(this.title);
            int textStart = x + 2;
            int textEnd = textStart + lineWidth;
            for (int i = 0; i < this.rows.size() + 1; ++i) {
                int rowTopY = y + i * fontRenderer.field_78288_b + 1;
                int rowBottomY = rowTopY + fontRenderer.field_78288_b;
                if (i == 0) {
                    Gui.func_73734_a((int)x, (int)(rowBottomY - 1), (int)textEnd, (int)y, (int)0x60000000);
                    Gui.func_73734_a((int)x, (int)rowBottomY, (int)textEnd, (int)(rowBottomY - 1), (int)0x50000000);
                    fontRenderer.func_78276_b(this.title, textStart + lineWidth / 2 - fontRenderer.func_78256_a(this.title) / 2, y + 1, 0x20FFFFFF);
                    continue;
                }
                Pair<String, Integer> row = this.rows.get(i - 1);
                String string = (String)row.getLeft();
                int value = (Integer)row.getRight();
                String formattedValue = TemperatureStatTableHandler.getFormattedInt(value);
                Gui.func_73734_a((int)x, (int)rowBottomY, (int)textEnd, (int)rowTopY, (int)0x50000000);
                fontRenderer.func_78276_b(string, textStart, rowTopY, 0x20FFFFFF);
                fontRenderer.func_78276_b(formattedValue, textEnd - fontRenderer.func_78256_a(formattedValue), rowTopY, 0x20FFFFFF);
            }
        }

        public int getRowWidth(String title) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int lineWidth = 0;
            for (Pair<String, Integer> entry : this.rows) {
                int i = (Integer)entry.getValue();
                String string = (String)entry.getKey() + ": " + TemperatureStatTableHandler.getFormattedInt(i);
                lineWidth = Math.max(fontRenderer.func_78256_a(string), lineWidth);
            }
            lineWidth = Math.max(fontRenderer.func_78256_a(title), lineWidth);
            return lineWidth;
        }

        public int getHeight() {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            return (this.rows.size() + 1) * fontRenderer.field_78288_b + 1;
        }
    }
}

