/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon;

import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.DungeonStartJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.PieceJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.RoomEntranceJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.dungeon.SizedPieceJupiter;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class EntranceCraterJupiter
extends SizedPieceJupiter {
    private final int range = 16;

    public EntranceCraterJupiter() {
    }

    public EntranceCraterJupiter(World world, DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ) {
        super(configuration, rand.nextInt(4) + 6, 12, rand.nextInt(4) + 6, EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX - 16, configuration.getYPosition() + 11, blockPosZ - 16, blockPosX + 16, 150, blockPosZ + 16);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        int maxLevel = 0;
        for (int i = -16; i <= 16; ++i) {
            for (int k = -16; k <= 16; ++k) {
                int y;
                BlockPos blockpos;
                Block block;
                int j = 150;
                int x = this.func_74865_a(i + 16, k + 16);
                int z = this.func_74873_b(i + 16, k + 16);
                while (j >= 0 && Blocks.field_150350_a == (block = worldIn.func_180495_p(blockpos = new BlockPos(x, y = this.func_74862_a(--j), z)).func_177230_c())) {
                }
                maxLevel = Math.max(maxLevel, j + 3);
            }
        }
        Mirror mirror = Mirror.NONE;
        Rotation rotation = Rotation.NONE;
        if (this.func_186165_e() != null) {
            switch (this.func_186165_e()) {
                case SOUTH: {
                    mirror = Mirror.LEFT_RIGHT;
                    break;
                }
                case WEST: {
                    mirror = Mirror.LEFT_RIGHT;
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    rotation = Rotation.CLOCKWISE_90;
                    break;
                }
            }
        }
        for (int i = -16; i < 16; ++i) {
            for (int k = -16; k < 16; ++k) {
                double xDev = (double)i / 20.0;
                double zDev = (double)k / 20.0;
                double distance = xDev * xDev + zDev * zDev;
                int depth = (int)Math.abs(0.5 / (distance + 1.0E-5));
                int helper = 0;
                for (int j = maxLevel; j > 1 && helper <= depth; ++helper, --j) {
                    BlockPos blockpos = new BlockPos(this.func_74865_a(i + 16, k + 16), this.func_74862_a(j), this.func_74873_b(i + 16, k + 16));
                    IBlockState state = Blocks.field_150350_a.func_176223_P();
                    if (mirror != Mirror.NONE) {
                        state = state.func_185902_a(mirror);
                    }
                    if (rotation != Rotation.NONE) {
                        state = state.func_185907_a(rotation);
                    }
                    worldIn.func_180501_a(blockpos, state, 2);
                }
            }
        }
        return true;
    }

    @Override
    public PieceJupiter getNextPiece(DungeonStartJupiter startPiece, Random rand) {
        return new RoomEntranceJupiter(this.configuration, rand, this.field_74887_e.field_78897_a + this.field_74887_e.func_78883_b() / 2, this.field_74887_e.field_78896_c + this.field_74887_e.func_78880_d() / 2);
    }
}

