/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Eris.spacestation;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanetsDimensions;
import com.mjr.extraplanets.api.prefabs.client.SkyProviderCustomOrbit;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.ExtraPlanets_SpaceStations;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOverworldOrbit;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.ChunkProviderOrbit;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderErisOrbit
extends WorldProviderOverworldOrbit {
    public CelestialBody getCelestialBody() {
        return ExtraPlanets_SpaceStations.ERIS_SPACE_STATION;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 24000L;
    }

    public boolean shouldForceRespawn() {
        return true;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderOrbit.class;
    }

    public boolean isDaytime() {
        float a = this.field_76579_a.func_72826_c(0.0f);
        return a < 0.42f || a > 0.58f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        return 0.073f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.9;
    }

    public String getPlanetToOrbit() {
        return ExtraPlanets_Planets.ERIS.getUnlocalizedName();
    }

    public int getPlanetIdToOrbit() {
        return Config.ERIS_ID;
    }

    public int getYCoordToTeleportToPlanet() {
        return 10;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION_Eris_" + this.getDimension();
    }

    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar;
    }

    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > ExtraPlanets_Planets.ERIS.getTierRequirement();
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public float getThermalLevelModifier() {
        return 0.0f;
    }

    public float getWindLevel() {
        return 0.1f;
    }

    public DimensionType func_186058_p() {
        return ExtraPlanetsDimensions.ERIS_ORBIT;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSpinDeltaPerTick(float angle) {
        SkyProviderCustomOrbit skyProvider = (SkyProviderCustomOrbit)this.getSkyRenderer();
        if (skyProvider != null) {
            skyProvider.spinDeltaPerTick = angle;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getSkyRotation() {
        SkyProviderCustomOrbit skyProvider = (SkyProviderCustomOrbit)this.getSkyRenderer();
        return skyProvider.spinAngle;
    }

    @SideOnly(value=Side.CLIENT)
    public void createSkyProvider() {
        this.setSkyRenderer(new SkyProviderCustomOrbit(new ResourceLocation("extraplanets:textures/gui/celestialbodies/eris.png"), false, true, WorldProviderErisOrbit.getSunSize()));
        this.setSpinDeltaPerTick(this.getSpinManager().getSpinRate());
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
    }

    public static float getSunSize() {
        return 17.5f * (1.0f / ExtraPlanets_Planets.ERIS.getRelativeDistanceFromCenter().unScaledDistance);
    }
}

