/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.moons;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.api.celestialBody.CelestialBodyMaterialRegistry;
import com.mjr.extraplanets.moons.Callisto.TeleportTypeCallisto;
import com.mjr.extraplanets.moons.Callisto.WorldProviderCallisto;
import com.mjr.extraplanets.moons.Callisto.worldgen.CallistoBiomes;
import com.mjr.extraplanets.moons.Deimos.TeleportTypeDeimos;
import com.mjr.extraplanets.moons.Deimos.WorldProviderDeimos;
import com.mjr.extraplanets.moons.Deimos.worldgen.DeimosBiomes;
import com.mjr.extraplanets.moons.Europa.TeleportTypeEuropa;
import com.mjr.extraplanets.moons.Europa.WorldProviderEuropa;
import com.mjr.extraplanets.moons.Europa.worldgen.EuropaBiomes;
import com.mjr.extraplanets.moons.Ganymede.TeleportTypeGanymede;
import com.mjr.extraplanets.moons.Ganymede.WorldProviderGanymede;
import com.mjr.extraplanets.moons.Ganymede.worldgen.GanymedeBiomes;
import com.mjr.extraplanets.moons.Iapetus.TeleportTypeIapetus;
import com.mjr.extraplanets.moons.Iapetus.WorldProviderIapetus;
import com.mjr.extraplanets.moons.Iapetus.worldgen.IapetusBiomes;
import com.mjr.extraplanets.moons.Io.TeleportTypeIo;
import com.mjr.extraplanets.moons.Io.WorldProviderIo;
import com.mjr.extraplanets.moons.Io.worldgen.IoBiomes;
import com.mjr.extraplanets.moons.Oberon.TeleportTypeOberon;
import com.mjr.extraplanets.moons.Oberon.WorldProviderOberon;
import com.mjr.extraplanets.moons.Oberon.worldgen.OberonBiomes;
import com.mjr.extraplanets.moons.Phobos.TeleportTypePhobos;
import com.mjr.extraplanets.moons.Phobos.WorldProviderPhobos;
import com.mjr.extraplanets.moons.Phobos.worldgen.PhobosBiomes;
import com.mjr.extraplanets.moons.Rhea.TeleportTypeRhea;
import com.mjr.extraplanets.moons.Rhea.WorldProviderRhea;
import com.mjr.extraplanets.moons.Rhea.worldgen.RheaBiomes;
import com.mjr.extraplanets.moons.Titan.TeleportTypeTitan;
import com.mjr.extraplanets.moons.Titan.WorldProviderTitan;
import com.mjr.extraplanets.moons.Titan.worldgen.TitanBiomes;
import com.mjr.extraplanets.moons.Titania.TeleportTypeTitania;
import com.mjr.extraplanets.moons.Titania.WorldProviderTitania;
import com.mjr.extraplanets.moons.Titania.worldgen.TitaniaBiomes;
import com.mjr.extraplanets.moons.Triton.TeleportTypeTriton;
import com.mjr.extraplanets.moons.Triton.WorldProviderTriton;
import com.mjr.extraplanets.moons.Triton.worldgen.TritonBiomes;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.util.GCRegisterUtilities;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class ExtraPlanets_Moons {
    public static Moon TRITON;
    public static Moon CALLISTO;
    public static Moon EUROPA;
    public static Moon GANYMEDE;
    public static Moon IO;
    public static Moon DEIMOS;
    public static Moon PHOBOS;
    public static Moon IAPETUS;
    public static Moon RHEA;
    public static Moon TITAN;
    public static Moon OBERON;
    public static Moon TITANIA;
    public static Moon CHARON;
    public static Moon NIX;
    public static Moon HYDRA;
    public static Moon DYSNOMIA;

    public static void init() {
        ExtraPlanets_Moons.initializeMoons();
        ExtraPlanets_Moons.registerMoons();
        ExtraPlanets_Moons.registerMaterialsForMoons();
        ExtraPlanets_Moons.initializeUnReachableMoons();
    }

    public static void initializeUnReachableMoons() {
        if (Config.GENERATE_UNREACHABLEMOONS) {
            CHARON = GCRegisterUtilities.registerUnreachableMoon("charon", ExtraPlanets_Planets.PLUTO);
            if (CHARON != null) {
                CHARON.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f)).setRelativeOrbitTime(25.578575f);
            }
            if ((NIX = GCRegisterUtilities.registerUnreachableMoon("nix", ExtraPlanets_Planets.PLUTO)) != null) {
                NIX.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f)).setRelativeOrbitTime(57.415455f);
            }
            if ((HYDRA = GCRegisterUtilities.registerUnreachableMoon("hydra", ExtraPlanets_Planets.PLUTO)) != null) {
                HYDRA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(27.0f, 27.0f)).setRelativeOrbitTime(123.252594f);
            }
            if ((DYSNOMIA = GCRegisterUtilities.registerUnreachableMoon("dysnomia", ExtraPlanets_Planets.ERIS)) != null) {
                DYSNOMIA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f)).setRelativeOrbitTime(25.578575f);
            }
        }
    }

    private static Planet getParentPlanet(Planet possiablePlanet, String possiablePlanetName) {
        if (possiablePlanet != null) {
            return possiablePlanet;
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            String planetName = planet.getUnlocalizedName().substring(planet.getUnlocalizedName().indexOf(".") + 1);
            if (!planetName.equalsIgnoreCase(possiablePlanetName) && !planetName.equalsIgnoreCase(possiablePlanetName + "EP")) continue;
            return planet;
        }
        return null;
    }

    private static void initializeMoons() {
        if (Config.TRITON) {
            TRITON = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "tritonEP" : "triton").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.NEPTUNE, "Neptune"));
            TRITON.setPhaseShift(2.436f);
            TRITON.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            TRITON.setRelativeOrbitTime(75.0f);
            TRITON.setTierRequired(7);
            TRITON.setRelativeSize(0.3867f);
            TRITON.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            TRITON.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/triton.png"));
            TRITON.setDimensionInfo(Config.TRITON_ID, WorldProviderTriton.class);
            TRITON.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? -140.0f : 5.0f, 0.0f, 0.2f));
            TRITON.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            TRITON.setBiomeInfo(new Biome[]{TritonBiomes.triton, TritonBiomes.tritonIceLands, TritonBiomes.tritonIceSea});
            TRITON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            TRITON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            TRITON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            TRITON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            TRITON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.PHOBOS) {
            PHOBOS = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "phobosEP" : "phobos").setParentPlanet(MarsModule.planetMars);
            PHOBOS.setPhaseShift(2.436f);
            PHOBOS.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            PHOBOS.setRelativeOrbitTime(25.578575f);
            PHOBOS.setTierRequired(2);
            PHOBOS.setRelativeSize(0.3867f);
            PHOBOS.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            PHOBOS.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/phobos.png"));
            PHOBOS.setDimensionInfo(Config.PHOBOS_ID, WorldProviderPhobos.class);
            PHOBOS.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, -1.0f, 0.0f, 0.2f));
            PHOBOS.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            PHOBOS.setBiomeInfo(new Biome[]{PhobosBiomes.phobos});
            PHOBOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            PHOBOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            PHOBOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            PHOBOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            PHOBOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.DEIMOS) {
            DEIMOS = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "deimosEP" : "deimos").setParentPlanet(MarsModule.planetMars);
            DEIMOS.setPhaseShift(2.436f);
            DEIMOS.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            DEIMOS.setRelativeOrbitTime(57.415455f);
            DEIMOS.setTierRequired(2);
            DEIMOS.setRelativeSize(0.3867f);
            DEIMOS.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            DEIMOS.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/deimos.png"));
            DEIMOS.setDimensionInfo(Config.DEIMOS_ID, WorldProviderDeimos.class);
            DEIMOS.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, -1.0f, 0.0f, 0.2f));
            DEIMOS.addChecklistKeys(new String[]{"thermal_padding", "equip_oxygen_suit", "equip_parachute"});
            DEIMOS.setBiomeInfo(new Biome[]{DeimosBiomes.deimos});
            DEIMOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            DEIMOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            DEIMOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            DEIMOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            DEIMOS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.IO) {
            IO = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "ioEP" : "io").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.JUPITER, "Jupiter"));
            IO.setPhaseShift(2.436f);
            IO.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            IO.setRelativeOrbitTime(43.59977f);
            IO.setTierRequired(4);
            IO.setRelativeSize(0.3867f);
            IO.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            IO.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/io.png"));
            IO.setDimensionInfo(Config.IO_ID, WorldProviderIo.class);
            IO.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 100.0f : 5.0f, 0.0f, 0.2f));
            IO.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            IO.setBiomeInfo(new Biome[]{IoBiomes.io, IoBiomes.ioAshLands, IoBiomes.ioBurningPlains});
            IO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            IO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            IO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            IO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            IO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.EUROPA) {
            EUROPA = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "europaEP" : "europa").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.JUPITER, "Jupiter"));
            EUROPA.setPhaseShift(2.436f);
            EUROPA.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            EUROPA.setRelativeOrbitTime(87.55354f);
            EUROPA.setTierRequired(4);
            EUROPA.setRelativeSize(0.3867f);
            EUROPA.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            EUROPA.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/europa.png"));
            EUROPA.setDimensionInfo(Config.EUROPA_ID, WorldProviderEuropa.class);
            EUROPA.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 100.0f : 5.0f, 0.0f, 0.2f));
            EUROPA.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            EUROPA.setBiomeInfo(new Biome[]{EuropaBiomes.europa, EuropaBiomes.europaIceValleys, EuropaBiomes.europaSaltSea});
            EUROPA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            EUROPA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            EUROPA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            EUROPA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            EUROPA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.GANYMEDE) {
            GANYMEDE = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "ganymedeEP" : "ganymede").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.JUPITER, "Jupiter"));
            GANYMEDE.setPhaseShift(2.436f);
            GANYMEDE.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(27.0f, 27.0f));
            GANYMEDE.setRelativeOrbitTime(123.252594f);
            GANYMEDE.setTierRequired(4);
            GANYMEDE.setRelativeSize(0.3867f);
            GANYMEDE.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            GANYMEDE.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/ganymede.png"));
            GANYMEDE.setDimensionInfo(Config.GANYMEDE_ID, WorldProviderGanymede.class);
            GANYMEDE.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 100.0f : 5.0f, 0.0f, 0.2f));
            GANYMEDE.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            GANYMEDE.setBiomeInfo(new Biome[]{GanymedeBiomes.ganymede});
            GANYMEDE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            GANYMEDE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            GANYMEDE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            GANYMEDE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            GANYMEDE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.CALLISTO) {
            CALLISTO = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "callistoEP" : "callisto").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.JUPITER, "Jupiter"));
            CALLISTO.setPhaseShift(2.436f);
            CALLISTO.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(36.0f, 36.0f));
            CALLISTO.setRelativeOrbitTime(157.84525f);
            CALLISTO.setTierRequired(4);
            CALLISTO.setRelativeSize(0.3867f);
            CALLISTO.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            CALLISTO.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/callisto.png"));
            CALLISTO.setDimensionInfo(Config.CALLISTO_ID, WorldProviderCallisto.class);
            CALLISTO.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 100.0f : 5.0f, 0.0f, 0.2f));
            CALLISTO.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            CALLISTO.setBiomeInfo(new Biome[]{CallistoBiomes.callisto, CallistoBiomes.callistoShaleSmallMountains, CallistoBiomes.callistoShaleLargeMountains, CallistoBiomes.callistoSaltSea});
            CALLISTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            CALLISTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            CALLISTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            CALLISTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            CALLISTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.RHEA) {
            RHEA = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "rheaEP" : "rhea").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.SATURN, "Saturn"));
            RHEA.setPhaseShift(1.45f);
            RHEA.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            RHEA.setRelativeOrbitTime(42.74915f);
            RHEA.setTierRequired(5);
            RHEA.setRelativeSize(0.3867f);
            RHEA.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            RHEA.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/rhea.png"));
            RHEA.setDimensionInfo(Config.RHEA_ID, WorldProviderRhea.class);
            RHEA.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 80.0f : 5.0f, 0.0f, 0.2f));
            RHEA.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            RHEA.setBiomeInfo(new Biome[]{RheaBiomes.rhea});
            RHEA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            RHEA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            RHEA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            RHEA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            RHEA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.TITAN) {
            TITAN = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "titanEP" : "titan").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.SATURN, "Saturn"));
            TITAN.setPhaseShift(1.45f);
            TITAN.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            TITAN.setRelativeOrbitTime(71.452415f);
            TITAN.setTierRequired(5);
            TITAN.setRelativeSize(0.3867f);
            TITAN.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            TITAN.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/titan.png"));
            TITAN.setDimensionInfo(Config.TITAN_ID, WorldProviderTitan.class);
            TITAN.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 80.0f : 5.0f, 0.0f, 0.2f));
            TITAN.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            TITAN.setBiomeInfo(new Biome[]{TitanBiomes.titan, TitanBiomes.titanMethaneHills, TitanBiomes.titanMethaneSea});
            TITAN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            TITAN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            TITAN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            TITAN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            TITAN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.IAPETUS) {
            IAPETUS = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "iapetusEP" : "iapetus").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.SATURN, "Saturn"));
            IAPETUS.setPhaseShift(1.45f);
            IAPETUS.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(27.0f, 27.0f));
            IAPETUS.setRelativeOrbitTime(68.54119f);
            IAPETUS.setTierRequired(5);
            IAPETUS.setRelativeSize(0.3867f);
            IAPETUS.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            IAPETUS.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/iapetus.png"));
            IAPETUS.setDimensionInfo(Config.IAPETUS_ID, WorldProviderIapetus.class);
            IAPETUS.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 40.0f : 5.0f, 4.0f, 0.1f));
            IAPETUS.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            IAPETUS.setBiomeInfo(new Biome[]{IapetusBiomes.iapetus});
            IAPETUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            IAPETUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            IAPETUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            IAPETUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            IAPETUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.OBERON) {
            OBERON = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "oberonEP" : "oberon").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.URANUS, "Uranus"));
            OBERON.setPhaseShift(1.45f);
            OBERON.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(18.0f, 18.0f));
            OBERON.setRelativeOrbitTime(68.54119f);
            OBERON.setTierRequired(6);
            OBERON.setRelativeSize(0.3867f);
            OBERON.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            OBERON.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/oberon.png"));
            OBERON.setDimensionInfo(Config.OBERON_ID, WorldProviderOberon.class);
            OBERON.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? -120.0f : 5.0f, 4.0f, 0.1f));
            OBERON.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            OBERON.setBiomeInfo(new Biome[]{OberonBiomes.oberon, OberonBiomes.oberonLargeMountain, OberonBiomes.oberonValleys});
            OBERON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            OBERON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            OBERON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            OBERON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            OBERON.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.TITANIA) {
            TITANIA = new Moon(Config.GALAXY_SPACE_COMPATIBILITY ? "titaniaEP" : "titania").setParentPlanet(ExtraPlanets_Moons.getParentPlanet(ExtraPlanets_Planets.URANUS, "Uranus"));
            TITANIA.setPhaseShift(1.45f);
            TITANIA.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(9.0f, 9.0f));
            TITANIA.setRelativeOrbitTime(68.54119f);
            TITANIA.setTierRequired(6);
            TITANIA.setRelativeSize(0.3867f);
            TITANIA.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            TITANIA.setBodyIcon(new ResourceLocation("extraplanets", "textures/gui/celestialbodies/titania.png"));
            TITANIA.setDimensionInfo(Config.TITANIA_ID, WorldProviderTitania.class);
            TITANIA.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? -120.0f : 5.0f, 4.0f, 0.1f));
            TITANIA.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            TITANIA.setBiomeInfo(new Biome[]{TitaniaBiomes.titania});
            TITANIA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            TITANIA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            TITANIA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            TITANIA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            TITANIA.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
    }

    private static void registerMoons() {
        if (Config.TRITON) {
            GalaxyRegistry.registerMoon((Moon)TRITON);
            GalacticraftRegistry.registerTeleportType(WorldProviderTriton.class, (ITeleportType)new TeleportTypeTriton());
            GalacticraftRegistry.registerRocketGui(WorldProviderTriton.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/triton_rocket_gui.png"));
        }
        if (Config.EUROPA) {
            GalaxyRegistry.registerMoon((Moon)EUROPA);
            GalacticraftRegistry.registerTeleportType(WorldProviderEuropa.class, (ITeleportType)new TeleportTypeEuropa());
            GalacticraftRegistry.registerRocketGui(WorldProviderEuropa.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/europa_rocket_gui.png"));
        }
        if (Config.IO) {
            GalaxyRegistry.registerMoon((Moon)IO);
            GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new TeleportTypeIo());
            GalacticraftRegistry.registerRocketGui(WorldProviderIo.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/io_rocket_gui.png"));
        }
        if (Config.DEIMOS) {
            GalaxyRegistry.registerMoon((Moon)DEIMOS);
            GalacticraftRegistry.registerTeleportType(WorldProviderDeimos.class, (ITeleportType)new TeleportTypeDeimos());
            GalacticraftRegistry.registerRocketGui(WorldProviderDeimos.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/deimos_rocket_gui.png"));
        }
        if (Config.PHOBOS) {
            GalaxyRegistry.registerMoon((Moon)PHOBOS);
            GalacticraftRegistry.registerTeleportType(WorldProviderPhobos.class, (ITeleportType)new TeleportTypePhobos());
            GalacticraftRegistry.registerRocketGui(WorldProviderPhobos.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/phobos_rocket_gui.png"));
        }
        if (Config.CALLISTO) {
            GalaxyRegistry.registerMoon((Moon)CALLISTO);
            GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new TeleportTypeCallisto());
            GalacticraftRegistry.registerRocketGui(WorldProviderCallisto.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/callisto_rocket_gui.png"));
        }
        if (Config.GANYMEDE) {
            GalaxyRegistry.registerMoon((Moon)GANYMEDE);
            GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new TeleportTypeGanymede());
            GalacticraftRegistry.registerRocketGui(WorldProviderGanymede.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/ganymede_rocket_gui.png"));
        }
        if (Config.RHEA) {
            GalaxyRegistry.registerMoon((Moon)RHEA);
            GalacticraftRegistry.registerTeleportType(WorldProviderRhea.class, (ITeleportType)new TeleportTypeRhea());
            GalacticraftRegistry.registerRocketGui(WorldProviderRhea.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/rhea_rocket_gui.png"));
        }
        if (Config.TITAN) {
            GalaxyRegistry.registerMoon((Moon)TITAN);
            GalacticraftRegistry.registerTeleportType(WorldProviderTitan.class, (ITeleportType)new TeleportTypeTitan());
            GalacticraftRegistry.registerRocketGui(WorldProviderTitan.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/titan_rocket_gui.png"));
        }
        if (Config.OBERON) {
            GalaxyRegistry.registerMoon((Moon)OBERON);
            GalacticraftRegistry.registerTeleportType(WorldProviderOberon.class, (ITeleportType)new TeleportTypeOberon());
            GalacticraftRegistry.registerRocketGui(WorldProviderOberon.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/oberon_rocket_gui.png"));
        }
        if (Config.TITANIA) {
            GalaxyRegistry.registerMoon((Moon)TITANIA);
            GalacticraftRegistry.registerTeleportType(WorldProviderTitania.class, (ITeleportType)new TeleportTypeTitania());
            GalacticraftRegistry.registerRocketGui(WorldProviderTitania.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/titania_rocket_gui.png"));
        }
        if (Config.IAPETUS) {
            GalaxyRegistry.registerMoon((Moon)IAPETUS);
            GalacticraftRegistry.registerTeleportType(WorldProviderIapetus.class, (ITeleportType)new TeleportTypeIapetus());
            GalacticraftRegistry.registerRocketGui(WorldProviderIapetus.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/iapetus_rocket_gui.png"));
        }
    }

    public static boolean isExtraPlanetsMoon(CelestialBody body) {
        return body == TRITON || body == CALLISTO || body == EUROPA || body == GANYMEDE || body == IO || body == DEIMOS || body == PHOBOS || body == IAPETUS || body == RHEA || body == TITAN || body == OBERON || body == TITANIA;
    }

    public static void registerMaterialsForMoons() {
        ArrayList<CelestialBodyMaterialRegistry.MaterialData> mats = new ArrayList<CelestialBodyMaterialRegistry.MaterialData>();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Liquid Nitrongen Ice", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Frozen Nitrogen", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Ice", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Snow", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)TRITON, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Crystallized Water", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)CALLISTO, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Ice", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Dense Ice", CelestialBodyMaterialRegistry.AmountType.HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Crystallized Water", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Radio Active Water", CelestialBodyMaterialRegistry.AmountType.LOW));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)EUROPA, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Ice", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Infected Water", CelestialBodyMaterialRegistry.AmountType.LOW));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)GANYMEDE, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Magma", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Ash", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Volcanic Rock", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)IO, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)DEIMOS, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)PHOBOS, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iapetus Ice", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)IAPETUS, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)RHEA, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Liquid Methane", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Titan Rocks", CelestialBodyMaterialRegistry.AmountType.HIGH));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)TITAN, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Ice", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Dense Ice", CelestialBodyMaterialRegistry.AmountType.VERY_HIGH));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Lava", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)OBERON, mats);
        mats = new ArrayList();
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Copper", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Tin", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        mats.add(new CelestialBodyMaterialRegistry.MaterialData("Iron", CelestialBodyMaterialRegistry.AmountType.MEDIUM));
        CelestialBodyMaterialRegistry.registerMaterialDataForCelestialBody((CelestialBody)TITANIA, mats);
    }
}

