/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.moons.Europa.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.planetAndMoonBlocks.BlockBasicEuropa;
import com.mjr.extraplanets.moons.Europa.worldgen.biomes.BiomeGenEuropaIceValleys;
import com.mjr.mjrlegendslib.util.WorldGenUtilities;
import com.mjr.mjrlegendslib.world.features.WorldGenSphere;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorEuropa
extends BiomeDecoratorSpace {
    private WorldGenerator copperGen;
    private WorldGenerator tinGen;
    private WorldGenerator ironGen;
    private WorldGenerator gravelGen;
    private WorldGenerator fossilsGen;
    private WorldGenerator iceGen;
    private WorldGenerator iceSubSurfaceGen;
    private WorldGenerator iceSurfaceGen;
    private int LakesPerChunk = 5;
    private World currentWorld;

    public BiomeDecoratorEuropa() {
        if (Config.GENERATE_ORES_EUROPA) {
            this.copperGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.EUROPA_BLOCKS, 4, 5, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 2);
            this.tinGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.EUROPA_BLOCKS, 4, 4, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 2);
            this.ironGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.EUROPA_BLOCKS, 20, 3, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 2);
        }
        this.gravelGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.EUROPA_GRAVEL, 12, 0, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 2);
        this.fossilsGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.FOSSIL, 3, 0, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 1);
        this.iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 10, 0, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 2);
        this.iceSubSurfaceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 10, 0, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 1);
        this.iceSurfaceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 10, 0, true, ExtraPlanets_Blocks.EUROPA_BLOCKS, 0);
    }

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        int i;
        if (Config.GENERATE_ORES_EUROPA) {
            this.generateOre(26, this.copperGen, 0, 60);
            this.generateOre(23, this.tinGen, 0, 60);
            this.generateOre(25, this.ironGen, 0, 64);
        }
        this.generateOre(15, this.gravelGen, 0, 80);
        this.generateOre(10, this.fossilsGen, 0, 256);
        this.generateOre(15, this.iceGen, 0, 256);
        this.generateOre(15, this.iceSubSurfaceGen, 0, 256);
        if (!((BiomeAdaptive)this.getCurrentWorld().func_180494_b(new BlockPos(this.posX, 0, this.posZ))).isInstance(BiomeGenEuropaIceValleys.class)) {
            this.generateOre(15, this.iceSurfaceGen, 0, 256);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        for (i = 0; i < this.LakesPerChunk; ++i) {
            if (this.rand.nextInt(10) != 0) continue;
            WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.SALT, (Block)ExtraPlanets_Blocks.EUROPA_BLOCKS);
        }
        for (i = 0; i < 1; ++i) {
            if (this.rand.nextInt(100) != 0) continue;
            WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.RADIO_ACTIVE_WATER, (Block)ExtraPlanets_Blocks.EUROPA_BLOCKS);
        }
        if (Config.GENERATE_EUROPA_IRON_CHUNKS) {
            for (i = 0; i < 2; ++i) {
                if (this.rand.nextInt(20) != 1) continue;
                WorldGenUtilities.generateStructureWithRangeY((WorldGenerator)new WorldGenSphere(Config.DEBUG_MODE, "extraplanets", ExtraPlanets_Blocks.EUROPA_BLOCKS.func_176223_P().func_177226_a(BlockBasicEuropa.BASIC_TYPE, (Comparable)((Object)BlockBasicEuropa.EnumBlockBasic.ORE_IRON)), 12, 0), (World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (int)20, (int)40);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
    }
}

