/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.client.render.entities.landers;

import com.google.common.collect.ImmutableList;
import com.mjr.extraplanets.entities.landers.EntityGeneralLander;
import com.mjr.mjrlegendslib.util.ModelUtilities;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderGeneralLander
extends Render<EntityGeneralLander> {
    private IBakedModel landerModel;

    public RenderGeneralLander(RenderManager manager) {
        super(manager);
        this.field_76989_e = 3.0f;
    }

    private void updateModels() {
        if (this.landerModel == null) {
            try {
                this.landerModel = ModelUtilities.modelFromOBJForge((ResourceLocation)new ResourceLocation("extraplanets", "general_lander.obj"), (List)ImmutableList.of((Object)"FourLeg", (Object)"Body", (Object)"TwoLeg", (Object)"ThreeLeg", (Object)"OneLeg", (Object)"Plane001"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected ResourceLocation getEntityTexture(EntityGeneralLander entity) {
        return TextureMap.field_110575_b;
    }

    public void doRender(EntityGeneralLander lander, double x, double y, double z, float entityYaw, float partialTicks) {
        float pitch = lander.field_70127_C + (lander.field_70125_A - lander.field_70127_C) * partialTicks;
        GlStateManager.func_179101_C();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x - 0.2f), (float)((float)y), (float)((float)z - 0.2f));
        GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
        GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        float f6 = (float)lander.timeSinceHit - partialTicks;
        float f7 = lander.currentDamage - partialTicks;
        if (f7 < 0.0f) {
            f7 = 0.0f;
        }
        if (f6 > 0.0f) {
            GL11.glRotatef((float)((float)Math.sin(f6) * 0.2f * f6 * f7 / 25.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        this.updateModels();
        this.func_110776_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        ModelUtilities.drawBakedModel((IBakedModel)this.landerModel);
        GlStateManager.func_179121_F();
    }

    public boolean shouldRender(EntityGeneralLander lander, ICamera camera, double camX, double camY, double camZ) {
        AxisAlignedBB axisalignedbb = lander.func_174813_aQ().func_72314_b(2.0, 1.0, 2.0);
        return lander.func_145770_h(camX, camY, camZ) && camera.func_78546_a(axisalignedbb);
    }
}

