/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.api.celestialBody.CelestialBodyMaterialRegistry;
import com.mjr.extraplanets.api.event.CustomCelestialGUIEvent;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.client.event.ClientCustomCelestialGUIEvent;
import com.mjr.extraplanets.compatibility.PlanetProgressionCompatibility;
import com.mjr.mjrlegendslib.util.MCUtilities;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;

public class CustomCelestialSelection
extends GuiCelestialSelection {
    private List<CelestialBody> updatedBodiesToRender;
    private List<String> galaxies = new ArrayList<String>();
    private String currentGalaxyName = "";
    private SolarSystem currentGalaxyMainSystem;
    private boolean showGalaxies = false;
    private int mousePosX = 0;
    private int mousePosY = 0;
    private float partialTicks = 0.0f;
    protected static final int BLUE = ColorUtil.to32BitColor((int)255, (int)0, (int)150, (int)255);

    public CustomCelestialSelection(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        super(mapMode, possibleBodies, canCreateStations);
        CustomCelestialGUIEvent.PreLoadingGalaxies preEvent = new CustomCelestialGUIEvent.PreLoadingGalaxies();
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        for (SolarSystem system : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            String name = system.getUnlocalizedParentGalaxyName();
            if (preEvent.galaxiesUnlocalizedNamesToIgnore.contains(name) || preEvent.solarSystemUnlocalizedNamesToIgnore.contains(system.getUnlocalizedName()) || preEvent.solarSystemNamesToIgnore.contains(system.getName()) || this.galaxies.contains(name)) continue;
            this.galaxies.add(name);
        }
        this.currentGalaxyName = "galaxy.milky_way";
        this.currentGalaxyMainSystem = GalacticraftCore.solarSystemSol;
    }

    public void func_73866_w_() {
        this.updatedBodiesToRender = Lists.newArrayList();
        CustomCelestialGUIEvent.PreLoadingCelestialBodies preEvent = new CustomCelestialGUIEvent.PreLoadingCelestialBodies();
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
            if (preEvent.bodyUnlocalizedNamesToIgnore.contains(solarSystem.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(solarSystem.getName()) || !solarSystem.getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) continue;
            this.updatedBodiesToRender.add((CelestialBody)solarSystem.getMainStar());
        }
        for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
            if (preEvent.bodyUnlocalizedNamesToIgnore.contains(planet.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(planet.getName()) || !planet.getParentSolarSystem().getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) continue;
            if (Loader.isModLoaded((String)"planetprogression")) {
                if (!PlanetProgressionCompatibility.isResearched(Minecraft.func_71410_x().field_71439_g, (CelestialBody)planet)) continue;
                this.updatedBodiesToRender.add((CelestialBody)planet);
                continue;
            }
            this.updatedBodiesToRender.add((CelestialBody)planet);
        }
        for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
            if (preEvent.bodyUnlocalizedNamesToIgnore.contains(moon.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(moon.getName())) continue;
            if (moon.getParentPlanet() != null && moon.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) {
                if (Loader.isModLoaded((String)"planetprogression")) {
                    if (!PlanetProgressionCompatibility.isResearched(Minecraft.func_71410_x().field_71439_g, (CelestialBody)moon.getParentPlanet()) || !PlanetProgressionCompatibility.isResearched(Minecraft.func_71410_x().field_71439_g, (CelestialBody)moon)) continue;
                    this.updatedBodiesToRender.add((CelestialBody)moon);
                    continue;
                }
                this.updatedBodiesToRender.add((CelestialBody)moon);
                continue;
            }
            if (moon.getParentPlanet() != null) continue;
            MessageUtilities.fatalErrorMessageToLog((String)"extraplanets", (String)("The moon " + moon.getUnlocalizedName() + " seems to have a null parent planet. Please check the log for other errors!"));
        }
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (preEvent.bodyUnlocalizedNamesToIgnore.contains(satellite.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(satellite.getName()) || !satellite.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) continue;
            if (Loader.isModLoaded((String)"planetprogression")) {
                if (!PlanetProgressionCompatibility.isResearched(Minecraft.func_71410_x().field_71439_g, (CelestialBody)satellite.getParentPlanet())) continue;
                this.updatedBodiesToRender.add((CelestialBody)satellite);
                continue;
            }
            this.updatedBodiesToRender.add((CelestialBody)satellite);
        }
        GuiCelestialSelection.BORDER_SIZE = this.field_146294_l / 65;
        GuiCelestialSelection.BORDER_EDGE_SIZE = GuiCelestialSelection.BORDER_SIZE / 4;
    }

    protected List<CelestialBody> getChildren(Object object) {
        CustomCelestialGUIEvent.PreLoadingCelestialBodies preEvent = new CustomCelestialGUIEvent.PreLoadingCelestialBodies();
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        ArrayList bodyList = Lists.newArrayList();
        if (object instanceof Planet) {
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                if (!planet.equals(object) || preEvent.bodyUnlocalizedNamesToIgnore.contains(planet.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(planet.getName()) || !planet.getParentSolarSystem().getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) continue;
                List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
                if (Loader.isModLoaded((String)"planetprogression")) {
                    for (Moon moon : moons) {
                        if (!PlanetProgressionCompatibility.isResearched(Minecraft.func_71410_x().field_71439_g, (CelestialBody)moon)) continue;
                        bodyList.add(moon);
                    }
                    continue;
                }
                for (Moon moon : moons) {
                    if (preEvent.bodyUnlocalizedNamesToIgnore.contains(moon.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(moon.getName())) continue;
                    bodyList.add(moon);
                }
            }
        } else if (object instanceof SolarSystem) {
            for (SolarSystem solarSystems : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                if (!solarSystems.equals(object) || preEvent.bodyUnlocalizedNamesToIgnore.contains(solarSystems.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(solarSystems.getName()) || !solarSystems.getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) continue;
                List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
                if (Loader.isModLoaded((String)"planetprogression")) {
                    for (Planet planet : planets) {
                        if (!PlanetProgressionCompatibility.isResearched(Minecraft.func_71410_x().field_71439_g, (CelestialBody)planet)) continue;
                        bodyList.add(planet);
                    }
                    continue;
                }
                for (Planet planet : planets) {
                    if (preEvent.bodyUnlocalizedNamesToIgnore.contains(planet.getUnlocalizedName()) || preEvent.bodyNamesToIgnore.contains(planet.getName())) continue;
                    bodyList.add(planet);
                }
            }
        }
        Collections.sort(bodyList);
        return bodyList;
    }

    public HashMap<CelestialBody, Matrix4f> drawCelestialBodies(Matrix4f worldMatrix) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        FloatBuffer fb = BufferUtils.createFloatBuffer((int)512);
        HashMap matrixMap = Maps.newHashMap();
        for (CelestialBody body : this.bodiesToRender) {
            boolean hasParent = body instanceof IChildBody;
            float alpha = this.getAlpha(body);
            if (!(alpha > 0.0f)) continue;
            GlStateManager.func_179094_E();
            Matrix4f worldMatrixLocal = this.setupMatrix(body, worldMatrix, fb, hasParent ? 0.25f : 1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("textures/font/ascii.png"));
            if (!(this.isZoomed() || body instanceof Moon || body instanceof Satellite || body instanceof Star)) {
                if (body.getBodyIcon() != null) {
                    this.field_146297_k.field_71446_o.func_110577_a(body.getBodyIcon());
                    this.func_73732_a(this.field_146289_q, body.getLocalizedName(), 0, 5, 0xE0E0E0);
                }
            } else if (this.isZoomed() && body instanceof Moon && !(body instanceof Satellite) && !(body instanceof Star) && body.getBodyIcon() != null) {
                this.field_146297_k.field_71446_o.func_110577_a(body.getBodyIcon());
                this.func_73732_a(this.field_146289_q, body.getLocalizedName(), 0, 5, 0xE0E0E0);
            }
            CelestialBodyRenderEvent.Pre preEvent = new CelestialBodyRenderEvent.Pre(body, body.getBodyIcon(), 16);
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (preEvent.celestialBodyTexture != null) {
                this.field_146297_k.field_71446_o.func_110577_a(preEvent.celestialBodyTexture);
            }
            if (!preEvent.isCanceled()) {
                int size = this.getWidthForCelestialBody(body);
                this.drawTexturedModalRect(-size / 2, -size / 2, size, size, 0.0f, 0.0f, preEvent.textureSize, preEvent.textureSize, false, false, preEvent.textureSize, preEvent.textureSize);
                matrixMap.put(body, worldMatrixLocal);
            }
            CelestialBodyRenderEvent.Post postEvent = new CelestialBodyRenderEvent.Post(body);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
            GlStateManager.func_179121_F();
        }
        return matrixMap;
    }

    public void drawCustomButtons(int mousePosX, int mousePosY) {
        block49: {
            try {
                if (this.viewState == GuiCelestialSelection.EnumView.PROFILE) break block49;
                int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
                if (this.selectedBody != null) {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    int yOffset = 27;
                    int widthSizeOffset = 75;
                    int xOffset = this.field_146294_l - 270 - LHS;
                    boolean showHoveredMats = false;
                    int showHoveredMatsX = 0;
                    int showHoveredMatsY = 0;
                    this.drawTexturedModalRect(xOffset, yOffset, 93 + widthSizeOffset, 4, 159, 102, 93, 4, false, false);
                    for (int barY = 0; barY < 25; ++barY) {
                        this.drawTexturedModalRect(xOffset, yOffset + barY * this.field_146289_q.field_78288_b + 4, 93 + widthSizeOffset, this.field_146289_q.field_78288_b + 10, 159, 106, 93, this.field_146289_q.field_78288_b, false, false);
                    }
                    for (int barx = 0; barx < 1; ++barx) {
                        this.drawTexturedModalRect(xOffset + barx, yOffset * this.field_146289_q.field_78288_b + 20, 93 + widthSizeOffset, this.field_146289_q.field_78288_b / 2, 159, 106, 1, this.field_146289_q.field_78288_b, false, false);
                    }
                    if (!(this.selectedBody instanceof Star)) {
                        WorldProvider temp = null;
                        if (this.selectedBody.getReachable() && !this.selectedBody.getUnlocalizedName().contains("overworld") && !(this.selectedBody instanceof Satellite)) {
                            temp = MCUtilities.isClient() ? WorldUtil.getProviderForDimensionClient((int)this.selectedBody.getDimensionID()) : WorldUtil.getProviderForDimensionServer((int)this.selectedBody.getDimensionID());
                        }
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 2, BLUE);
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.general_details.name") + ": ", xOffset + 10, yOffset + 8, BLUE);
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, BLUE);
                        String type = GalaxyRegistry.getRegisteredPlanets().containsValue(this.selectedBody) ? TranslateUtilities.translate((String)"gui.type_planet.name") : (GalaxyRegistry.getRegisteredMoons().containsValue(this.selectedBody) ? TranslateUtilities.translate((String)"gui.type_moon.name") : (GalaxyRegistry.getRegisteredSatellites().containsValue(this.selectedBody) ? TranslateUtilities.translate((String)"gui.type_satellite.name") : TranslateUtilities.translate((String)"gui.type_unknown.name")));
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_type.name") + ": " + type, xOffset + 10, yOffset + 23, 0xE0E0E0);
                        if (this.selectedBody instanceof Planet) {
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_amount_of_moons.name") + ": " + this.getChildren(this.selectedBody).size(), xOffset + 10, yOffset + 33, 0xE0E0E0);
                        }
                        this.func_73731_b(this.field_146289_q, "Materials: " + TextFormatting.GOLD + "Hover to Show", xOffset + 10, yOffset + 43, 0xE0E0E0);
                        if (mousePosX >= xOffset + 60 && mousePosY >= yOffset + 41 && mousePosX <= xOffset + 140 && mousePosY <= yOffset + 50) {
                            showHoveredMats = true;
                            showHoveredMatsX = xOffset + 10;
                            showHoveredMatsY = yOffset + 43;
                        }
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 50) + 2, BLUE);
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_details.name") + ": ", xOffset + 10, yOffset + 8, BLUE);
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, BLUE);
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_orbit_time.name") + ": " + this.selectedBody.getRelativeOrbitTime() * 24.0f + " " + TranslateUtilities.translate((String)"gui.type_days.name"), xOffset + 10, yOffset + 23, 0xE0E0E0);
                        float gravity = 0.0f;
                        long dayLength = 0L;
                        if (temp instanceof WorldProviderSpace) {
                            if (this.selectedBody.getReachable() && !(this.selectedBody instanceof Satellite) && !this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld")) {
                                gravity = ((WorldProviderSpace)temp).getGravity();
                                dayLength = ((WorldProviderSpace)temp).getDayLength() / 1000L;
                            } else if (this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld")) {
                                gravity = 1.0f;
                                dayLength = 24L;
                            }
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_gravity.name") + ": " + (this.selectedBody.getReachable() ? Float.valueOf(gravity) : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 33, 0xE0E0E0);
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_day_lengh.name") + ": " + (this.selectedBody.getReachable() ? dayLength + " " + TranslateUtilities.translate((String)"gui.type_hours.name") : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 43, 0xE0E0E0);
                            this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 55) + 2, BLUE);
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.general_features_details.name") + ": ", xOffset + 10, yOffset + 8, BLUE);
                            this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, BLUE);
                            double meteorFrequency = 0.0;
                            if (temp != null && !(this.selectedBody instanceof Satellite) && !this.selectedBody.getUnlocalizedName().contains("overworld")) {
                                double number = ((WorldProviderSpace)temp).getMeteorFrequency();
                                BigDecimal bd = new BigDecimal(number).setScale(7, RoundingMode.DOWN);
                                meteorFrequency = bd.doubleValue();
                            } else {
                                meteorFrequency = 0.0;
                            }
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_meteor_frequency.name") + ": " + (this.selectedBody.getReachable() ? Double.valueOf(meteorFrequency) : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 23, 0xE0E0E0);
                            String name = this.selectedBody.getUnlocalizedName().toLowerCase();
                            String hasDungeon = TranslateUtilities.translate((String)"gui.type_unknown.name");
                            if (name.contains("moon") || name.contains("venus") || name.contains("mars") || name.contains("mercury") || name.contains("jupiter") || name.contains("saturn") || name.contains("uranus") || name.contains("neptune") || name.contains("pluto") || name.contains("eris")) {
                                hasDungeon = "true";
                            }
                            if (name.contains("overworld") || name.contains("ceres") || name.contains("kepler22b") || name.contains("asteroids") || name.contains("phobos") || name.contains("deimos") || name.contains("io") || name.contains("europa") || name.contains("ganymede") || name.contains("callisto") || name.contains("rhea") || name.contains("titan") || name.contains("iapetus") || name.contains("titania") || name.contains("oberon") || name.contains("triton")) {
                                hasDungeon = "false";
                            }
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_has_dungeon.name") + ": " + hasDungeon, xOffset + 10, yOffset + 32, 0xE0E0E0);
                            this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 5) + 39, BLUE);
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.atmosphere_details.name") + ": ", xOffset + 10, yOffset + 45, BLUE);
                            this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 51, BLUE);
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_wind_level.name") + ": " + (this.selectedBody.getReachable() ? this.selectedBody.atmosphere.windLevel() * 10.0f + "%" : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 60, 0xE0E0E0);
                            float temperature = 0.0f;
                            if (this.selectedBody.getReachable() && !this.selectedBody.getUnlocalizedName().toLowerCase().contains("overworld") && !(this.selectedBody instanceof Satellite)) {
                                try {
                                    temperature = ((WorldProviderSpace)temp).getThermalLevelModifier();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_temperature.name") + ": " + (this.selectedBody.getReachable() ? temperature + "C" : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 70, 0xE0E0E0);
                            boolean breathable = false;
                            if (temp != null && !(this.selectedBody instanceof Satellite)) {
                                breathable = ((WorldProviderSpace)temp).hasBreathableAtmosphere();
                            }
                            if (this.selectedBody.getUnlocalizedName().contains("overworld")) {
                                breathable = true;
                            }
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_breathable.name") + ": " + (this.selectedBody.getReachable() ? Boolean.valueOf(breathable) : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 80, 0xE0E0E0);
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_corrosive_atmosphere.name") + ": " + (this.selectedBody.getReachable() ? Boolean.valueOf(this.selectedBody.atmosphere.isCorrosive()) : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 90, 0xE0E0E0);
                            int radiationLevel = 0;
                            int pressureLevel = 0;
                            try {
                                radiationLevel = ((WorldProviderRealisticSpace)temp).getSolarRadiationLevel();
                                pressureLevel = ((WorldProviderRealisticSpace)temp).getPressureLevel();
                            }
                            catch (Exception ex) {
                                if (temp instanceof WorldProviderMoon) {
                                    if (Config.GC_PRESSURE) {
                                        pressureLevel = 80;
                                    }
                                    if (Config.GC_RADIATION) {
                                        radiationLevel = Config.MOON_RADIATION_AMOUNT;
                                    }
                                }
                                if (temp instanceof WorldProviderMars) {
                                    if (Config.GC_PRESSURE) {
                                        pressureLevel = 90;
                                    }
                                    if (Config.GC_RADIATION) {
                                        radiationLevel = Config.MARS_RADIATION_AMOUNT;
                                    }
                                }
                                if (temp instanceof WorldProviderVenus) {
                                    if (Config.GC_PRESSURE) {
                                        pressureLevel = 100;
                                    }
                                    if (Config.GC_RADIATION) {
                                        radiationLevel = Config.VENUS_RADIATION_AMOUNT;
                                    }
                                }
                                if (temp instanceof WorldProviderAsteroids) {
                                    if (Config.GC_PRESSURE) {
                                        pressureLevel = 100;
                                    }
                                    if (Config.GC_RADIATION) {
                                        radiationLevel = Config.ASTEROIDS_RADIATION_AMOUNT;
                                    }
                                }
                                if (temp instanceof WorldProviderSpaceStation || this.selectedBody instanceof Satellite) {
                                    if (Config.GC_PRESSURE || Config.PRESSURE) {
                                        pressureLevel = 100;
                                    }
                                    if (Config.GC_RADIATION || Config.RADIATION) {
                                        radiationLevel = Config.SPACE_STATION_RADIATION_AMOUNT;
                                    }
                                }
                                radiationLevel = 0;
                                pressureLevel = 0;
                            }
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_radiation_level.name") + ": " + (this.selectedBody.getReachable() ? radiationLevel + "%" : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 100, 0xE0E0E0);
                            this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_pressure_level.name") + ": " + (this.selectedBody.getReachable() ? pressureLevel + "%" : TranslateUtilities.translate((String)"gui.type_unknown.name")), xOffset + 10, yOffset + 110, 0xE0E0E0);
                        }
                        if (showHoveredMats) {
                            List<String> materials = CelestialBodyMaterialRegistry.getTextOutputByCelestialBody(this.selectedBody);
                            if (materials.size() != 0) {
                                this.func_146283_a(materials, showHoveredMatsX, showHoveredMatsY);
                            } else {
                                this.func_146279_a("Unknown Materials", showHoveredMatsX, showHoveredMatsY);
                            }
                        }
                    } else if (this.selectedBody instanceof Star) {
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 2, BLUE);
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.general_details.name") + ": ", xOffset + 10, yOffset + 8, BLUE);
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, BLUE);
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_type.name") + ": Star", xOffset + 10, yOffset + 23, 0xE0E0E0);
                        List<CelestialBody> planets = this.getChildren(((Star)this.selectedBody).getParentSolarSystem());
                        int amountofPlanets = planets.size();
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_amount_of_planets.name") + ": " + amountofPlanets, xOffset + 10, yOffset + 33, 0xE0E0E0);
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, (yOffset += 50) + 2, BLUE);
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.parent_solar_system_details.name") + ": ", xOffset + 10, yOffset + 8, BLUE);
                        this.func_73731_b(this.field_146289_q, "------------------------", xOffset + 10, yOffset + 14, BLUE);
                        int amountofMoons = 0;
                        for (int i = 0; i < amountofPlanets; ++i) {
                            amountofMoons += this.getChildren(planets.get(i)).size();
                        }
                        this.func_73731_b(this.field_146289_q, TranslateUtilities.translate((String)"gui.celestial_body_amount_of_moons.name") + ": " + amountofMoons, xOffset + 10, yOffset + 23, 0xE0E0E0);
                    }
                }
                int scale = (int)Math.min(95.0f, this.ticksSinceSelectionF * 12.0f);
                if (this.showGalaxies) {
                    this.func_73731_b(this.field_146289_q, "-", LHS + 80, LHS + 16, 8087790);
                    for (int i = 0; i < this.galaxies.size(); ++i) {
                        String child = TranslateUtilities.translate((String)this.galaxies.get(i));
                        int xOffset = 0;
                        int yOffset = 45;
                        scale = (int)Math.min(95.0f, Math.max(0.0f, this.ticksSinceMenuOpenF * 25.0f - (float)(95 * i)));
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)((float)scale / 95.0f));
                        this.drawTexturedModalRect(LHS + 3 + xOffset, LHS + 6 + i * 14 + yOffset, 86, 10, 0, 489, 86, 10, false, false);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)scale / 95.0f));
                        this.drawTexturedModalRect(LHS + 2 + xOffset, LHS + 5 + i * 14 + yOffset, 93, 12, 95, 464, 93, 12, false, false);
                        if (scale <= 0) continue;
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        String str = child;
                        int color = 0xE0E0E0;
                        this.field_146289_q.func_78276_b(str, LHS + 7 + xOffset, LHS + 8 + i * 14 + yOffset, color);
                    }
                } else if (!this.showGalaxies && Config.CUSTOM_GALAXIES && this.galaxies.size() > 1) {
                    this.func_73731_b(this.field_146289_q, "+", LHS + 80, LHS + 16, 8087790);
                    this.func_73731_b(this.field_146289_q, "< " + TranslateUtilities.translate((String)"gui.new_galaxies.name") + "!", LHS + 100, LHS + 16, 8087790);
                }
            }
            catch (Exception e) {
                MessageUtilities.fatalErrorMessageToLog((String)"extraplanets", (String)"An error has occurred while rendering custom features on the Celestial Selection screen, Please check log for errors!");
                e.printStackTrace();
            }
        }
    }

    public void drawButtons(int mousePosX, int mousePosY) {
        String str;
        if (Config.SHOW_EXINFO_CUSTOM_CELESTIAL_SELECTION) {
            this.drawCustomButtons(mousePosX, mousePosY);
        }
        this.field_73735_i = 0.0f;
        boolean handledSliderPos = false;
        int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
        int RHS = this.field_146294_l - LHS;
        int TOP = LHS;
        int BOT = this.field_146295_m - LHS;
        if (this.viewState == GuiCelestialSelection.EnumView.PROFILE) {
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.field_146294_l / 2 - 43, TOP, 86, 15, 266, 0, 172, 29, false, false);
            str = TranslateUtilities.translate((String)"gui.message.catalog.name").toUpperCase();
            this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + this.field_146289_q.field_78288_b / 2, WHITE);
            if (this.selectedBody != null) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                if (mousePosX > LHS && mousePosX < LHS + 88 && mousePosY > TOP && mousePosY < TOP + 13) {
                    GL11.glColor3f((float)3.0f, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glColor3f((float)0.9f, (float)0.2f, (float)0.2f);
                }
                this.drawTexturedModalRect(LHS, TOP, 88, 13, 0, 392, 148, 22, false, false);
                str = TranslateUtilities.translate((String)"gui.message.back.name").toUpperCase();
                this.field_146289_q.func_78276_b(str, LHS + 45 - this.field_146289_q.func_78256_a(str) / 2, TOP + this.field_146289_q.field_78288_b / 2 - 2, WHITE);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                if (mousePosX > RHS - 88 && mousePosX < RHS && mousePosY > TOP && mousePosY < TOP + 13) {
                    GL11.glColor3f((float)0.0f, (float)3.0f, (float)0.0f);
                } else {
                    GL11.glColor3f((float)0.2f, (float)0.9f, (float)0.2f);
                }
                this.drawTexturedModalRect(RHS - 88, TOP, 88, 13, 0, 392, 148, 22, true, false);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(LHS, BOT - 13, 88, 13, 0, 392, 148, 22, false, true);
                this.drawTexturedModalRect(RHS - 88, BOT - 13, 88, 13, 0, 392, 148, 22, true, true);
                int menuTopLeft = TOP - 115 + this.field_146295_m / 2 - 4;
                int posX = LHS + Math.min((int)this.ticksSinceSelectionF * 10, 133) - 134;
                int posX2 = (int)((float)LHS + Math.min(this.ticksSinceMenuOpenF * 1.25f, 15.0f) - 15.0f);
                int fontPosY = menuTopLeft + GuiCelestialSelection.BORDER_EDGE_SIZE + this.field_146289_q.field_78288_b / 2 - 2;
                this.drawTexturedModalRect(posX, menuTopLeft + 12, 133, 196, 0, 0, 266, 392, false, false);
                str = TranslateUtilities.translate((String)"gui.message.daynightcycle.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 14, CYAN);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".daynightcycle.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 25, WHITE);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".daynightcycle.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 36, WHITE);
                }
                str = TranslateUtilities.translate((String)"gui.message.surfacegravity.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 50, CYAN);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacegravity.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 61, WHITE);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacegravity.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 72, WHITE);
                }
                str = TranslateUtilities.translate((String)"gui.message.surfacecomposition.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 88, CYAN);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacecomposition.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 99, WHITE);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".surfacecomposition.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 110, WHITE);
                }
                str = TranslateUtilities.translate((String)"gui.message.atmosphere.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 126, CYAN);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".atmosphere.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 137, WHITE);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".atmosphere.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 148, WHITE);
                }
                str = TranslateUtilities.translate((String)"gui.message.meansurfacetemp.name") + ":";
                this.field_146289_q.func_78276_b(str, posX + 5, fontPosY + 165, CYAN);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".meansurfacetemp.0.name"));
                this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 176, WHITE);
                str = TranslateUtilities.translate((String)("gui.message." + this.selectedBody.getName() + ".meansurfacetemp.1.name"));
                if (!str.isEmpty()) {
                    this.field_146289_q.func_78276_b(str, posX + 10, fontPosY + 187, WHITE);
                }
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(posX2, menuTopLeft + 12, 17, 199, 439, 0, 32, 399, false, false);
            }
        } else {
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
            str = TranslateUtilities.translate((String)"gui.message.catalog.name").toUpperCase();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
            int scale = (int)Math.min(95.0f, this.ticksSinceMenuOpenF * 12.0f);
            boolean planetZoomedNotMoon = this.isZoomed() && !(this.selectedParent instanceof Planet);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            this.drawTexturedModalRect(LHS - 95 + scale, TOP + 12, 95, 41, 0, 436, 95, 41, false, false);
            str = planetZoomedNotMoon ? this.selectedBody.getLocalizedName() : this.getParentName();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, LHS + 9 - 95 + scale, TOP + 34, WHITE);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
            this.drawTexturedModalRect(LHS + 2 - 95 + scale, TOP + 14, 93, 17, 95, 436, 93, 17, false, false);
            str = planetZoomedNotMoon ? this.getParentName() : this.getGrandparentName();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146289_q.func_78276_b(str, LHS + 7 - 95 + scale, TOP + 16, GREY3);
            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
            List<CelestialBody> children = this.getChildren(planetZoomedNotMoon ? this.selectedBody : this.selectedParent);
            if (!this.showGalaxies) {
                this.drawChildren(children, 0, 0, true);
            }
            if (this.mapMode) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
                str = TranslateUtilities.translate((String)"gui.message.exit.name").toUpperCase();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
            }
            if (this.selectedBody != null) {
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (this.selectedBody instanceof Satellite) {
                    Satellite selectedSatellite = (Satellite)this.selectedBody;
                    int stationListSize = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).size();
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    int max = Math.min(this.field_146295_m / 2 / 14, stationListSize);
                    this.drawTexturedModalRect(RHS - 95, TOP, 95, 53, this.selectedStationOwner.length() == 0 ? 95 : 0, 186, 95, 53, false, false);
                    if (this.spaceStationListOffset <= 0) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(RHS - 85, TOP + 45, 61, 4, 0, 239, 61, 4, false, false);
                    if (max + this.spaceStationListOffset >= stationListSize) {
                        GL11.glColor4f((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(RHS - 85, TOP + 49 + max * 14, 61, 4, 0, 239, 61, 4, false, true);
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    if (((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(this.selectedStationOwner) == null) {
                        str = TranslateUtilities.translate((String)"gui.message.select_ss.name");
                        this.drawSplitString(str, RHS - 47, TOP + 20, 91, WHITE, false, false);
                    } else {
                        str = TranslateUtilities.translate((String)"gui.message.ss_owner.name");
                        this.field_146289_q.func_78276_b(str, RHS - 85, TOP + 18, WHITE);
                        str = this.selectedStationOwner;
                        this.field_146289_q.func_78276_b(str, RHS - 47 - this.field_146289_q.func_78256_a(str) / 2, TOP + 30, WHITE);
                    }
                    Iterator it = ((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).entrySet().iterator();
                    int i = 0;
                    int j = 0;
                    while (it.hasNext() && i < max) {
                        Map.Entry e = it.next();
                        if (j >= this.spaceStationListOffset) {
                            this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                            GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                            int xOffset = 0;
                            if (((String)e.getKey()).equalsIgnoreCase(this.selectedStationOwner)) {
                                xOffset -= 5;
                            }
                            this.drawTexturedModalRect(RHS - 95 + xOffset, TOP + 50 + i * 14, 93, 12, 95, 464, 93, 12, true, false);
                            str = "";
                            String str0 = ((GuiCelestialSelection.StationDataGUI)e.getValue()).getStationName();
                            for (int point = 0; this.field_146289_q.func_78256_a(str) < 80 && point < str0.length(); ++point) {
                                str = str + str0.substring(point, point + 1);
                            }
                            if (this.field_146289_q.func_78256_a(str) >= 80) {
                                str = str.substring(0, str.length() - 3);
                                str = str + "...";
                            }
                            this.field_146289_q.func_78276_b(str, RHS - 88 + xOffset, TOP + 52 + i * 14, WHITE);
                            ++i;
                        }
                        ++j;
                    }
                } else {
                    this.drawTexturedModalRect(RHS - 96, TOP, 96, 139, 63, 0, 96, 139, false, false);
                }
                if (this.canCreateSpaceStation(this.selectedBody) && !(this.selectedBody instanceof Satellite)) {
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    int canCreateLength = Math.max(0, this.drawSplitString(TranslateUtilities.translate((String)"gui.message.can_create_space_station.name"), 0, 0, 91, 0, true, true) - 2);
                    this.canCreateOffset = canCreateLength * this.field_146289_q.field_78288_b;
                    this.drawTexturedModalRect(RHS - 95, TOP + 134, 93, 4, 159, 102, 93, 4, false, false);
                    for (int barY = 0; barY < canCreateLength; ++barY) {
                        this.drawTexturedModalRect(RHS - 95, TOP + 138 + barY * this.field_146289_q.field_78288_b, 93, this.field_146289_q.field_78288_b, 159, 106, 93, this.field_146289_q.field_78288_b, false, false);
                    }
                    this.drawTexturedModalRect(RHS - 95, TOP + 138 + this.canCreateOffset, 93, 43, 159, 106, 93, 43, false, false);
                    this.drawTexturedModalRect(RHS - 79, TOP + 129, 61, 4, 0, 170, 61, 4, false, false);
                    SpaceStationRecipe recipe = WorldUtil.getSpaceStationRecipe((int)this.selectedBody.getDimensionID());
                    if (recipe != null) {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                        boolean validInputMaterials = true;
                        int i = 0;
                        for (Map.Entry e : recipe.getInput().entrySet()) {
                            Object next = e.getKey();
                            int xPos = (int)((double)(RHS - 95) + (double)(i * 93) / (double)recipe.getInput().size() + 5.0);
                            int yPos = TOP + 154 + this.canCreateOffset;
                            if (next instanceof ItemStack) {
                                boolean valid;
                                int amount = this.getAmountInInventory((ItemStack)next);
                                RenderHelper.func_74520_c();
                                ItemStack toRender = ((ItemStack)next).func_77946_l();
                                this.field_146296_j.func_180450_b(toRender, xPos, yPos);
                                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, toRender, xPos, yPos, null);
                                RenderHelper.func_74518_a();
                                GL11.glEnable((int)3042);
                                if (mousePosX >= xPos && mousePosX <= xPos + 16 && mousePosY >= yPos && mousePosY <= yPos + 16) {
                                    GL11.glDepthMask((boolean)true);
                                    GL11.glEnable((int)2929);
                                    GL11.glPushMatrix();
                                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                    int k = this.field_146289_q.func_78256_a(((ItemStack)next).func_82833_r());
                                    int j2 = mousePosX - k / 2;
                                    int k2 = mousePosY - 12;
                                    int i1 = 8;
                                    if (j2 + k > this.field_146294_l) {
                                        j2 -= j2 - this.field_146294_l + k;
                                    }
                                    if (k2 + i1 + 6 > this.field_146295_m) {
                                        k2 = this.field_146295_m - i1 - 6;
                                    }
                                    int j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                    this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                                    int k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                    int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
                                    this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                                    this.field_146289_q.func_78276_b(((ItemStack)next).func_82833_r(), j2, k2, WHITE);
                                    GL11.glPopMatrix();
                                }
                                str = "" + e.getValue();
                                boolean bl = valid = amount >= (Integer)e.getValue();
                                if (!valid && validInputMaterials) {
                                    validInputMaterials = false;
                                }
                                int color = valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d ? GREEN : RED;
                                this.field_146289_q.func_78276_b(str, xPos + 8 - this.field_146289_q.func_78256_a(str) / 2, TOP + 170 + this.canCreateOffset, color);
                            } else if (next instanceof Collection) {
                                boolean valid;
                                Collection items = (Collection)next;
                                int amount = 0;
                                for (ItemStack stack : items) {
                                    amount += this.getAmountInInventory(stack);
                                }
                                RenderHelper.func_74520_c();
                                Iterator it = items.iterator();
                                int count = 0;
                                int toRenderIndex = (int)this.ticksSinceMenuOpenF / 20 % items.size();
                                ItemStack toRender = null;
                                while (it.hasNext()) {
                                    ItemStack stack = (ItemStack)it.next();
                                    if (count == toRenderIndex) {
                                        toRender = stack;
                                        break;
                                    }
                                    ++count;
                                }
                                if (toRender == null) continue;
                                this.field_146296_j.func_180450_b(toRender, xPos, yPos);
                                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, toRender, xPos, yPos, null);
                                RenderHelper.func_74518_a();
                                GL11.glEnable((int)3042);
                                if (mousePosX >= xPos && mousePosX <= xPos + 16 && mousePosY >= yPos && mousePosY <= yPos + 16) {
                                    GL11.glDepthMask((boolean)true);
                                    GL11.glEnable((int)2929);
                                    GL11.glPushMatrix();
                                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
                                    int k = this.field_146289_q.func_78256_a(toRender.func_82833_r());
                                    int j2 = mousePosX - k / 2;
                                    int k2 = mousePosY - 12;
                                    int i1 = 8;
                                    if (j2 + k > this.field_146294_l) {
                                        j2 -= j2 - this.field_146294_l + k;
                                    }
                                    if (k2 + i1 + 6 > this.field_146295_m) {
                                        k2 = this.field_146295_m - i1 - 6;
                                    }
                                    int j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
                                    this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
                                    this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
                                    int k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
                                    int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
                                    this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
                                    this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
                                    this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
                                    this.field_146289_q.func_78276_b(toRender.func_82833_r(), j2, k2, WHITE);
                                    GL11.glPopMatrix();
                                }
                                str = "" + e.getValue();
                                boolean bl = valid = amount >= (Integer)e.getValue();
                                if (!valid && validInputMaterials) {
                                    validInputMaterials = false;
                                }
                                int color = valid | this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d ? GREEN : RED;
                                this.field_146289_q.func_78276_b(str, xPos + 8 - this.field_146289_q.func_78256_a(str) / 2, TOP + 170 + this.canCreateOffset, color);
                            }
                            ++i;
                        }
                        if (validInputMaterials || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.1f, (float)1.0f);
                        } else {
                            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                        if (!this.mapMode && mousePosX >= RHS - 95 && mousePosX <= RHS && mousePosY >= TOP + 182 + this.canCreateOffset && mousePosY <= TOP + 182 + 12 + this.canCreateOffset) {
                            this.drawTexturedModalRect(RHS - 95, TOP + 182 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                        }
                        this.drawTexturedModalRect(RHS - 95, TOP + 182 + this.canCreateOffset, 93, 12, 0, 174, 93, 12, false, false);
                        int color = (int)((Math.sin((double)this.ticksSinceMenuOpenF / 5.0) * 0.5 + 0.5) * 255.0);
                        this.drawSplitString(TranslateUtilities.translate((String)"gui.message.can_create_space_station.name"), RHS - 48, TOP + 137, 91, ColorUtil.to32BitColor((int)255, (int)color, (int)255, (int)color), true, false);
                        if (!this.mapMode) {
                            this.drawSplitString(TranslateUtilities.translate((String)"gui.message.create_ss.name").toUpperCase(), RHS - 48, TOP + 185 + this.canCreateOffset, 91, WHITE, false, false);
                        }
                    } else {
                        this.drawSplitString(TranslateUtilities.translate((String)"gui.message.cannot_create_space_station.name"), RHS - 48, TOP + 138, 91, WHITE, true, false);
                    }
                }
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.3f - Math.min(0.3f, this.ticksSinceSelectionF / 50.0f)));
                this.drawTexturedModalRect(LHS, TOP, 74, 11, 0, 392, 148, 22, false, false);
                str = TranslateUtilities.translate((String)"gui.message.catalog.name").toUpperCase();
                this.field_146289_q.func_78276_b(str, LHS + 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 1, WHITE);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                if (this.selectedBody instanceof Satellite) {
                    if (this.selectedStationOwner.length() == 0 || !this.selectedStationOwner.equalsIgnoreCase(this.field_146297_k.field_71439_g.func_146103_bH().getName())) {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                } else {
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 47, TOP, 94, 11, 0, 414, 188, 22, false, false);
                }
                if (this.selectedBody.getTierRequirement() >= 0 && !(this.selectedBody instanceof Satellite)) {
                    boolean canReach;
                    if (!this.selectedBody.getReachable() || this.possibleBodies != null && !this.possibleBodies.contains(this.selectedBody)) {
                        canReach = false;
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        canReach = true;
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 30, TOP + 11, 30, 11, 0, 414, 60, 22, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2, TOP + 11, 30, 11, 128, 414, 60, 22, false, false);
                    str = GCCoreUtil.translateWithFormat((String)"gui.message.tier.name", (Object[])new Object[]{this.selectedBody.getTierRequirement() == 0 ? "?" : Integer.valueOf(this.selectedBody.getTierRequirement())});
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + 13, canReach ? GREY4 : RED3);
                }
                str = this.selectedBody.getLocalizedName();
                if (this.selectedBody instanceof Satellite) {
                    str = TranslateUtilities.translate((String)"gui.message.rename.name").toUpperCase();
                }
                this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, TOP + 2, WHITE);
                this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                this.drawTexturedModalRect(LHS + 4, TOP, 83, 12, 0, 477, 83, 12, false, false);
                if (!this.mapMode) {
                    if (!this.selectedBody.getReachable() || this.possibleBodies != null && !this.possibleBodies.contains(this.selectedBody) || this.selectedBody instanceof Satellite && this.selectedStationOwner.equals("")) {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(RHS - 74, TOP, 74, 11, 0, 392, 148, 22, true, false);
                    str = TranslateUtilities.translate((String)"gui.message.launch.name").toUpperCase();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146289_q.func_78276_b(str, RHS - 40 - this.field_146289_q.func_78256_a(str) / 2, TOP + 2, WHITE);
                }
                if (this.selectionState == GuiCelestialSelection.EnumSelection.SELECTED && !(this.selectedBody instanceof Satellite)) {
                    boolean flag1;
                    handledSliderPos = true;
                    int sliderPos = this.zoomTooltipPos;
                    if (this.zoomTooltipPos != 38) {
                        this.zoomTooltipPos = sliderPos = Math.min((int)this.ticksSinceSelectionF * 2, 38);
                    }
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain0);
                    this.drawTexturedModalRect(RHS - 182, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE - sliderPos, 83, 38, 346, 436, 166, 76, true, false);
                    boolean flag0 = GalaxyRegistry.getSatellitesForCelestialBody((CelestialBody)this.selectedBody).size() > 0;
                    boolean bl = flag1 = this.selectedBody instanceof Planet && GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selectedBody)).size() > 0;
                    if (flag0 && flag1) {
                        this.drawSplitString(TranslateUtilities.translate((String)"gui.message.click_again.0.name"), RHS - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 2 - sliderPos, 79, GREY5, false, false);
                    } else if (!flag0 && flag1) {
                        this.drawSplitString(TranslateUtilities.translate((String)"gui.message.click_again.1.name"), RHS - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 6 - sliderPos, 79, GREY5, false, false);
                    } else if (flag0) {
                        this.drawSplitString(TranslateUtilities.translate((String)"gui.message.click_again.2.name"), RHS - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 6 - sliderPos, 79, GREY5, false, false);
                    } else {
                        this.drawSplitString(TranslateUtilities.translate((String)"gui.message.click_again.3.name"), RHS - 182 + 41, this.field_146295_m - GuiCelestialSelection.BORDER_SIZE - GuiCelestialSelection.BORDER_EDGE_SIZE + 11 - sliderPos, 79, GREY5, false, false);
                    }
                }
                if (this.selectedBody instanceof Satellite && this.renamingSpaceStation) {
                    this.func_146276_q_();
                    GL11.glColor4f((float)0.0f, (float)0.6f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.field_71446_o.func_110577_a(GuiCelestialSelection.guiMain1);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90, this.field_146295_m / 2 - 38, 179, 67, 159, 0, 179, 67, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 4, this.field_146295_m / 2 - 38 + 2, 171, 10, 159, 92, 171, 10, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 8, this.field_146295_m / 2 - 38 + 18, 161, 13, 159, 67, 161, 13, false, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2 - 90 + 17, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, true, false);
                    this.drawTexturedModalRect(this.field_146294_l / 2, this.field_146295_m / 2 - 38 + 59, 72, 12, 159, 80, 72, 12, false, false);
                    str = TranslateUtilities.translate((String)"gui.message.assign_name.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 - 35, WHITE);
                    str = TranslateUtilities.translate((String)"gui.message.apply.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2 - 36, this.field_146295_m / 2 + 23, WHITE);
                    str = TranslateUtilities.translate((String)"gui.message.cancel.name");
                    this.field_146289_q.func_78276_b(str, this.field_146294_l / 2 + 36 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 + 23, WHITE);
                    if (this.renamingString == null) {
                        Satellite selectedSatellite = (Satellite)this.selectedBody;
                        String playerName = MCUtilities.getClient().field_71439_g.func_146103_bH().getName();
                        this.renamingString = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(playerName)).getStationName();
                        if (this.renamingString == null) {
                            this.renamingString = ((GuiCelestialSelection.StationDataGUI)((Map)this.spaceStationMap.get(this.getSatelliteParentID(selectedSatellite))).get(playerName.toLowerCase())).getStationName();
                        }
                        if (this.renamingString == null) {
                            this.renamingString = "";
                        }
                    }
                    str = this.renamingString;
                    String str0 = this.renamingString;
                    if (this.ticksSinceMenuOpenF / 10.0f % 2.0f == 0.0f) {
                        str0 = str0 + "_";
                    }
                    this.field_146289_q.func_78276_b(str0, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(str) / 2, this.field_146295_m / 2 - 17, WHITE);
                }
            }
        }
        if (!handledSliderPos) {
            this.zoomTooltipPos = 0;
        }
        if (Loader.isModLoaded((String)"planetprogression")) {
            CustomCelestialSelection.func_73734_a((int)(LHS + 1), (int)(this.field_146295_m - LHS - 5), (int)(LHS + 500), (int)(this.field_146295_m - LHS - 20), (int)ColorUtil.to32BitColor((int)255, (int)0, (int)0, (int)0));
            this.field_146289_q.func_78276_b("Important: Want to unlock/see more celestial bodies? Research them via PlanetProgressions Mod", LHS + 5, this.field_146295_m - LHS - 15, RED);
        }
        ClientCustomCelestialGUIEvent.PostRendering preEvent = new ClientCustomCelestialGUIEvent.PostRendering(this);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
    }

    public void func_73863_a(int mousePosX, int mousePosY, float partialTicks) {
        if (this.updatedBodiesToRender != null && this.updatedBodiesToRender.size() != 0) {
            this.bodiesToRender.clear();
            this.bodiesToRender.addAll(this.updatedBodiesToRender);
            this.updatedBodiesToRender.clear();
        }
        this.mousePosX = mousePosX;
        this.mousePosY = mousePosY;
        this.partialTicks = partialTicks;
        super.func_73863_a(mousePosX, mousePosY, partialTicks);
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        if (Config.CUSTOM_GALAXIES) {
            int LHS = GuiCelestialSelection.BORDER_SIZE + GuiCelestialSelection.BORDER_EDGE_SIZE;
            int xPos = LHS + 0;
            int yPos = LHS + 10;
            if (!this.showGalaxies && x >= xPos && x <= xPos + 100 && y >= yPos && y <= yPos + 15) {
                this.showGalaxies = true;
            } else if (this.showGalaxies && x >= xPos && x <= xPos + 100 && y >= yPos && y <= yPos + 15) {
                this.showGalaxies = false;
            }
            if (!this.showGalaxies) {
                super.func_73864_a(x, y, button);
                if (!this.currentGalaxyName.equalsIgnoreCase("galaxy.milky_way")) {
                    this.selectedParent = this.currentGalaxyMainSystem;
                }
            }
            if (this.showGalaxies) {
                for (int i = 0; i < this.galaxies.size(); ++i) {
                    int xOffset = 0;
                    int yOffset = 45;
                    xPos = LHS + 2 + xOffset;
                    yPos = LHS + 5 + i * 14 + yOffset;
                    if (x < xPos || x > xPos + 93 || y < yPos || y > yPos + 12) continue;
                    boolean clicked = false;
                    if (i == 0) {
                        this.currentGalaxyName = this.galaxies.get(i);
                        this.currentGalaxyMainSystem = GalacticraftCore.solarSystemSol;
                        clicked = true;
                    } else {
                        this.currentGalaxyName = this.galaxies.get(i);
                        for (SolarSystem system : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                            if (!system.getUnlocalizedParentGalaxyName().equalsIgnoreCase(this.currentGalaxyName)) continue;
                            this.currentGalaxyMainSystem = system;
                        }
                        clicked = true;
                    }
                    if (!clicked) continue;
                    this.func_73863_a(this.mousePosX, this.mousePosY, this.partialTicks);
                    this.selectedParent = this.currentGalaxyMainSystem;
                    this.showGalaxies = false;
                    this.unselectCelestialBody();
                    this.planetZoom = 0.0f;
                    this.zoom = 0.0f;
                    this.translation = new Vector2f(0.0f, 0.0f);
                    this.position = new Vector2f(0.0f, 0.0f);
                    this.func_73866_w_();
                }
            }
        } else {
            super.func_73864_a(x, y, button);
        }
    }

    public List<String> getGalaxies() {
        return this.galaxies;
    }

    public String getCurrentGalaxyName() {
        return this.currentGalaxyName;
    }

    public SolarSystem getCurrentGalaxyMainSystem() {
        return this.currentGalaxyMainSystem;
    }

    public boolean isShowGalaxies() {
        return this.showGalaxies;
    }

    public int getMousePosX() {
        return this.mousePosX;
    }

    public int getMousePosY() {
        return this.mousePosY;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public static int getBlue() {
        return BLUE;
    }

    public static int getBorderSize() {
        return BORDER_SIZE;
    }

    public static int getBorderEdgeSize() {
        return BORDER_EDGE_SIZE;
    }
}

