/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.api.prefabs.entity;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.api.enitity.IPoweredDockable;
import com.mjr.extraplanets.api.prefabs.entity.EntityElectricAutoRocket;
import com.mjr.extraplanets.api.prefabs.entity.EntityElectricSpaceshipBase;
import com.mjr.extraplanets.network.PacketSimpleEP;
import com.mjr.mjrlegendslib.network.IPacket;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityElectricRocketBase
extends EntityElectricAutoRocket
implements IRocketType,
IPoweredDockable,
IWorldTransferCallback,
ICameraZoomEntity {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;
    public int launchCooldown;
    static Field marsConfigAllDimsAllowed;

    public EntityElectricRocketBase(World par1World) {
        super(par1World);
        this.func_70105_a(0.98f, 4.0f);
    }

    public EntityElectricRocketBase(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    public void igniteCheckingCooldown() {
        if (!this.field_70170_p.field_72995_K && this.launchCooldown <= 0) {
            this.ignite();
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.getWaitForPlayer()) {
            if (!this.func_184188_bt().isEmpty()) {
                Entity passenger = (Entity)this.func_184188_bt().get(0);
                if (this.ticks >= 40L) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.func_184226_ay();
                        passenger.func_184205_a((Entity)this, true);
                        GCLog.debug((String)"Remounting player in rocket.");
                    }
                    this.setWaitForPlayer(false);
                    this.field_70181_x = -0.5;
                } else {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    passenger.field_70179_y = 0.0;
                    passenger.field_70181_x = 0.0;
                    passenger.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.launchCooldown > 0) {
            --this.launchCooldown;
        }
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        } else if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        double rumbleAmount = (double)this.rumble / (double)(37 - 5 * Math.max(this.getRocketTier(), 5));
        for (Entity passenger : this.func_184188_bt()) {
            passenger.field_70165_t += rumbleAmount;
            passenger.field_70161_v += rumbleAmount;
        }
        if (this.launchPhase >= EntityElectricSpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.lastLastMotionY = this.lastMotionY;
            this.lastMotionY = this.field_70181_x;
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        if (buffer.readBoolean()) {
            this.field_70165_t = buffer.readDouble() / 8000.0;
            this.field_70163_u = buffer.readDouble() / 8000.0;
            this.field_70161_v = buffer.readDouble() / 8000.0;
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        boolean sendPosUpdates = this.ticks < 25L || this.launchPhase < EntityElectricSpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal();
        list.add(sendPosUpdates);
        if (sendPosUpdates) {
            list.add(this.field_70165_t * 8000.0);
            list.add(this.field_70163_u * 8000.0);
            list.add(this.field_70161_v * 8000.0);
        }
    }

    @Override
    public void onReachAtmosphere() {
        if (!this.field_70170_p.field_72995_K) {
            for (Entity e : this.func_184188_bt()) {
                if (!(e instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)e;
                this.onTeleport(player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                WorldUtil.toCelestialSelection((EntityPlayerMP)player, (GCPlayerStats)stats, (int)this.getRocketTier());
            }
            this.func_70106_y();
        }
    }

    @Override
    protected boolean shouldCancelExplosion() {
        return this.hasValidPower() && Math.abs(this.lastLastMotionY) < 4.0;
    }

    public void onTeleport(EntityPlayerMP player) {
    }

    @Override
    protected void onRocketLand(BlockPos pos) {
        super.onRocketLand(pos);
        this.launchCooldown = 40;
    }

    @Override
    public void onLaunch() {
        super.onLaunch();
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (this.launchPhase >= EntityElectricSpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            return false;
        }
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().contains(player)) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo((micdoodle8.mods.galacticraft.core.network.IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                stats.setChatCooldown(0);
                float heightBefore = this.field_70131_O;
                this.field_70131_O /= 2.0f;
                this.func_184226_ay();
                this.field_70131_O = heightBefore;
            }
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                ExtraPlanets.packetPipeline.sendTo((IPacket)new PacketSimpleEP(PacketSimpleEP.EnumSimplePacket.C_DISPLAY_ROCKET_CONTROLS, this.field_70170_p.field_73011_w.getDimension(), new Object[0]), (EntityPlayerMP)player);
                GCPlayerStats stats = GCPlayerStats.get((Entity)player);
                stats.setChatCooldown(0);
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        super.func_70014_b(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        super.func_70037_a(nbt);
    }

    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        if (this.rocketType == null) {
            return 2;
        }
        return this.rocketType.getInventorySpace();
    }

    public void onWorldTransferred(World world) {
        if (this.targetVec != null) {
            this.func_70107_b((float)this.targetVec.func_177958_n() + 0.5f, this.targetVec.func_177956_o() + 800, (float)this.targetVec.func_177952_p() + 0.5f);
            this.setLaunchPhase(EntityElectricSpaceshipBase.EnumLaunchPhase.LANDING);
            this.setWaitForPlayer(true);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            this.func_70106_y();
        }
    }

    public float getRotateOffset() {
        return -1.5f;
    }

    @Override
    public boolean isPlayerRocket() {
        return true;
    }

    static {
        try {
            Class<?> marsConfig = Class.forName("micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars");
            marsConfigAllDimsAllowed = marsConfig.getField("launchControllerAllDims");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

