/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.farm;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmingTool;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.PickupWorld;
import crazypants.enderio.base.integration.tic.TicProxy;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelHand;
import crazypants.enderio.base.machine.fakeplayer.FakePlayerEIO;
import crazypants.enderio.machines.config.config.FarmConfig;
import crazypants.enderio.machines.machine.farm.FarmSlots;
import crazypants.enderio.machines.machine.farm.PacketFarmAction;
import crazypants.enderio.machines.machine.farm.TileFarmStation;
import crazypants.enderio.machines.network.PacketHandler;
import crazypants.enderio.util.Prep;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FarmLogic
implements IFarmer {
    @Nonnull
    private static final GameProfile FARMER_PROFILE = new GameProfile(UUID.fromString("c1ddfd7f-120a-4437-8b64-38660d3ec62d"), "[EioFarmer]");
    @Nonnull
    private final TileFarmStation owner;
    @Nonnull
    private final FakePlayerEIO farmerJoe;
    private boolean joeInUse = false;
    private FarmSlots joeHasTool = null;

    public FarmLogic(@Nonnull TileFarmStation owner) {
        this.owner = owner;
        this.farmerJoe = new FakePlayerEIO(owner.func_145831_w(), owner.getLocation(), FARMER_PROFILE);
        this.farmerJoe.setOwner(owner.getOwner());
        this.farmerJoe.field_70170_p = new PickupWorld(owner.func_145831_w(), this.farmerJoe);
    }

    @Override
    @Nonnull
    public FakePlayerEIO getFakePlayer() {
        return this.farmerJoe;
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.owner.func_145831_w();
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.owner.getLocation();
    }

    @Override
    @Nonnull
    public IBlockState getBlockState(@Nonnull BlockPos pos) {
        if (this.getWorld().func_175667_e(pos)) {
            return this.getWorld().func_180495_p(pos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public int getFarmSize() {
        return this.owner.getFarmSize();
    }

    @Override
    public void setNotification(@Nonnull FarmNotification notification) {
        this.owner.setNotification(notification);
    }

    @Override
    @Nonnull
    public ItemStack getSeedTypeInSuppliesFor(@Nonnull BlockPos pos) {
        return this.mapBlockPosToSeedSlot(pos).get(this.owner);
    }

    @Nonnull
    private FarmSlots mapBlockPosToSeedSlot(@Nonnull BlockPos pos) {
        BlockPos offset = pos.func_177973_b((Vec3i)this.getLocation());
        if (offset.func_177958_n() <= 0 && offset.func_177952_p() > 0) {
            return FarmSlots.SEED1;
        }
        if (offset.func_177958_n() > 0 && offset.func_177952_p() >= 0) {
            return FarmSlots.SEED2;
        }
        if (offset.func_177958_n() < 0 && offset.func_177952_p() <= 0) {
            return FarmSlots.SEED3;
        }
        return FarmSlots.SEED4;
    }

    @Override
    @Nonnull
    public ItemStack takeSeedFromSupplies(@Nonnull ItemStack seeds, @Nonnull BlockPos pos, boolean simulate) {
        FarmSlots slot = this.mapBlockPosToSeedSlot(pos);
        ItemStack inv = slot.get(this.owner);
        if (Prep.isValid(inv) && (Prep.isInvalid(seeds) || ItemUtil.areStacksEqual((ItemStack)seeds, (ItemStack)inv)) && (inv.func_190916_E() > 1 || !this.owner.isSlotLocked(slot))) {
            if (simulate) {
                return inv.func_77946_l().func_77979_a(1);
            }
            this.owner.func_70296_d();
            return inv.func_77979_a(1);
        }
        return Prep.getEmpty();
    }

    @Override
    public boolean hasSeed(@Nonnull ItemStack seeds, @Nonnull BlockPos pos) {
        return ItemUtil.areStacksEqual((ItemStack)seeds, (ItemStack)this.mapBlockPosToSeedSlot(pos).get(this.owner));
    }

    @Override
    public int isLowOnSaplings(@Nonnull BlockPos pos) {
        return 90 * ((Integer)FarmConfig.farmSaplingReserveAmount.get() - this.getSeedTypeInSuppliesFor(pos).func_190916_E()) / (Integer)FarmConfig.farmSaplingReserveAmount.get();
    }

    @Override
    public boolean isSlotLocked(@Nonnull BlockPos pos) {
        return this.owner.isSlotLocked(this.mapBlockPosToSeedSlot(pos));
    }

    @Override
    public boolean hasTool(@Nonnull IFarmingTool tool) {
        return Prep.isValid(this.getTool(tool));
    }

    @Override
    public int getLootingValue(@Nonnull IFarmingTool tool) {
        ItemStack stack = this.getTool(tool);
        return Math.max(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack), EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
    }

    @Override
    @Nonnull
    public ItemStack getTool(@Nonnull IFarmingTool tool) {
        FarmSlots slot = this.owner.getSlotForTool(tool);
        if (slot != null) {
            ItemStack stack = slot.get(this.owner);
            if (TicProxy.isBroken(stack) || FarmingTool.isDryRfTool(stack)) {
                if (!this.joeInUse) {
                    this.handleExtraItem(stack, null);
                }
            } else if (tool.itemMatches(stack)) {
                switch (this.tool(tool)) {
                    case AXE: {
                        this.owner.removeNotification(FarmNotification.NO_AXE);
                        break;
                    }
                    case HOE: {
                        this.owner.removeNotification(FarmNotification.NO_HOE);
                        break;
                    }
                    case TREETAP: {
                        this.owner.removeNotification(FarmNotification.NO_TREETAP);
                        break;
                    }
                }
                return stack;
            }
        }
        return Prep.getEmpty();
    }

    @Override
    public void handleExtraItem(@Nonnull ItemStack stack, @Nullable BlockPos drop) {
        if (Prep.isValid(stack)) {
            if (drop == null) {
                drop = this.getLocation();
            }
            InsertCallback insertCallback = new InsertCallback(stack);
            insertCallback.apply(this.mapBlockPosToSeedSlot(drop));
            if (Prep.isValid(stack)) {
                FarmSlots.SEEDS.apply((NNList.ShortCallback)insertCallback);
                if (Prep.isValid(stack)) {
                    FarmSlots.OUTPUTS.apply((NNList.ShortCallback)insertCallback);
                    if (Prep.isValid(stack)) {
                        if (((Boolean)FarmConfig.useOutputQueue.get()).booleanValue()) {
                            this.owner.enQueueOverflow(stack.func_77946_l());
                        } else {
                            Block.func_180635_a((World)this.getWorld(), (BlockPos)drop, (ItemStack)stack.func_77946_l());
                        }
                        stack.func_190920_e(0);
                    }
                }
            }
        }
    }

    @Override
    @Nonnull
    public FakePlayerEIO startUsingItem(@Nonnull ItemStack stack) {
        this.cleanJoe();
        this.joeInUse = true;
        this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, stack);
        return this.farmerJoe;
    }

    private void cleanJoe() {
        if (this.joeInUse) {
            this.removeJoesTool();
            this.endUsingItem(false).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

                public void apply(@Nonnull ItemStack istack) {
                    FarmLogic.this.handleExtraItem(istack, FarmLogic.this.getLocation());
                }
            });
        }
    }

    private void removeJoesTool() {
        if (this.joeHasTool != null) {
            this.joeHasTool.set(this.owner, this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND));
            this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, Prep.getEmpty());
            this.joeHasTool = null;
        }
    }

    @Override
    @Nonnull
    public FakePlayerEIO startUsingItem(@Nonnull IFarmingTool tool) {
        this.cleanJoe();
        this.joeInUse = true;
        ItemStack toolStack = this.getTool(tool);
        for (FarmSlots slot : FarmSlots.TOOLS) {
            if (slot.get(this.owner) != toolStack) continue;
            this.joeHasTool = slot;
        }
        this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, toolStack);
        return this.farmerJoe;
    }

    @Nonnull
    public NNList<ItemStack> endUsingItem(boolean trashHandItem) {
        NNList result = new NNList();
        for (int i = 0; i < this.farmerJoe.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = this.farmerJoe.field_71071_by.func_70304_b(i);
            if (!Prep.isValid(stack)) continue;
            result.add((Object)stack);
        }
        this.joeInUse = false;
        return result;
    }

    @Nonnull
    public NNList<ItemStack> endUsingItem(@Nonnull IFarmingTool tool) {
        this.removeJoesTool();
        NNList<ItemStack> items = this.endUsingItem(false);
        ItemStack toolStack = this.getTool(tool);
        if (TicProxy.isBroken(toolStack) || FarmingTool.isDryRfTool(toolStack)) {
            this.handleExtraItem(toolStack, null);
        }
        return items;
    }

    @Override
    public void handleExtraItems(@Nonnull NonNullList<ItemStack> items, final @Nullable BlockPos pos) {
        NNList.wrap(items).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack stack) {
                FarmLogic.this.handleExtraItem(stack, (BlockPos)NullHelper.first((Object[])new BlockPos[]{pos, FarmLogic.this.getLocation()}));
            }
        });
    }

    @Override
    public boolean checkAction(@Nonnull FarmingAction action, @Nonnull IFarmingTool tool) {
        if (tool != FarmingTool.HAND && !this.hasTool(tool)) {
            switch (this.tool(tool)) {
                case AXE: {
                    this.setNotification(FarmNotification.NO_AXE);
                    break;
                }
                case HOE: {
                    this.setNotification(FarmNotification.NO_HOE);
                    break;
                }
                case SHEARS: {
                    this.setNotification(FarmNotification.NO_SHEARS);
                    break;
                }
                case TREETAP: {
                    this.setNotification(FarmNotification.NO_TREETAP);
                    break;
                }
            }
            return false;
        }
        return this.owner.getEnergyStored() >= this.getEnergyUse(action, tool);
    }

    @Override
    public void registerAction(@Nonnull FarmingAction action, @Nonnull IFarmingTool tool) {
        this.owner.usePower(this.getEnergyUse(action, tool));
    }

    private int getEnergyUse(@Nonnull FarmingAction action, @Nonnull IFarmingTool tool) {
        switch (action) {
            case FERTILIZE: {
                return (Integer)FarmConfig.farmBonemealEnergyUseSuccess.get();
            }
            case HARVEST: {
                return tool == FarmingTool.AXE ? ((Integer)FarmConfig.farmHarvestAxeEnergyUse.get()).intValue() : ((Integer)FarmConfig.farmHarvestEnergyUse.get()).intValue();
            }
            case PLANT: {
                return (Integer)FarmConfig.farmPlantEnergyUse.get();
            }
            case TILL: {
                return (Integer)FarmConfig.farmTillEnergyUse.get();
            }
        }
        return 0;
    }

    @Override
    public void registerAction(@Nonnull FarmingAction action, @Nonnull IFarmingTool tool, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        this.registerAction(action, tool);
        ItemStack toolStack = this.getTool(tool);
        if (Prep.isValid(toolStack) && this.getWorld().field_73012_v.nextFloat() <= ((Float)FarmConfig.farmToolDamageChance.get()).floatValue()) {
            FarmSlots toolSlot = null;
            for (FarmSlots slot : FarmSlots.TOOLS) {
                if (slot.get(this.owner) != toolStack) continue;
                toolSlot = slot;
            }
            boolean damageHandItem = false;
            ItemStack restoreJoe = Prep.getEmpty();
            if (this.joeInUse) {
                if (toolStack == this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND)) {
                    damageHandItem = true;
                } else {
                    restoreJoe = this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND);
                    this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, Prep.getEmpty());
                }
            } else if (Prep.isValid(this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND))) {
                this.handleExtraItem(this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND), null);
                this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, Prep.getEmpty());
            }
            if (!damageHandItem) {
                this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, toolStack);
            }
            boolean canDamage = FarmingTool.canDamage(toolStack);
            switch (this.tool(tool)) {
                case AXE: {
                    toolStack.func_77973_b().func_179218_a(toolStack, this.getWorld(), state, pos, (EntityLivingBase)this.farmerJoe);
                    break;
                }
                case HAND: {
                    break;
                }
                case HOE: {
                    int origDamage = toolStack.func_77952_i();
                    toolStack.func_77973_b().func_180614_a((EntityPlayer)this.farmerJoe, this.getWorld(), pos, EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
                    ItemStack newToolStack = this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND);
                    if (origDamage == newToolStack.func_77952_i() && canDamage) {
                        newToolStack.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
                    }
                    if (newToolStack == toolStack) break;
                    if (damageHandItem && toolSlot != null) {
                        toolSlot.set(this.owner, newToolStack);
                        toolStack = this.getTool(tool);
                        this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, toolStack);
                        break;
                    }
                    toolStack = newToolStack;
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    if (!canDamage) break;
                    toolStack.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
                }
            }
            if (damageHandItem) {
                this.owner.func_70296_d();
                return;
            }
            this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, restoreJoe);
            if (toolSlot != null) {
                toolSlot.set(this.owner, toolStack);
                this.owner.func_70296_d();
            }
        }
    }

    @Override
    public boolean tillBlock(@Nonnull BlockPos pos) {
        BlockPos dirtLoc = pos.func_177977_b();
        IBlockState dirtBlockState = this.getBlockState(pos);
        Block dirtBlock = dirtBlockState.func_177230_c();
        if (dirtBlock == Blocks.field_150458_ak) {
            return true;
        }
        if (!this.checkAction(FarmingAction.TILL, FarmingTool.HOE)) {
            return false;
        }
        ItemStack toolStack = this.getTool(FarmingTool.HOE);
        toolStack = toolStack.func_77973_b() instanceof ItemDarkSteelHand ? new ItemStack(Items.field_151012_L) : toolStack.func_77946_l();
        ItemStack heldItem = this.farmerJoe.func_184586_b(EnumHand.MAIN_HAND);
        this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, toolStack);
        EnumActionResult itemUse = toolStack.func_77973_b().func_180614_a((EntityPlayer)this.farmerJoe, this.farmerJoe.field_70170_p, dirtLoc, EnumHand.MAIN_HAND, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
        this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, Prep.getEmpty());
        boolean temp = this.joeInUse;
        this.endUsingItem(false).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack istack) {
                FarmLogic.this.handleExtraItem(istack, FarmLogic.this.getLocation());
            }
        });
        this.joeInUse = temp;
        this.farmerJoe.func_184611_a(EnumHand.MAIN_HAND, heldItem);
        if (itemUse != EnumActionResult.SUCCESS) {
            return false;
        }
        this.getWorld().func_184134_a((double)((float)dirtLoc.func_177958_n() + 0.5f), (double)((float)dirtLoc.func_177956_o() + 0.5f), (double)((float)dirtLoc.func_177952_p() + 0.5f), SoundEvents.field_187579_bV, SoundCategory.BLOCKS, (Blocks.field_150458_ak.func_185467_w().func_185843_a() + 1.0f) / 2.0f, Blocks.field_150458_ak.func_185467_w().func_185847_b() * 0.8f, false);
        PacketHandler.sendToAllAround(new PacketFarmAction(pos), (TileEntity)this.owner);
        this.registerAction(FarmingAction.TILL, FarmingTool.HOE, dirtBlockState, dirtLoc);
        return true;
    }

    @Nonnull
    private FarmingTool tool(@Nonnull IFarmingTool tool) {
        return tool instanceof FarmingTool ? (FarmingTool)tool : FarmingTool.NONE;
    }

    private class InsertCallback
    implements NNList.ShortCallback<FarmSlots> {
        @Nonnull
        private final ItemStack stack;
        private FarmSlots emptySlot = null;

        public InsertCallback(ItemStack stack) {
            this.stack = stack;
        }

        public boolean apply(@Nonnull FarmSlots slot) {
            if (slot.isValid(FarmLogic.this.owner, this.stack)) {
                ItemStack slotStack = slot.get(FarmLogic.this.owner);
                if (Prep.isInvalid(slotStack)) {
                    if (this.emptySlot == null) {
                        this.emptySlot = slot;
                    }
                } else if (ItemUtil.areStackMergable((ItemStack)this.stack, (ItemStack)slotStack) && !ItemUtil.isStackFull((ItemStack)slotStack)) {
                    int addable = Math.max(0, Math.min(slotStack.func_77976_d(), slot.getInventoryStackLimit(FarmLogic.this.owner)) - slotStack.func_190916_E());
                    if (addable >= this.stack.func_190916_E()) {
                        slotStack.func_190917_f(this.stack.func_190916_E());
                        this.stack.func_190920_e(0);
                        FarmLogic.this.owner.func_70296_d();
                    } else {
                        slotStack.func_190917_f(addable);
                        this.stack.func_190918_g(addable);
                        FarmLogic.this.owner.func_70296_d();
                    }
                }
            }
            return Prep.isInvalid(this.stack);
        }

        public boolean finish() {
            if (this.emptySlot != null) {
                this.emptySlot.set(FarmLogic.this.owner, this.stack.func_77946_l());
                this.stack.func_190920_e(0);
                FarmLogic.this.owner.func_70296_d();
            }
            return Prep.isInvalid(this.stack);
        }
    }
}

