/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.integration.jei;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.jei.RecipeWrapperBase;
import crazypants.enderio.base.integration.jei.RecipeWrapperIMachineRecipe;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredient;
import crazypants.enderio.base.integration.jei.energy.EnergyIngredientRenderer;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.soul.ISoulBinderRecipe;
import crazypants.enderio.machines.config.config.PersonalConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.integration.jei.MachinesPlugin;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.soul.ContainerSoulBinder;
import crazypants.enderio.machines.machine.soul.GuiSoulBinder;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SoulBinderRecipeCategory
extends BlankRecipeCategory<SoulBinderRecipeWrapper> {
    @Nonnull
    public static final String UID = "SoulBinder";
    private static int xOff = 34;
    private static int yOff = 28;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawableAnimated arrow;

    public static void register() {
        if (!((Boolean)PersonalConfig.enableSoulBinderJEIRecipes.get()).booleanValue()) {
            return;
        }
        RecipeWrapperBase.setLevelData(SoulBinderRecipeWrapper.class, MachinesPlugin.iGuiHelper, 129 - xOff, 72 - yOff - 5, null, null);
        MachinesPlugin.iModRegistry.addRecipeCategories(new IRecipeCategory[]{new SoulBinderRecipeCategory(MachinesPlugin.iGuiHelper)});
        MachinesPlugin.iModRegistry.handleRecipes(ISoulBinderRecipe.class, SoulBinderRecipeWrapper::new, UID);
        MachinesPlugin.iModRegistry.addRecipeClickArea(GuiSoulBinder.class, 155, 42, 16, 16, new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipeCategoryCraftingItem(new ItemStack(MachineObject.block_soul_binder.getBlockNN()), new String[]{UID});
        MachinesPlugin.iModRegistry.addRecipes((Collection)MachineRecipeRegistry.instance.getRecipesForMachine("soulbinder").values().stream().filter(r -> r instanceof ISoulBinderRecipe).collect(Collectors.toList()), UID);
        MachinesPlugin.iModRegistry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerSoulBinder.class, UID, ContainerSoulBinder.FIRST_RECIPE_SLOT, ContainerSoulBinder.NUM_RECIPE_SLOT, ContainerSoulBinder.FIRST_INVENTORY_SLOT, ContainerSoulBinder.NUM_INVENTORY_SLOT);
    }

    public SoulBinderRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("soul_fuser");
        this.background = guiHelper.createDrawable(backgroundLocation, xOff, yOff, 120, 50);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 177, 14, 22, 16);
        this.arrow = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return MachineObject.block_soul_binder.getBlockNN().func_149732_F();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 81 - xOff, 35 - yOff);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull SoulBinderRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        CapturedMob resultMob;
        CapturedMob vialMob;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiIngredientGroup group = recipeLayout.getIngredientsGroup(EnergyIngredient.class);
        guiItemStacks.init(0, true, 37 - xOff, 33 - yOff);
        guiItemStacks.init(1, true, 58 - xOff, 33 - yOff);
        guiItemStacks.init(2, false, 111 - xOff, 33 - yOff);
        guiItemStacks.init(3, false, 133 - xOff, 33 - yOff);
        group.init(xOff, true, (IIngredientRenderer)EnergyIngredientRenderer.INSTANCE, 5, 35, 60, 10, 0, 0);
        guiItemStacks.set(ingredients);
        IFocus focus = recipeLayout.getFocus();
        if (focus != null && focus.getMode() == IFocus.Mode.INPUT && focus.getValue() instanceof ItemStack && ((ItemStack)focus.getValue()).func_77973_b() == ModObject.itemSoulVial.getItemNN() && CapturedMob.containsSoul((ItemStack)focus.getValue()) && ((List)ingredients.getOutputs(ItemStack.class).get(1)).size() > 1 && (vialMob = CapturedMob.create((ItemStack)focus.getValue())) != null) {
            ArrayList<ItemStack> newOutputs = new ArrayList<ItemStack>();
            for (ItemStack output : (List)ingredients.getOutputs(ItemStack.class).get(1)) {
                if (output == null || !vialMob.isSameType(CapturedMob.create(output))) continue;
                newOutputs.add(output);
            }
            guiItemStacks.set(3, newOutputs);
        }
        if (focus != null && focus.getMode() == IFocus.Mode.OUTPUT && focus.getValue() instanceof ItemStack && CapturedMob.containsSoul((ItemStack)focus.getValue()) && ((List)ingredients.getInputs(ItemStack.class).get(0)).size() > 1 && ((List)ingredients.getOutputs(ItemStack.class).get(1)).size() > 1 && (resultMob = CapturedMob.create((ItemStack)focus.getValue())) != null) {
            ArrayList<ItemStack> newInputs = new ArrayList<ItemStack>();
            for (ItemStack input : (List)ingredients.getInputs(ItemStack.class).get(0)) {
                if (input == null || !resultMob.isSameType(CapturedMob.create(input))) continue;
                newInputs.add(input);
            }
            guiItemStacks.set(0, newInputs);
            guiItemStacks.set(3, (ItemStack)focus.getValue());
        }
        group.set(ingredients);
    }

    @Nonnull
    public String getModName() {
        return "enderiomachines";
    }

    public static class SoulBinderRecipeWrapper
    extends RecipeWrapperIMachineRecipe<ISoulBinderRecipe> {
        public SoulBinderRecipeWrapper(ISoulBinderRecipe recipe) {
            super(recipe);
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ItemStack outputStack = ((ISoulBinderRecipe)this.recipe).getOutputStack();
            NNList<ResourceLocation> supportedSouls = ((ISoulBinderRecipe)this.recipe).getSupportedSouls();
            ItemStack inputStack = ((ISoulBinderRecipe)this.recipe).getInputStack();
            NNList inputItemList = new NNList();
            if (Prep.isValid(inputStack)) {
                inputItemList.add(inputStack);
                if (ModObject.itemBrokenSpawner.getItemNN() == inputStack.func_77973_b()) {
                    CapturedMob resultMob = CapturedMob.create(outputStack);
                    for (CapturedMob soul : CapturedMob.getAllSouls()) {
                        if (resultMob != null && resultMob.isSameType(soul)) continue;
                        inputItemList.add(soul.toStack(ModObject.itemBrokenSpawner.getItemNN(), 0, 1));
                    }
                }
            }
            NNList<CapturedMob> souls = CapturedMob.getSouls(supportedSouls);
            ArrayList<ItemStack> soulStacks = new ArrayList<ItemStack>();
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (CapturedMob soul : souls) {
                soulStacks.add(soul.toStack(ModObject.itemSoulVial.getItemNN(), 1, 1));
                outputs.add(((ISoulBinderRecipe)this.recipe).getOutputStack(inputStack, soul));
            }
            ingredients.setInputLists(ItemStack.class, (List)new NNList((Object[])new List[]{soulStacks, inputItemList}));
            ingredients.setOutputLists(ItemStack.class, (List)new NNList((Object[])new List[]{Collections.singletonList(new ItemStack(ModObject.itemSoulVial.getItemNN())), outputs}));
            ingredients.setInput(EnergyIngredient.class, (Object)new EnergyIngredient(((ISoulBinderRecipe)this.recipe).getEnergyRequired()));
        }

        @Override
        public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            int cost = ((ISoulBinderRecipe)this.recipe).getExperienceLevelsRequired();
            String str = Lang.GUI_VANILLA_REPAIR_COST.get(cost);
            minecraft.field_71466_p.func_175065_a(str, 6.0f, 26.0f, 8453920, true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        }
    }
}

