/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.object;

import com.mrcrayfish.guns.client.render.HeldAnimation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum GripType {
    ONE_HANDED(new HeldAnimation(){

        @Override
        public void applyPlayerModelRotation(ModelPlayer model, EnumHand hand, float aimProgress) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? hand == EnumHand.MAIN_HAND : hand == EnumHand.OFF_HAND;
            ModelRenderer arm = right ? model.field_178723_h : model.field_178724_i;
            GripType.copyModelAngles(model.field_78116_c, arm);
            arm.field_78795_f = (float)((double)arm.field_78795_f + Math.toRadians(-70.0));
        }
    }, true),
    TWO_HANDED(new HeldAnimation(){

        @Override
        public void applyPlayerModelRotation(ModelPlayer model, EnumHand hand, float aimProgress) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? hand == EnumHand.MAIN_HAND : hand == EnumHand.OFF_HAND;
            ModelRenderer mainArm = right ? model.field_178723_h : model.field_178724_i;
            ModelRenderer secondaryArm = right ? model.field_178724_i : model.field_178723_h;
            GripType.copyModelAngles(model.field_78116_c, mainArm);
            GripType.copyModelAngles(model.field_78116_c, secondaryArm);
            mainArm.field_78795_f = (float)Math.toRadians(-55.0f + aimProgress * -30.0f);
            mainArm.field_78796_g = (float)Math.toRadians((-45.0f + aimProgress * -20.0f) * (right ? 1.0f : -1.0f));
            secondaryArm.field_78795_f = (float)Math.toRadians(-42.0f + aimProgress * -48.0f);
            secondaryArm.field_78796_g = (float)Math.toRadians((-15.0f + aimProgress * 5.0f) * (right ? 1.0f : -1.0f));
        }

        @Override
        public void applyPlayerPreRender(EntityPlayer player, EnumHand hand, float aimProgress) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? hand == EnumHand.MAIN_HAND : hand == EnumHand.OFF_HAND;
            player.field_70760_ar = player.field_70126_B + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
            player.field_70761_aq = player.field_70177_z + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
        }

        @Override
        public void applyHeldItemTransforms(EnumHand hand, float aimProgress) {
            if (hand == EnumHand.MAIN_HAND) {
                boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? hand == EnumHand.MAIN_HAND : hand == EnumHand.OFF_HAND;
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.05);
                float invertRealProgress = 1.0f - aimProgress;
                GlStateManager.func_179114_b((float)(25.0f * invertRealProgress * (right ? 1.0f : -1.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((30.0f * invertRealProgress + aimProgress * -20.0f) * (right ? 1.0f : -1.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(25.0f * invertRealProgress + aimProgress * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }, false),
    CHAIN_GUN(new HeldAnimation(){

        @Override
        public void applyPlayerModelRotation(ModelPlayer model, EnumHand hand, float aimProgress) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? hand == EnumHand.MAIN_HAND : hand == EnumHand.OFF_HAND;
            ModelRenderer mainArm = right ? model.field_178723_h : model.field_178724_i;
            ModelRenderer secondaryArm = right ? model.field_178724_i : model.field_178723_h;
            mainArm.field_78795_f = (float)Math.toRadians(-15.0);
            mainArm.field_78796_g = (float)Math.toRadians(-45.0) * (right ? 1.0f : -1.0f);
            mainArm.field_78808_h = (float)Math.toRadians(0.0);
            secondaryArm.field_78795_f = (float)Math.toRadians(-60.0);
            secondaryArm.field_78796_g = (float)Math.toRadians(15.0) * (right ? 1.0f : -1.0f);
            secondaryArm.field_78808_h = (float)Math.toRadians(0.0);
        }

        @Override
        public void applyPlayerPreRender(EntityPlayer player, EnumHand hand, float aimProgress) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? hand == EnumHand.MAIN_HAND : hand == EnumHand.OFF_HAND;
            player.field_70760_ar = player.field_70126_B + 45.0f * (right ? 1.0f : -1.0f);
            player.field_70761_aq = player.field_70177_z + 45.0f * (right ? 1.0f : -1.0f);
        }

        @Override
        public void applyHeldItemTransforms(EnumHand hand, float aimProgress) {
            if (hand == EnumHand.OFF_HAND) {
                GlStateManager.func_179109_b((float)0.0f, (float)-0.625f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.125f);
            }
        }
    }, false);

    private final HeldAnimation heldAnimation;
    private final boolean renderOffhand;

    private GripType(HeldAnimation heldAnimation, boolean renderOffhand) {
        this.heldAnimation = heldAnimation;
        this.renderOffhand = renderOffhand;
    }

    public HeldAnimation getHeldAnimation() {
        return this.heldAnimation;
    }

    public boolean canRenderOffhand() {
        return this.renderOffhand;
    }

    @SideOnly(value=Side.CLIENT)
    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }
}

