/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.entity.EntityThrowableGrenade;
import com.mrcrayfish.guns.init.ModGuns;
import com.mrcrayfish.guns.init.ModPotions;
import com.mrcrayfish.guns.init.ModSounds;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageExplosionStunGrenade;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityThrowableStunGrenade
extends EntityThrowableGrenade {
    public EntityThrowableStunGrenade(World world) {
        super(world);
    }

    public EntityThrowableStunGrenade(World world, EntityPlayer player) {
        super(world, player);
        this.setItem(new ItemStack(ModGuns.STUN_GRENADE));
    }

    @Override
    public void onDeath() {
        double y = this.field_70163_u + (double)this.field_70131_O * 0.5;
        this.field_70170_p.func_184148_a(null, this.field_70165_t, y, this.field_70161_v, ModSounds.getSound("cgm:grenade_stun_explosion"), SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageExplosionStunGrenade(this.field_70165_t, y, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, y, this.field_70161_v, 4096.0));
        double diameter = Math.max(GunConfig.SERVER.stunGrenades.deafen.criteria.radius, GunConfig.SERVER.stunGrenades.blind.criteria.radius) * 2.0 + 1.0;
        int minX = MathHelper.func_76128_c((double)(this.field_70165_t - diameter));
        int maxX = MathHelper.func_76128_c((double)(this.field_70165_t + diameter));
        int minY = MathHelper.func_76128_c((double)(y - diameter));
        int maxY = MathHelper.func_76128_c((double)(y + diameter));
        int minZ = MathHelper.func_76128_c((double)(this.field_70161_v - diameter));
        int maxZ = MathHelper.func_76128_c((double)(this.field_70161_v + diameter));
        Vec3d grenade = new Vec3d(this.field_70165_t, y, this.field_70161_v);
        for (EntityPlayerMP player : this.field_70170_p.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ))) {
            if (player.func_180427_aV()) continue;
            Vec3d eyes = player.func_174824_e(1.0f);
            Vec3d directionGrenade = grenade.func_178788_d(eyes);
            double distance = directionGrenade.func_72433_c();
            double angle = Math.toDegrees(Math.acos(player.func_70676_i(1.0f).func_72430_b(directionGrenade.func_72432_b())));
            this.calculateAndApplyEffect(ModPotions.DEAFENED, GunConfig.SERVER.stunGrenades.deafen.criteria, player, grenade, eyes, distance, angle);
            this.calculateAndApplyEffect(ModPotions.BLINDED, GunConfig.SERVER.stunGrenades.blind.criteria, player, grenade, eyes, distance, angle);
        }
    }

    private void calculateAndApplyEffect(Potion effect, GunConfig.EffectCriteria criteria, EntityPlayerMP player, Vec3d grenade, Vec3d eyes, double distance, double angle) {
        double angleMax = criteria.angleEffect * 0.5;
        if (distance <= criteria.radius && angleMax > 0.0 && angle <= angleMax && (effect != ModPotions.BLINDED || this.rayTraceOpaqueBlocks(this.field_70170_p, eyes, grenade, false, false, false) == null)) {
            int durationBlinded = (int)Math.round((double)criteria.durationMax - (double)(criteria.durationMax - criteria.durationMin) * (distance / criteria.radius));
            durationBlinded = (int)((double)durationBlinded * (1.0 - angle * (1.0 - criteria.angleAttenuationMax) / angleMax));
            player.func_70690_d(new PotionEffect(effect, durationBlinded, 0, false, false));
        }
    }

    @Nullable
    public RayTraceResult rayTraceOpaqueBlocks(World world, Vec3d start, Vec3d end, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                RayTraceResult raytraceresult;
                int startZ;
                int startY;
                int endX = MathHelper.func_76128_c((double)end.field_72450_a);
                int endY = MathHelper.func_76128_c((double)end.field_72448_b);
                int endZ = MathHelper.func_76128_c((double)end.field_72449_c);
                int startX = MathHelper.func_76128_c((double)start.field_72450_a);
                BlockPos pos = new BlockPos(startX, startY = MathHelper.func_76128_c((double)start.field_72448_b), startZ = MathHelper.func_76128_c((double)start.field_72449_c));
                IBlockState stateInside = world.func_180495_p(pos);
                if (stateInside.getLightOpacity((IBlockAccess)world, pos) != 0 && (!ignoreBlockWithoutBoundingBox || stateInside.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k) && stateInside.func_177230_c().func_176209_a(stateInside, stopOnLiquid) && (raytraceresult = stateInside.func_185910_a(world, pos, start, end)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int limit = 200;
                while (limit-- >= 0) {
                    IBlockState state;
                    EnumFacing enumfacing;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (startX == endX && startY == endY && startZ == endZ) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean completedX = true;
                    boolean completedY = true;
                    boolean completedZ = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (endX > startX) {
                        d0 = startX + 1;
                    } else if (endX < startX) {
                        d0 = startX;
                    } else {
                        completedX = false;
                    }
                    if (endY > startY) {
                        d1 = startY + 1;
                    } else if (endY < startY) {
                        d1 = startY;
                    } else {
                        completedY = false;
                    }
                    if (endZ > startZ) {
                        d2 = startZ + 1;
                    } else if (endZ < startZ) {
                        d2 = startZ;
                    } else {
                        completedZ = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = end.field_72450_a - start.field_72450_a;
                    double d7 = end.field_72448_b - start.field_72448_b;
                    double d8 = end.field_72449_c - start.field_72449_c;
                    if (completedX) {
                        d3 = (d0 - start.field_72450_a) / d6;
                    }
                    if (completedY) {
                        d4 = (d1 - start.field_72448_b) / d7;
                    }
                    if (completedZ) {
                        d5 = (d2 - start.field_72449_c) / d8;
                    }
                    if (d3 == 0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == 0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == 0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = endX > startX ? EnumFacing.WEST : EnumFacing.EAST;
                        start = new Vec3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = endY > startY ? EnumFacing.DOWN : EnumFacing.UP;
                        start = new Vec3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = endZ > startZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        start = new Vec3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
                    }
                    if ((state = world.func_180495_p(pos = new BlockPos(startX = MathHelper.func_76128_c((double)start.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0), startY = MathHelper.func_76128_c((double)start.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0), startZ = MathHelper.func_76128_c((double)start.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0)))).getLightOpacity((IBlockAccess)world, pos) == 0 || ignoreBlockWithoutBoundingBox && state.func_185904_a() != Material.field_151567_E && state.func_185890_d((IBlockAccess)world, pos) == Block.field_185506_k) continue;
                    if (state.func_177230_c().func_176209_a(state, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = state.func_185910_a(world, pos, start, end);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, start, enumfacing, pos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }
}

