/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.common.SpreadHandler;
import com.mrcrayfish.guns.entity.DamageSourceProjectile;
import com.mrcrayfish.guns.interfaces.IDamageable;
import com.mrcrayfish.guns.item.AmmoRegistry;
import com.mrcrayfish.guns.item.ItemAmmo;
import com.mrcrayfish.guns.item.ItemGun;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageSound;
import com.mrcrayfish.guns.object.EntityResult;
import com.mrcrayfish.guns.object.Gun;
import com.mrcrayfish.guns.util.ItemStackHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityProjectile
extends Entity
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L});
    protected int shooterId;
    protected EntityLivingBase shooter;
    protected Gun.General general;
    protected Gun.Projectile projectile;
    private ItemStack weapon = ItemStack.field_190927_a;
    private ItemStack item = ItemStack.field_190927_a;
    protected float damageModifier = 1.0f;
    protected float additionalDamage = 0.0f;

    public EntityProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityProjectile(World worldIn, EntityLivingBase shooter, ItemGun item, Gun modifiedGun) {
        this(worldIn);
        this.shooterId = shooter.func_145782_y();
        this.shooter = shooter;
        this.general = modifiedGun.general;
        this.projectile = modifiedGun.projectile;
        Vec3d dir = this.getDirection(shooter, item, modifiedGun);
        this.field_70159_w = dir.field_72450_a * this.projectile.speed;
        this.field_70181_x = dir.field_72448_b * this.projectile.speed;
        this.field_70179_y = dir.field_72449_c * this.projectile.speed;
        this.updateHeading();
        this.func_70105_a(this.projectile.size, this.projectile.size);
        this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v);
        ItemAmmo ammo = AmmoRegistry.getInstance().getAmmo(this.projectile.item);
        if (ammo != null) {
            this.item = new ItemStack((Item)ammo);
        }
    }

    private Vec3d getDirection(EntityLivingBase shooter, ItemGun item, Gun modifiedGun) {
        float gunSpread = modifiedGun.general.spread;
        if (gunSpread == 0.0f) {
            return this.getVectorFromRotation(shooter.field_70125_A, shooter.func_70079_am());
        }
        if (!modifiedGun.general.alwaysSpread) {
            gunSpread *= SpreadHandler.getSpreadTracker(shooter.func_110124_au()).getSpread(item);
        }
        return this.getVectorFromRotation(shooter.field_70125_A - gunSpread / 2.0f + this.field_70146_Z.nextFloat() * gunSpread, shooter.func_70079_am() - gunSpread / 2.0f + this.field_70146_Z.nextFloat() * gunSpread);
    }

    public void setWeapon(ItemStack weapon) {
        this.weapon = weapon.func_77946_l();
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setDamageModifier(float damageModifier) {
        this.damageModifier = damageModifier;
    }

    public void setAdditionalDamage(float additionalDamage) {
        this.additionalDamage = additionalDamage;
    }

    public void func_70071_h_() {
        EntityResult entityResult;
        super.func_70071_h_();
        this.updateHeading();
        this.onTick();
        Vec3d startVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d endVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult result = this.field_70170_p.func_147447_a(startVec, endVec, false, true, false);
        startVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        endVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (result != null) {
            endVec = new Vec3d(result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
        }
        if ((entityResult = this.findEntityOnPath(startVec, endVec)) != null) {
            result = new RayTraceResult(entityResult.entity, entityResult.hitVec);
        }
        if (result != null && result.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)result.field_72308_g;
            if (this.shooter instanceof EntityPlayer && !((EntityPlayer)this.shooter).func_96122_a(player)) {
                result = null;
            }
        }
        if (result != null && !this.field_70170_p.field_72995_K) {
            this.onHit(result);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.projectile.gravity) {
            this.field_70181_x -= 0.05;
        }
        if (this.field_70173_aa >= this.projectile.life) {
            if (!this.field_70128_L) {
                this.onExpired();
            }
            this.func_70106_y();
        }
    }

    protected void onTick() {
    }

    protected void onExpired() {
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3d start, Vec3d end) {
        Vec3d hitVec = null;
        Entity foundEntity = null;
        List entities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double closestDistance = 0.0;
        for (Entity entity : entities) {
            double distanceToHit;
            Vec3d entityVec;
            RayTraceResult blockResult;
            AxisAlignedBB boundingBox;
            RayTraceResult result;
            if (entity.equals((Object)this.shooter) || (result = (boundingBox = entity.func_174813_aQ().func_72321_a(0.0, 0.0625, 0.0)).func_72327_a(start, end)) == null && ((result = (boundingBox = entity.func_174813_aQ().func_72314_b(GunConfig.SERVER.growBoundingBoxAmount, 0.0625, GunConfig.SERVER.growBoundingBoxAmount)).func_72327_a(start, end)) == null || (blockResult = this.field_70170_p.func_147447_a(result.field_72307_f, entityVec = new Vec3d(entity.field_70165_t, result.field_72307_f.field_72448_b, entity.field_70161_v), false, true, false)) != null) || !((distanceToHit = start.func_72436_e(result.field_72307_f)) < closestDistance) && closestDistance != 0.0) continue;
            hitVec = result.field_72307_f;
            foundEntity = entity;
            closestDistance = distanceToHit;
        }
        return foundEntity != null ? new EntityResult(foundEntity, hitVec) : null;
    }

    private void onHit(RayTraceResult result) {
        if (result.func_178782_a() != null) {
            BlockPos pos = result.func_178782_a();
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            boolean canGunGrief = this.field_70170_p.func_82736_K().func_82766_b("gunGriefing");
            if (canGunGrief && (block instanceof BlockBreakable || block instanceof BlockPane) && state.func_185904_a() == Material.field_151592_s) {
                this.field_70170_p.func_175655_b(result.func_178782_a(), false);
            }
            if (!block.func_176200_f((IBlockAccess)this.field_70170_p, result.func_178782_a())) {
                this.func_70106_y();
            }
            if (block instanceof IDamageable) {
                ((IDamageable)block).onBlockDamaged(this.field_70170_p, state, pos, (int)Math.ceil((double)this.getDamage() / 2.0) + 1);
            }
            this.onHitBlock(state, pos, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
            return;
        }
        Entity entity = result.field_72308_g;
        if (entity != null) {
            if (entity.func_145782_y() == this.shooterId) {
                return;
            }
            this.onHitEntity(entity, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c);
            this.func_70106_y();
            entity.field_70172_ad = 0;
        }
    }

    protected void onHitEntity(Entity entity, double x, double y, double z) {
        boolean headShot = false;
        float damage = this.getDamage();
        if (GunConfig.SERVER.enableHeadShots && entity instanceof EntityPlayer) {
            AxisAlignedBB boundingBox = entity.func_174813_aQ().func_72321_a(0.0, 0.0625, 0.0);
            if (boundingBox.field_72337_e - y <= 0.5) {
                headShot = true;
                damage = (float)((double)damage * GunConfig.SERVER.headShotDamageMultiplier);
            }
        }
        DamageSource source = new DamageSourceProjectile("bullet", this, (Entity)this.shooter, this.weapon).func_76349_b();
        entity.func_70097_a(source, damage);
        if (entity instanceof EntityPlayer && this.shooter instanceof EntityPlayerMP) {
            SoundEvent event = headShot ? SoundEvents.field_187604_bf : SoundEvents.field_187800_eb;
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSound(event, SoundCategory.PLAYERS, this.shooter.field_70165_t, this.shooter.field_70163_u + (double)this.shooter.func_70047_e(), this.shooter.field_70161_v, 0.75f, 3.0f), (EntityPlayerMP)this.shooter);
        }
    }

    protected void onHitBlock(IBlockState state, BlockPos pos, double x, double y, double z) {
        ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, x, y, z, (int)this.projectile.damage, 0.0, 0.0, 0.0, 0.05, new int[]{Block.func_176210_f((IBlockState)state)});
    }

    public boolean shouldRenderInPass(int pass) {
        return this.projectile.visible;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(compound.func_74775_l("projectile"));
        this.general = new Gun.General();
        this.general.deserializeNBT(compound.func_74775_l("general"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("projectile", (NBTBase)this.projectile.serializeNBT());
        compound.func_74782_a("general", (NBTBase)this.general.serializeNBT());
    }

    public void writeSpawnData(ByteBuf additionalData) {
        ByteBufUtils.writeTag((ByteBuf)additionalData, (NBTTagCompound)this.projectile.serializeNBT());
        ByteBufUtils.writeTag((ByteBuf)additionalData, (NBTTagCompound)this.general.serializeNBT());
        additionalData.writeInt(this.shooterId);
        ItemStackHelper.writeItemStackToBufIgnoreTag(additionalData, this.item);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.projectile = new Gun.Projectile();
        this.projectile.deserializeNBT(ByteBufUtils.readTag((ByteBuf)additionalData));
        this.general = new Gun.General();
        this.general.deserializeNBT(ByteBufUtils.readTag((ByteBuf)additionalData));
        this.shooterId = additionalData.readInt();
        this.item = ItemStackHelper.readItemStackFromBufIgnoreTag(additionalData);
        this.func_70105_a(this.projectile.size, this.projectile.size);
    }

    public void updateHeading() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public Gun.Projectile getProjectile() {
        return this.projectile;
    }

    private Vec3d getVectorFromRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public EntityLivingBase getShooter() {
        return this.shooter;
    }

    public float getDamage() {
        float damage = (this.projectile.damage + this.additionalDamage) * this.damageModifier;
        if (this.projectile.damageReduceOverLife) {
            float modifier = ((float)this.projectile.life - (float)(this.field_70173_aa - 1)) / (float)this.projectile.life;
            damage *= modifier;
        }
        return damage / (float)this.general.projectileAmount;
    }
}

