/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.event;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.client.audio.SoundRinging;
import com.mrcrayfish.guns.init.ModPotions;
import java.lang.reflect.Field;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import paulscode.sound.SoundSystem;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class SoundEvents {
    private static final Map<String, Float> SOUND_VOLUMES = new ConcurrentHashMap<String, Float>();
    private static boolean isDeafened;
    private static Field soundSystem;
    private static Field playingSounds;
    private static SoundManager soundManager;
    private static SoundRinging ringing;

    public static void initReflection() {
        soundSystem = ReflectionHelper.findField(SoundManager.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)SoundManager.class.getName(), (String[])new String[]{"field_148620_e"}));
        playingSounds = ReflectionHelper.findField(SoundManager.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)SoundManager.class.getName(), (String[])new String[]{"field_148629_h"}));
    }

    @SubscribeEvent
    public static void deafenPlayer(TickEvent.ClientTickEvent event) {
        Map playingSounds;
        SoundSystem soundSystem;
        if (event.phase == TickEvent.Phase.START || Minecraft.func_71410_x().field_71439_g == null || soundManager == null) {
            return;
        }
        PotionEffect effect = Minecraft.func_71410_x().field_71439_g.func_70660_b(ModPotions.DEAFENED);
        if (effect == null) {
            if (!isDeafened) {
                return;
            }
        } else {
            isDeafened = true;
            if (GunConfig.SERVER.stunGrenades.deafen.ringVolumeSynced > 0.0f && (ringing == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)ringing))) {
                ringing = new SoundRinging();
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)ringing);
                return;
            }
        }
        try {
            soundSystem = (SoundSystem)SoundEvents.soundSystem.get(soundManager);
            playingSounds = (Map)SoundEvents.playingSounds.get(soundManager);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return;
        }
        if (effect != null) {
            try {
                for (String id : playingSounds.keySet()) {
                    ISound sound = (ISound)playingSounds.get(id);
                    if (sound == null || sound instanceof ITickableSound || SoundEvents.isStunGrenade(sound.func_184364_b().func_188719_a())) continue;
                    if (!SOUND_VOLUMES.containsKey(id)) {
                        SOUND_VOLUMES.put(id, Float.valueOf(sound instanceof SoundMuted ? ((SoundMuted)sound).getVolumeInitial() : soundSystem.getVolume(id)));
                    }
                    soundSystem.setVolume(id, SoundEvents.getMutedVolume(effect.func_76459_b(), SOUND_VOLUMES.get(id).floatValue()));
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            isDeafened = true;
        } else if (isDeafened) {
            isDeafened = false;
            for (Map.Entry<String, Float> entry : SOUND_VOLUMES.entrySet()) {
                soundSystem.setVolume(entry.getKey(), entry.getValue().floatValue());
            }
            SOUND_VOLUMES.clear();
        }
    }

    @SubscribeEvent
    public static void lowerInitialVolume(PlaySoundEvent event) {
        if (soundManager == null) {
            soundManager = event.getManager();
        }
        if (!isDeafened || Minecraft.func_71410_x().field_71439_g == null || event.getSound() instanceof ITickableSound) {
            return;
        }
        ResourceLocation loc = event.getSound().func_147650_b();
        PotionEffect effect = Minecraft.func_71410_x().field_71439_g.func_70660_b(ModPotions.DEAFENED);
        int duration = effect != null ? effect.func_76459_b() : 0;
        boolean isStunGrenade = SoundEvents.isStunGrenade(loc);
        if (duration == 0 && isStunGrenade) {
            return;
        }
        event.getSound().func_184366_a(Minecraft.func_71410_x().func_147118_V());
        event.setResultSound((ISound)new SoundMuted(event.getSound(), duration, isStunGrenade));
    }

    private static boolean isStunGrenade(ResourceLocation loc) {
        return loc.toString().equals("cgm:grenade_stun_explosion");
    }

    private static float getMutedVolume(float duration, float volumeBase) {
        float volumeMin = volumeBase * GunConfig.SERVER.stunGrenades.deafen.soundPercentageSynced;
        float percent = Math.min(duration / (float)GunConfig.SERVER.stunGrenades.deafen.soundFadeThresholdSynced, 1.0f);
        return volumeMin + (1.0f - percent) * (volumeBase - volumeMin);
    }

    public static class SoundMuted
    implements ISound {
        private ISound parent;
        private float volume;
        private float volumeInitial;

        public SoundMuted(ISound parent, int duration, boolean isStunGrenade) {
            this.parent = parent;
            this.volumeInitial = MathHelper.func_76131_a((float)parent.func_147653_e(), (float)0.0f, (float)1.0f);
            this.volume = SoundEvents.getMutedVolume(duration, this.volumeInitial);
            if (isStunGrenade) {
                this.volumeInitial = this.volume;
            }
        }

        public float func_147653_e() {
            return this.volume;
        }

        public float getVolumeInitial() {
            return this.volumeInitial;
        }

        public ResourceLocation func_147650_b() {
            return this.parent.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            return this.parent.func_184366_a(handler);
        }

        public Sound func_184364_b() {
            return this.parent.func_184364_b();
        }

        public SoundCategory func_184365_d() {
            return this.parent.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.parent.func_147657_c();
        }

        public int func_147652_d() {
            return this.parent.func_147652_d();
        }

        public float func_147655_f() {
            return this.parent.func_147655_f();
        }

        public float func_147649_g() {
            return this.parent.func_147649_g();
        }

        public float func_147654_h() {
            return this.parent.func_147654_h();
        }

        public float func_147651_i() {
            return this.parent.func_147651_i();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.parent.func_147656_j();
        }
    }
}

