/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.tesla;

import mekanism.common.base.IEnergyWrapper;
import mekanism.common.config.MekanismConfig;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
public class TeslaIntegration
implements ITeslaHolder,
ITeslaConsumer,
ITeslaProducer {
    public IEnergyWrapper tileEntity;
    public EnumFacing side;

    public TeslaIntegration(IEnergyWrapper tile, EnumFacing facing) {
        this.tileEntity = tile;
        this.side = facing;
    }

    public static long toTesla(double joules) {
        return Math.round(joules * MekanismConfig.current().general.TO_TESLA.val());
    }

    public static double toTeslaAsDouble(double joules) {
        return joules * MekanismConfig.current().general.TO_TESLA.val();
    }

    public static double fromTesla(long tesla) {
        return (double)tesla * MekanismConfig.current().general.FROM_TESLA.val();
    }

    public static double fromTesla(double tesla) {
        return tesla * MekanismConfig.current().general.FROM_TESLA.val();
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return TeslaIntegration.toTesla(this.tileEntity.getEnergy());
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return TeslaIntegration.toTesla(this.tileEntity.getMaxEnergy());
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulate) {
        return TeslaIntegration.toTesla(this.tileEntity.pullEnergy(this.side, TeslaIntegration.fromTesla(power), simulate));
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulate) {
        return TeslaIntegration.toTesla(this.tileEntity.acceptEnergy(this.side, TeslaIntegration.fromTesla(power), simulate));
    }
}

