/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.Arrays;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiRecipeType;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiSortingTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.IFactory;
import mekanism.common.inventory.container.ContainerFactory;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiFactory
extends GuiMekanismTile<TileEntityFactory> {
    private GuiButton infuserDumpButton = null;

    public GuiFactory(InventoryPlayer inventory, TileEntityFactory tile) {
        super(tile, new ContainerFactory(inventory, tile));
        this.field_147000_g += 11;
        ResourceLocation resource = ((TileEntityFactory)this.tileEntity).tier.guiLocation;
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiRecipeType(this, (TileEntityFactory)this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiSortingTab(this, (TileEntityFactory)this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityFactory)this.tileEntity).lastUsage);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityFactory)this.tileEntity).getMaxEnergy() - ((TileEntityFactory)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.infuserDumpButton = new GuiButtonImage(1, this.field_147003_i + 6, this.field_147009_r + 44, 21, 10, 147, 72, 0, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiMetallurgicInfuser.png")){

            public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
                if (((TileEntityFactory)GuiFactory.this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING) {
                    super.func_191745_a(mc, mouseX, mouseY, partialTicks);
                }
            }

            public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
                return ((TileEntityFactory)GuiFactory.this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING && super.func_146116_c(mc, mouseX, mouseY);
            }
        };
        this.field_146292_n.add(this.infuserDumpButton);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFactory)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFactory)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 93 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 165 && xAxis <= 169 && yAxis >= 17 && yAxis <= 69) {
            this.displayTooltip(MekanismUtils.getEnergyDisplay(((TileEntityFactory)this.tileEntity).getEnergy(), ((TileEntityFactory)this.tileEntity).getMaxEnergy()), xAxis, yAxis);
        } else if (xAxis >= 8 && xAxis <= 168 && yAxis >= 78 && yAxis <= 83) {
            if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.ADVANCED) {
                GasStack gasStack = ((TileEntityFactory)this.tileEntity).gasTank.getGas();
                this.displayTooltip(gasStack != null ? gasStack.getGas().getLocalizedName() + ": " + ((TileEntityFactory)this.tileEntity).gasTank.getStored() : LangUtils.localize("gui.none"), xAxis, yAxis);
            } else if (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING) {
                InfuseType type = ((TileEntityFactory)this.tileEntity).infuseStored.getType();
                this.displayTooltip(type != null ? type.getLocalizedName() + ": " + ((TileEntityFactory)this.tileEntity).infuseStored.getAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        int xOffset;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        int displayInt = ((TileEntityFactory)this.tileEntity).getScaledEnergyLevel(52);
        this.func_73729_b(this.field_147003_i + 165, this.field_147009_r + 17 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);
        int n = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.BASIC ? 59 : (xOffset = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.ADVANCED ? 39 : 33);
        int xDistance = ((TileEntityFactory)this.tileEntity).tier == FactoryTier.BASIC ? 38 : (((TileEntityFactory)this.tileEntity).tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < ((TileEntityFactory)this.tileEntity).tier.processes; ++i) {
            int xPos = xOffset + i * xDistance;
            displayInt = ((TileEntityFactory)this.tileEntity).getScaledProgress(20, i);
            this.func_73729_b(this.field_147003_i + xPos, this.field_147009_r + 33, 176, 52, 8, displayInt);
        }
        if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            GasStack gas;
            if (((TileEntityFactory)this.tileEntity).getScaledGasLevel(160) > 0 && (gas = ((TileEntityFactory)this.tileEntity).gasTank.getGas()) != null) {
                MekanismRenderer.color(gas);
                this.displayGauge(8, 78, ((TileEntityFactory)this.tileEntity).getScaledGasLevel(160), 5, gas.getGas().getSprite());
                MekanismRenderer.resetColor();
            }
        } else if (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING && ((TileEntityFactory)this.tileEntity).getScaledInfuseLevel(160) > 0) {
            this.displayGauge(8, 78, ((TileEntityFactory)this.tileEntity).getScaledInfuseLevel(160), 5, ((TileEntityFactory)this.tileEntity).infuseStored.getType().sprite);
        }
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, TextureAtlasSprite icon) {
        if (icon != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.func_175175_a(this.field_147003_i + xPos, this.field_147009_r + yPos, icon, sizeX, sizeY);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || Keyboard.isKeyDown((int)42)) {
            ItemStack stack;
            int xAxis = x - this.field_147003_i;
            int yAxis = y - this.field_147009_r;
            if (xAxis > 8 && xAxis < 168 && yAxis > 78 && yAxis < 83 && !(stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper) {
                TileNetworkList data = TileNetworkList.withContents(1);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return ((TileEntityFactory)this.tileEntity).tier.guiLocation;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.infuserDumpButton) {
            TileNetworkList data = TileNetworkList.withContents(1);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

