/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.animation.bit.biped.item;

import goblinbob.mobends.core.animation.bit.AnimationBit;
import goblinbob.mobends.core.animation.layer.HardAnimationLayer;
import goblinbob.mobends.standard.AttackActionType;
import goblinbob.mobends.standard.UseActionType;
import goblinbob.mobends.standard.animation.bit.biped.EatingAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.ShieldAnimationBit;
import goblinbob.mobends.standard.animation.bit.biped.item.BowAction;
import goblinbob.mobends.standard.animation.bit.biped.item.ItemActionFactory;
import goblinbob.mobends.standard.animation.bit.biped.item.PunchingAction;
import goblinbob.mobends.standard.animation.bit.biped.item.SwordAction;
import goblinbob.mobends.standard.animation.bit.biped.item.ToolAction;
import goblinbob.mobends.standard.data.BipedEntityData;
import goblinbob.mobends.standard.main.ModConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;

public class BipedActionController {
    protected HardAnimationLayer<BipedEntityData<?>> layerAction = new HardAnimationLayer();
    protected UseActionType currentUseActionType = null;
    protected AttackActionType currentAttackActionType = null;
    protected AnimationBit<BipedEntityData<?>> actionBit = null;
    private static final Map<UseActionType, ItemActionFactory<AnimationBit<BipedEntityData<?>>>> ITEM_USE_ACTION_MAP = new HashMap();
    private static final Map<AttackActionType, ItemActionFactory<AnimationBit<BipedEntityData<?>>>> ITEM_ATTACK_ACTION_MAP = new HashMap();

    private static ModelBiped.ArmPose getAction(EntityLivingBase entity, ItemStack heldItem) {
        if (!heldItem.func_190926_b()) {
            if (entity.func_184605_cv() > 0) {
                EnumAction enumaction = heldItem.func_77975_n();
                if (enumaction == EnumAction.BLOCK) {
                    return ModelBiped.ArmPose.BLOCK;
                }
                if (enumaction == EnumAction.BOW) {
                    return ModelBiped.ArmPose.BOW_AND_ARROW;
                }
            }
            return ModelBiped.ArmPose.ITEM;
        }
        return ModelBiped.ArmPose.EMPTY;
    }

    public static UseActionType getBuiltInItemUseAction(Item item, ModelBiped.ArmPose armPoseMain, ModelBiped.ArmPose armPoseOff) {
        if (item == Items.field_190931_a) {
            return null;
        }
        if (item instanceof ItemFood) {
            return UseActionType.FOOD;
        }
        if (item instanceof ItemBow || armPoseMain == ModelBiped.ArmPose.BOW_AND_ARROW || armPoseOff == ModelBiped.ArmPose.BOW_AND_ARROW) {
            return UseActionType.BOW;
        }
        if (armPoseMain == ModelBiped.ArmPose.BLOCK || armPoseOff == ModelBiped.ArmPose.BLOCK) {
            return UseActionType.SHIELD;
        }
        return UseActionType.FOOD;
    }

    public static UseActionType getItemUseAction(Item item, ModelBiped.ArmPose armPoseMain, ModelBiped.ArmPose armPoseOff) {
        UseActionType useActionType = ModConfig.getItemUseAction(item);
        return useActionType != null ? useActionType : BipedActionController.getBuiltInItemUseAction(item, armPoseMain, armPoseOff);
    }

    public static AttackActionType getBuiltInItemAttackAction(Item item) {
        if (item instanceof ItemSword) {
            return AttackActionType.SWORD;
        }
        if (item == Items.field_190931_a) {
            return AttackActionType.FISTS;
        }
        return AttackActionType.TOOL;
    }

    public static AttackActionType getItemAttackAction(Item item) {
        AttackActionType attackActionType = ModConfig.getItemAttackAction(item);
        return attackActionType != null ? attackActionType : BipedActionController.getBuiltInItemAttackAction(item);
    }

    public void perform(BipedEntityData<?> data, EnumHandSide primaryHand, ItemStack heldItemMainhand, ItemStack heldItemOffhand, Item activeItem) {
        AttackActionType attackActionType;
        Object entity = data.getEntity();
        EnumHandSide offHand = primaryHand == EnumHandSide.RIGHT ? EnumHandSide.LEFT : EnumHandSide.RIGHT;
        ModelBiped.ArmPose armPoseMain = BipedActionController.getAction(entity, heldItemMainhand);
        ModelBiped.ArmPose armPoseOff = BipedActionController.getAction(entity, heldItemOffhand);
        EnumHandSide activeHandSide = entity.func_184600_cs() == EnumHand.MAIN_HAND ? primaryHand : offHand;
        UseActionType useActionType = BipedActionController.getItemUseAction(activeItem, armPoseMain, armPoseOff);
        if (useActionType != this.currentUseActionType) {
            this.currentUseActionType = useActionType;
            if (useActionType != null) {
                ItemActionFactory<AnimationBit<BipedEntityData<?>>> factory = ITEM_USE_ACTION_MAP.get((Object)useActionType);
                this.actionBit = factory.create(activeHandSide);
                this.layerAction.playOrContinueBit(this.actionBit, data);
            } else {
                this.layerAction.clearAnimation();
                this.currentAttackActionType = null;
            }
        }
        if (this.currentAttackActionType != (attackActionType = BipedActionController.getItemAttackAction(heldItemMainhand.func_77973_b()))) {
            this.currentAttackActionType = attackActionType;
            ItemActionFactory<AnimationBit<BipedEntityData<?>>> factory = ITEM_ATTACK_ACTION_MAP.get((Object)attackActionType);
            if (factory == null) {
                this.actionBit = null;
                this.layerAction.clearAnimation();
            } else {
                this.actionBit = factory.create(primaryHand);
                this.layerAction.playOrContinueBit(this.actionBit, data);
            }
        }
        this.layerAction.perform(data);
    }

    public void clearAction() {
        this.layerAction.clearAnimation();
    }

    static {
        ITEM_USE_ACTION_MAP.put(UseActionType.FOOD, EatingAnimationBit::new);
        ITEM_USE_ACTION_MAP.put(UseActionType.BOW, BowAction::new);
        ITEM_USE_ACTION_MAP.put(UseActionType.SHIELD, ShieldAnimationBit::new);
        ITEM_ATTACK_ACTION_MAP.put(AttackActionType.TOOL, ToolAction::new);
        ITEM_ATTACK_ACTION_MAP.put(AttackActionType.FISTS, PunchingAction::new);
        ITEM_ATTACK_ACTION_MAP.put(AttackActionType.SWORD, SwordAction::new);
        for (UseActionType useActionType : UseActionType.values()) {
            if (ITEM_USE_ACTION_MAP.containsKey((Object)useActionType)) continue;
            throw new IllegalStateException("The ITEM_USE_ACTION_MAP map needs to be complete.");
        }
        for (Enum enum_ : AttackActionType.values()) {
            if (ITEM_ATTACK_ACTION_MAP.containsKey(enum_)) continue;
            throw new IllegalStateException("The ITEM_ATTACK_ACTION_MAP map needs to be complete.");
        }
    }
}

