/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.client.render.entity.sophisticatedwolves;

import dev.itsmeow.betteranimals.client.model.ModelNewWolf2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;
import sophisticated_wolves.SWConfiguration;
import sophisticated_wolves.api.EnumWolfSpecies;
import sophisticated_wolves.entity.EntitySophisticatedWolf;

public class RenderNewSophisticatedWolf
extends RenderLiving<EntitySophisticatedWolf> {
    private static final ResourceLocation BROWN_WOLF = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/brown/wolf_brown.png");
    private static final ResourceLocation BROWN_WOLF_TAME = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/brown/wolf_brown_tame.png");
    private static final ResourceLocation BROWN_WOLF_ANGRY = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/brown/wolf_brown_angry.png");
    private static final ResourceLocation BLACK_WOLF = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/black/wolf_black.png");
    private static final ResourceLocation BLACK_WOLF_TAME = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/black/wolf_black_tame.png");
    private static final ResourceLocation BLACK_WOLF_ANGRY = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/black/wolf_black_angry.png");
    private static final ResourceLocation FOREST_WOLF = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/forest/wolf_forest.png");
    private static final ResourceLocation FOREST_WOLF_TAME = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/forest/wolf_forest_tame.png");
    private static final ResourceLocation FOREST_WOLF_ANGRY = new ResourceLocation("betteranimals", "textures/mobs/wolf/sophisticatedwolves/forest/wolf_forest_angry.png");
    private static final ResourceLocation WOLF = new ResourceLocation("betteranimals", "textures/mobs/wolf/wolf.png");
    private static final ResourceLocation WOLF_TAME = new ResourceLocation("betteranimals", "textures/mobs/wolf/wolf_tame.png");
    private static final ResourceLocation WOLF_ANGRY = new ResourceLocation("betteranimals", "textures/mobs/wolf/wolf_angry.png");
    private static int HEALTH_2 = SWConfiguration.wolvesHealthTamed / 4 * 3;
    private static int HEALTH_3 = SWConfiguration.wolvesHealthTamed / 2;
    private static int HEALTH_4 = SWConfiguration.wolvesHealthTamed / 4;

    public RenderNewSophisticatedWolf(RenderManager m) {
        super(m, (ModelBase)new ModelNewWolf2(), 0.4f);
        this.func_177094_a(new LayerNewSophisticatedWolfCollar(this));
    }

    protected float handleRotationFloat(EntitySophisticatedWolf wolf, float partialTicks) {
        return wolf.func_70920_v();
    }

    protected void preRenderCallback(EntitySophisticatedWolf wolf, float partialTickTime) {
        if (this.func_177087_b().field_78091_s) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        } else {
            GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
        }
    }

    public void doRender(EntitySophisticatedWolf wolf, double x, double y, double z, float entityYaw, float partialTicks) {
        if (wolf.func_70921_u()) {
            float f = wolf.func_70013_c() * wolf.func_70915_j(partialTicks);
            GlStateManager.func_179124_c((float)f, (float)f, (float)f);
        }
        super.func_76986_a((EntityLiving)wolf, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntitySophisticatedWolf wolf) {
        if (wolf.getSpecies() == EnumWolfSpecies.BROWN) {
            if (wolf.func_70909_n()) {
                return BROWN_WOLF_TAME;
            }
            if (wolf.func_70919_bu()) {
                return BROWN_WOLF_ANGRY;
            }
            return BROWN_WOLF;
        }
        if (wolf.getSpecies() == EnumWolfSpecies.BLACK) {
            if (wolf.func_70909_n()) {
                return BLACK_WOLF_TAME;
            }
            if (wolf.func_70919_bu()) {
                return BLACK_WOLF_ANGRY;
            }
            return BLACK_WOLF;
        }
        if (wolf.getSpecies() == EnumWolfSpecies.FOREST) {
            if (wolf.func_70909_n()) {
                return FOREST_WOLF_TAME;
            }
            if (wolf.func_70919_bu()) {
                return FOREST_WOLF_ANGRY;
            }
            return FOREST_WOLF;
        }
        if (wolf.getSpecies() == EnumWolfSpecies.VANILLA) {
            if (wolf.func_70909_n()) {
                return WOLF_TAME;
            }
            if (wolf.func_70919_bu()) {
                return WOLF_ANGRY;
            }
            return WOLF;
        }
        return WOLF;
    }

    public void renderName(EntitySophisticatedWolf entity, double x, double y, double z) {
        EntitySophisticatedWolf wolf = entity;
        if (wolf.func_70909_n() && Minecraft.func_71382_s() && StringUtils.isNotBlank((CharSequence)wolf.func_95999_t()) && wolf.func_95999_t().length() > 0) {
            this.renderWolfName(wolf, x, y, z);
        }
    }

    public void renderWolfName(EntitySophisticatedWolf wolf, double d, double d1, double d2) {
        float f3;
        float f = 1.6f;
        float f1 = 0.01666667f * f;
        float f2 = wolf.func_70032_d(this.field_76990_c.field_78734_h);
        float f4 = f3 = wolf.func_70906_o() ? 32.0f : 64.0f;
        if (f2 < f3) {
            String wolfName = wolf.func_95999_t();
            FontRenderer fontRenderer = this.func_76983_a();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1 + 1.5f), (float)((float)d2));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3553);
            if (!wolf.func_70906_o()) {
                fontRenderer.func_78276_b(wolfName, -fontRenderer.func_78256_a(wolfName) / 2, 0, this.getSitNameColor(wolf));
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                fontRenderer.func_78276_b(wolfName, -fontRenderer.func_78256_a(wolfName) / 2, 0, this.getWolfNameColor(wolf));
            } else {
                GL11.glDepthMask((boolean)true);
                fontRenderer.func_78276_b(wolfName, -fontRenderer.func_78256_a(wolfName) / 2, 0, this.getSitNameColor(wolf));
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public int getWolfNameColor(EntitySophisticatedWolf wolf) {
        if (wolf.func_110143_aJ() < (float)SWConfiguration.wolvesHealthTamed) {
            if (wolf.func_110143_aJ() <= (float)HEALTH_2) {
                if (wolf.func_110143_aJ() <= (float)HEALTH_3) {
                    if (wolf.func_110143_aJ() <= (float)HEALTH_4) {
                        return -65022;
                    }
                    return -108970;
                }
                return -26986;
            }
            return -78644;
        }
        return -1;
    }

    public int getSitNameColor(EntitySophisticatedWolf wolf) {
        if (wolf.func_110143_aJ() < (float)SWConfiguration.wolvesHealthTamed) {
            if (wolf.func_110143_aJ() <= (float)HEALTH_2) {
                if (wolf.func_110143_aJ() <= (float)HEALTH_3) {
                    if (wolf.func_110143_aJ() <= (float)HEALTH_4) {
                        return 1090454018;
                    }
                    return 1090410070;
                }
                return 1090492054;
            }
            return 1090440396;
        }
        return 0x40FFFFFF;
    }

    public static class LayerNewSophisticatedWolfCollar
    implements LayerRenderer<EntitySophisticatedWolf> {
        private static final ResourceLocation COLLAR_TEXTURE = new ResourceLocation("betteranimals", "textures/mobs/wolf/wolf_tame_collar.png");
        private final RenderNewSophisticatedWolf wolfRenderer;

        public LayerNewSophisticatedWolfCollar(RenderNewSophisticatedWolf wolfRendererIn) {
            this.wolfRenderer = wolfRendererIn;
        }

        public void doRenderLayer(EntitySophisticatedWolf entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (entitylivingbaseIn.func_70909_n() && !entitylivingbaseIn.func_82150_aj()) {
                this.wolfRenderer.func_110776_a(COLLAR_TEXTURE);
                float[] afloat = entitylivingbaseIn.func_175546_cu().func_193349_f();
                GlStateManager.func_179124_c((float)afloat[0], (float)afloat[1], (float)afloat[2]);
                this.wolfRenderer.func_177087_b().func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

