/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint.render;

import java.util.Hashtable;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.waypoint.render.WaypointDeleter;
import xaero.hud.minimap.waypoint.render.WaypointGuiRenderContext;
import xaero.hud.minimap.waypoint.render.WaypointReader;
import xaero.hud.minimap.waypoint.render.WaypointRenderProvider;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.render.TextureLocations;

public abstract class WaypointsGuiRenderer
extends MinimapElementRenderer<Waypoint, WaypointGuiRenderContext> {
    private final IXaeroMinimap modMain;
    private final WaypointDeleter waypointReachDeleter;

    protected WaypointsGuiRenderer(IXaeroMinimap modMain, WaypointReader elementReader, WaypointRenderProvider provider, WaypointGuiRenderContext context, WaypointDeleter waypointReachDeleter) {
        super(elementReader, provider, context);
        this.modMain = modMain;
        this.waypointReachDeleter = waypointReachDeleter;
    }

    @Override
    public boolean renderElement(Waypoint w, boolean highlit, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo) {
        MinimapElementRenderLocation location = renderInfo.location;
        this.handleDestinationWaypoints(w, renderInfo);
        GlStateManager.func_179137_b((double)-1.0, (double)-1.0, (double)optionalDepth);
        if (((WaypointGuiRenderContext)this.context).scale <= 0 || location != MinimapElementRenderLocation.OVER_MINIMAP) {
            GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
        } else {
            GlStateManager.func_179152_a((float)((WaypointGuiRenderContext)this.context).scale, (float)((WaypointGuiRenderContext)this.context).scale, (float)1.0f);
        }
        this.drawIconOnGUI(((WaypointGuiRenderContext)this.context).helper, w, ((WaypointGuiRenderContext)this.context).settings, 0, 0);
        return true;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo) {
        ((WaypointGuiRenderContext)this.context).settings = this.modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints = this.modMain.getSettings().deleteReachedDeathpoints;
        ((WaypointGuiRenderContext)this.context).scale = this.modMain.getSettings().waypointOnMapScale;
        GlStateManager.func_179141_d();
        ((WaypointGuiRenderContext)this.context).helper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
        this.updateWaypointCollection();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        ((WaypointGuiRenderContext)this.context).dimDiv = session.getDimensionHelper().getDimensionDivision(session.getWorldManager().getCurrentWorld());
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        Vec3d cameraPos = ActiveRenderInfo.getCameraPosition().func_72441_c(renderViewEntity.field_70165_t, renderViewEntity.field_70163_u, renderViewEntity.field_70161_v);
        Waypoint.RENDER_SORTING_POS = new Vec3d(cameraPos.field_72450_a * ((WaypointGuiRenderContext)this.context).dimDiv, cameraPos.field_72448_b, cameraPos.field_72449_c * ((WaypointGuiRenderContext)this.context).dimDiv);
        ModSettings settings = this.modMain.getSettings();
        ((WaypointGuiRenderContext)this.context).filterParams.cameraPos = cameraPos;
        ((WaypointGuiRenderContext)this.context).filterParams.actualEntityX = 0.0;
        ((WaypointGuiRenderContext)this.context).filterParams.actualEntityY = 0.0;
        ((WaypointGuiRenderContext)this.context).filterParams.actualEntityZ = 0.0;
        WaypointFilterParams oldFilterParams = (WaypointFilterParams)((WaypointGuiRenderContext)this.context).filterParams;
        oldFilterParams.cameraX = cameraPos.field_72450_a;
        oldFilterParams.cameraY = cameraPos.field_72448_b;
        oldFilterParams.cameraZ = cameraPos.field_72449_c;
        ((WaypointGuiRenderContext)this.context).filterParams.lookVector = null;
        ((WaypointGuiRenderContext)this.context).filterParams.dimDiv = ((WaypointGuiRenderContext)this.context).dimDiv;
        ((WaypointGuiRenderContext)this.context).filterParams.deathpoints = settings.getDeathpoints();
        ((WaypointGuiRenderContext)this.context).filterParams.temporaryWaypointsGlobal = settings.temporaryWaypointsGlobal;
        ((WaypointGuiRenderContext)this.context).filterParams.waypointsDistance = settings.getMaxWaypointsDistance();
        ((WaypointGuiRenderContext)this.context).filterParams.waypointsDistanceMin = settings.waypointsDistanceMin;
        ((WaypointGuiRenderContext)this.context).filterParams.playerY = 0.0;
        ((WaypointGuiRenderContext)this.context).filterParams.dimensionScaleDistance = settings.dimensionScaledMaxWaypointDistance;
        this.waypointReachDeleter.begin();
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo) {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager manager = session.getWorldManager();
        this.waypointReachDeleter.deleteCollected(session, manager.getCurrentWorld(), this.modMain.getSettings().renderAllSets);
    }

    private void handleDestinationWaypoints(Waypoint renderedWaypoint, MinimapElementRenderInfo renderInfo) {
        double correctOffZ;
        double correctDistance;
        if (!renderedWaypoint.isDestination()) {
            return;
        }
        if (!((WaypointGuiRenderContext)this.context).deleteReachedDeathpoints && renderedWaypoint.getPurpose().isDeath()) {
            return;
        }
        if (System.currentTimeMillis() - renderedWaypoint.getCreatedAt() <= 5000L) {
            return;
        }
        Entity renderEntity = renderInfo.renderEntity;
        double correctOffX = renderEntity.field_70165_t - (double)renderedWaypoint.getX(((WaypointGuiRenderContext)this.context).dimDiv);
        double correctOffY = renderEntity.field_70163_u - (double)renderedWaypoint.getY();
        if (!renderedWaypoint.isYIncluded()) {
            correctOffY = 0.0;
        }
        if ((correctDistance = Math.sqrt(correctOffX * correctOffX + correctOffY * correctOffY + (correctOffZ = renderEntity.field_70161_v - (double)renderedWaypoint.getZ(((WaypointGuiRenderContext)this.context).dimDiv)) * correctOffZ)) < 4.0) {
            this.waypointReachDeleter.add(renderedWaypoint);
        }
    }

    public void updateWaypointCollection() {
        Hashtable<String, Hashtable<Integer, Waypoint>> customWaypoints;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager manager = session.getWorldManager();
        List<Waypoint> sortingList = ((WaypointGuiRenderContext)this.context).sortingList;
        sortingList.clear();
        if (manager.getCurrentWorld() != null) {
            if (this.modMain.getSettings().renderAllSets) {
                for (WaypointSet set : manager.getCurrentWorld().getIterableWaypointSets()) {
                    set.addTo(sortingList);
                }
            } else {
                manager.getCurrentWorld().getCurrentWaypointSet().addTo(sortingList);
            }
        }
        if (!(customWaypoints = WaypointsManager.customWaypoints).isEmpty()) {
            for (Hashtable<Integer, Waypoint> modCustomWaypoints : customWaypoints.values()) {
                sortingList.addAll(modCustomWaypoints.values());
            }
        }
        if (!manager.hasCustomWaypoints()) {
            return;
        }
        for (Waypoint waypoint : manager.getCustomWaypoints()) {
            sortingList.add(waypoint);
        }
    }

    public void drawIconOnGUI(MinimapRendererHelper rendererHelper, Waypoint w, ModSettings settings, int drawX, int drawY) {
        int color = w.getWaypointColor().getHex();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int a = (int)(255.0f * ((float)settings.waypointOpacityMap / 100.0f));
        color = a << 24 | r << 16 | g << 8 | b;
        int initialsWidth = w.getPurpose() == WaypointPurpose.DEATH ? 7 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getInitials());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5;
        Gui.func_73734_a((int)rectX1, (int)rectY1, (int)rectX2, (int)rectY2, (int)color);
        if (w.getPurpose() == WaypointPurpose.DEATH) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
            GlStateManager.func_179131_c((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1 + 1, rectY1 + 1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Minecraft.func_71410_x().field_71456_v.func_73729_b(rectX1, rectY1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        GlStateManager.func_179097_i();
        Minecraft.func_71410_x().field_71466_p.func_175063_a(w.getInitials(), (float)(drawX + 1 - initialsWidth / 2), (float)(drawY - 3), -1);
    }

    @Deprecated
    public void drawSetChange(WaypointsManager waypointsManager, ScaledResolution res) {
        this.drawSetChange((MinimapSession)waypointsManager, res);
    }

    public void drawSetChange(MinimapSession session, ScaledResolution res) {
        MinimapWorld minimapWorld = session.getWorldManager().getCurrentWorld();
        if (minimapWorld == null) {
            return;
        }
        WaypointSession waypointSession = session.getWaypointSession();
        if (waypointSession.getSetChangedTime() == 0L) {
            return;
        }
        int passed = (int)(System.currentTimeMillis() - waypointSession.getSetChangedTime());
        if (passed >= 1500) {
            waypointSession.setSetChangedTime(0L);
            return;
        }
        int fadeTime = 300;
        boolean fading = passed > 1500 - fadeTime;
        float fadeFactor = fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f;
        int alpha = 3 + (int)(252.0f * fadeFactor);
        int c = 0xFFFFFF | alpha << 24;
        GlStateManager.func_179097_i();
        Minecraft.func_71410_x().field_71456_v.func_73732_a(Minecraft.func_71410_x().field_71466_p, I18n.func_135052_a((String)minimapWorld.getCurrentWaypointSet().getName(), (Object[])new Object[0]), res.func_78326_a() / 2, res.func_78328_b() / 2 + 50, c);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        if (!(location != MinimapElementRenderLocation.OVER_MINIMAP && location != MinimapElementRenderLocation.IN_MINIMAP || this.modMain.getSettings().getShowWaypoints())) {
            return false;
        }
        return !Misc.hasEffect(Effects.NO_WAYPOINTS) && !Misc.hasEffect(Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 1;
    }

    public static final class Builder {
        private WaypointDeleter waypointDeleter;
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            this.setWaypointDeleter(null);
            return this;
        }

        public Builder setWaypointDeleter(WaypointDeleter waypointDeleter) {
            this.waypointDeleter = waypointDeleter;
            return this;
        }

        public WaypointsGuiRenderer build() {
            if (this.waypointDeleter == null) {
                throw new IllegalStateException();
            }
            final xaero.common.minimap.waypoints.render.WaypointGuiRenderContext context = new xaero.common.minimap.waypoints.render.WaypointGuiRenderContext();
            context.filter = new Predicate<Waypoint>(){

                @Override
                public boolean test(Waypoint w) {
                    WaypointFilterParams filterParams = context.filterParams;
                    if (w.isDisabled()) {
                        return false;
                    }
                    if (w.getVisibility() == WaypointVisibilityType.WORLD_MAP_LOCAL) {
                        return false;
                    }
                    if (w.getVisibility() == WaypointVisibilityType.WORLD_MAP_GLOBAL) {
                        return false;
                    }
                    if (!filterParams.deathpoints && w.getPurpose().isDeath()) {
                        return false;
                    }
                    if (w.isDestination()) {
                        return true;
                    }
                    if (w.getPurpose() == WaypointPurpose.DEATH) {
                        return true;
                    }
                    if (w.isGlobal() || w.isTemporary() && filterParams.temporaryWaypointsGlobal) {
                        return true;
                    }
                    double offx = (double)w.getX(filterParams.dimDiv) + 0.5 - filterParams.cameraPos.field_72450_a;
                    double offz = (double)w.getZ(filterParams.dimDiv) + 0.5 - filterParams.cameraPos.field_72449_c;
                    double distanceScale = context.filterParams.dimensionScaleDistance && Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p() == DimensionType.NETHER ? 8.0 : 1.0;
                    double distance = Math.sqrt(offx * offx + offz * offz) * distanceScale;
                    return filterParams.waypointsDistance == 0.0 || distance <= filterParams.waypointsDistance;
                }
            };
            return new xaero.common.minimap.waypoints.render.WaypointsGuiRenderer(this.modMain, new xaero.common.minimap.waypoints.render.WaypointReader(), new xaero.common.minimap.waypoints.render.WaypointRenderProvider(), context, this.waypointDeleter);
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

