/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import xaero.hud.minimap.info.InfoDisplay;

public abstract class InfoDisplayManager {
    private final Map<String, InfoDisplay<?>> displays = new HashMap();
    private final List<String> defaultOrder = new ArrayList<String>();
    private List<String> order;

    public void add(InfoDisplay<?> infoDisplay) {
        if (this.displays.put(infoDisplay.getId(), infoDisplay) == null) {
            this.defaultOrder.add(infoDisplay.getId());
        }
    }

    public void setOrder(List<String> order) {
        this.order = new ArrayList<String>(order);
        int lastDefaultOrderIdIndex = -1;
        for (int i = 0; i < this.defaultOrder.size(); ++i) {
            String defaultOrderId = this.defaultOrder.get(i);
            int defaultOrderIdIndex = this.order.indexOf(defaultOrderId);
            if (defaultOrderIdIndex == -1) {
                defaultOrderIdIndex = lastDefaultOrderIdIndex != -1 ? lastDefaultOrderIdIndex + 1 : 0;
                this.order.add(defaultOrderIdIndex, defaultOrderId);
            }
            lastDefaultOrderIdIndex = defaultOrderIdIndex;
        }
    }

    public InfoDisplay<?> get(String id) {
        return this.displays.get(id);
    }

    public Stream<InfoDisplay<?>> getOrderedStream() {
        Stream unfilteredResult = this.order.stream().map(new Function<String, InfoDisplay<?>>(){

            @Override
            public InfoDisplay<?> apply(String s) {
                return (InfoDisplay)InfoDisplayManager.this.displays.get(s);
            }
        });
        return unfilteredResult.filter(new Predicate<InfoDisplay<?>>(){

            @Override
            public boolean test(InfoDisplay<?> id) {
                return Objects.nonNull(id);
            }
        });
    }

    public int getCount() {
        return this.displays.size();
    }

    public void reset() {
        this.setOrder(new ArrayList<String>());
        this.getOrderedStream().forEach(new Consumer<InfoDisplay<?>>(){

            @Override
            public void accept(InfoDisplay<?> id) {
                id.reset();
            }
        });
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public InfoDisplayManager build() {
            return new xaero.common.minimap.info.InfoDisplayManager();
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

