/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render.over;

import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.Vec3d;
import xaero.common.HudMod;
import xaero.common.minimap.element.render.MinimapElementRendererHandler;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.element.render.MinimapElementRendererHandler;

public class MinimapElementOverMapRendererHandler
extends MinimapElementRendererHandler {
    private int halfViewW;
    private int halfViewH;
    private int specW;
    private int specH;
    private boolean circle;
    private float optionalScale;
    private final double[] partialTranslate;

    protected MinimapElementOverMapRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, double[] partialTranslate) {
        super(modMain, renderers, MinimapElementRenderLocation.OVER_MINIMAP, 9800);
        this.partialTranslate = partialTranslate;
    }

    public void prepareRender(int specW, int specH, int halfViewW, int halfViewH, boolean circle, float minimapScale) {
        this.specW = specW;
        this.specH = specH;
        this.halfViewW = halfViewW;
        this.halfViewH = halfViewH;
        this.circle = circle;
        this.optionalScale = minimapScale;
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, RR renderer, RRC context, double playerDimDiv, double ps, double pc, double zoom, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo) {
        float partialTicks = renderInfo.partialTicks;
        Vec3d renderPos = renderInfo.renderPos;
        MinimapElementReader<E, RRC> elementReader = renderer.getElementReader();
        double offx = elementReader.getRenderX(element, context, partialTicks) / playerDimDiv - renderPos.field_72450_a;
        double offy = elementReader.getRenderZ(element, context, partialTicks) / playerDimDiv - renderPos.field_72449_c;
        GlStateManager.func_179094_E();
        boolean outOfBounds = MinimapElementOverMapRendererHandler.translatePosition(this.specW, this.specH, this.halfViewW, this.halfViewH, ps, pc, offx, offy, zoom, this.circle, this.partialTranslate);
        boolean result = renderer.renderElement(element, false, outOfBounds, optionalDepth, this.optionalScale, this.partialTranslate[0], this.partialTranslate[1], renderInfo);
        GlStateManager.func_179121_F();
        return result;
    }

    @Override
    protected void beforeRender() {
    }

    @Override
    protected void afterRender() {
    }

    @Override
    protected int getIndexLimit() {
        return 9800;
    }

    public static boolean translatePosition(int specW, int specH, int halfViewW, int halfViewH, double ps, double pc, double offx, double offy, double zoom, boolean circle, double[] partialTranslate) {
        double X;
        boolean outOfBounds = false;
        double Y = (pc * offx + ps * offy) * zoom;
        double borderedX = X = (ps * offx - pc * offy) * zoom;
        double borderedY = Y;
        if (!circle) {
            if (borderedX > (double)specW) {
                borderedX = specW;
                borderedY = Y * (double)specW / X;
                outOfBounds = true;
            } else if (borderedX < (double)(-specW)) {
                borderedX = -specW;
                borderedY = -Y * (double)specW / X;
                outOfBounds = true;
            }
            if (borderedY > (double)specH) {
                borderedY = specH;
                borderedX = X * (double)specH / Y;
                outOfBounds = true;
            } else if (borderedY < (double)(-specH)) {
                borderedY = -specH;
                borderedX = -X * (double)specH / Y;
                outOfBounds = true;
            }
            if (!outOfBounds && (borderedX > (double)halfViewW || borderedX < (double)(-halfViewW) || borderedY > (double)halfViewH || borderedY < (double)(-halfViewH))) {
                outOfBounds = true;
            }
        } else {
            double distSquared = borderedX * borderedX + borderedY * borderedY;
            double maxDistSquared = specW * specW;
            if (distSquared > maxDistSquared) {
                double scaleDown = Math.sqrt(maxDistSquared / distSquared);
                borderedX *= scaleDown;
                borderedY *= scaleDown;
                outOfBounds = true;
            }
            if (!outOfBounds && distSquared > (double)(halfViewW * halfViewW)) {
                outOfBounds = true;
            }
        }
        long roundedX = Math.round(borderedX);
        long roundedY = Math.round(borderedY);
        partialTranslate[0] = borderedX - (double)roundedX;
        partialTranslate[1] = borderedY - (double)roundedY;
        GlStateManager.func_179109_b((float)roundedX, (float)roundedY, (float)0.0f);
        return outOfBounds;
    }

    public static final class Builder
    extends MinimapElementRendererHandler.Builder {
        @Override
        public xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler build() {
            return (xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler)super.build();
        }

        @Override
        protected xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> renderers) {
            return new xaero.common.minimap.element.render.over.MinimapElementOverMapRendererHandler(HudMod.INSTANCE, renderers, new double[2]);
        }

        @Override
        protected Builder setDefault() {
            super.setDefault();
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

