/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import xaero.common.HudMod;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderer;

public abstract class MinimapElementRendererHandler {
    private final HudMod modMain;
    private final List<MinimapElementRenderer<?, ?>> renderers;
    protected final MinimapElementRenderLocation location;
    private final int indexLimit;

    protected MinimapElementRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, MinimapElementRenderLocation location, int indexLimit) {
        this.modMain = modMain;
        this.renderers = renderers;
        this.location = location;
        this.indexLimit = indexLimit;
    }

    public void add(MinimapElementRenderer<?, ?> renderer) {
        this.renderers.add(renderer);
        Collections.sort(this.renderers);
    }

    public final double render(Entity renderEntity, EntityPlayer player, Vec3d renderPos, double playerDimDiv, double ps, double pc, double zoom, boolean cave, float partialTicks, Framebuffer framebuffer, ScaledResolution scaledRes) {
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(this.location, renderEntity, player, renderPos, cave, partialTicks, framebuffer, scaledRes);
        double resultDepth = 0.0;
        this.beforeRender();
        int indexLimit = this.getIndexLimit();
        for (int i = 0; i < this.renderers.size(); ++i) {
            MinimapElementRenderer<?, ?> renderer = this.renderers.get(i);
            int elementIndex = 0;
            elementIndex = this.renderForRenderer(renderer, playerDimDiv, ps, pc, zoom, elementIndex, indexLimit, renderInfo);
            double depthStep = this.getElementIndexDepth(elementIndex, indexLimit);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)depthStep);
            resultDepth += depthStep;
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        this.afterRender();
        return resultDepth;
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> int renderForRenderer(RR renderer, double playerDimDiv, double ps, double pc, double zoom, int elementIndex, int indexLimit, MinimapElementRenderInfo renderInfo) {
        MinimapElementRenderLocation location = this.location;
        if (!renderer.shouldRender(location)) {
            return elementIndex;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        MinimapElementReader elementReader = renderer.elementReader;
        MinimapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        renderer.preRender(renderInfo);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            double optionalDepth;
            Object element = provider.setupContextAndGetNext(location, context);
            if (element == null || elementReader.isHidden(element, context) || !this.transformAndRenderForRenderer(element, renderer, context, playerDimDiv, ps, pc, zoom, elementIndex, optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit), renderInfo)) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(renderInfo);
        return elementIndex;
    }

    protected double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    protected int getIndexLimit() {
        return this.indexLimit;
    }

    protected abstract <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E var1, RR var2, RRC var3, double var4, double var6, double var8, double var10, int var12, double var13, MinimapElementRenderInfo var15);

    protected abstract void beforeRender();

    protected abstract void afterRender();

    public static abstract class Builder {
        protected Builder() {
        }

        protected Builder setDefault() {
            return this;
        }

        public MinimapElementRendererHandler build() {
            return this.buildInternally(new ArrayList());
        }

        protected abstract MinimapElementRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> var1);
    }
}

