/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.compass.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import xaero.common.HudMod;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.hud.minimap.compass.render.CardinalDirection;
import xaero.hud.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.hud.minimap.waypoint.WaypointColor;

public class CompassRenderer {
    private final HudMod modMain;
    private final Minecraft mc;
    private double[] partialDest;

    public CompassRenderer(HudMod modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.partialDest = new double[2];
    }

    public void drawCompass(int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        WaypointColor defaultColor = WaypointColor.fromIndex(this.modMain.getSettings().compassColor);
        MinimapRendererHelper rendererHelper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
        for (int i = 0; i < 4; ++i) {
            WaypointColor effectiveColor;
            double offX = (i & 1) * (i == 1 ? 10000 : -10000);
            double offY = (i + 1 & 1) * (i == 2 ? 10000 : -10000);
            GlStateManager.func_179094_E();
            MinimapElementOverMapRendererHandler.translatePosition(specW, specH, specW, specH, ps, pc, offX, offY, zoom, circle, this.partialDest);
            GlStateManager.func_179109_b((float)-1.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)minimapScale, (float)minimapScale, (float)1.0f);
            String initials = CardinalDirection.values()[i].getInitials().func_150254_d();
            int halfW = this.mc.field_71466_p.func_78256_a(initials) / 2 - 1;
            WaypointColor waypointColor = effectiveColor = i == 0 ? WaypointColor.fromIndex(this.modMain.getSettings().getNorthCompassColor()) : defaultColor;
            if (background) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                rendererHelper.drawMyColoredRect(-4 - addedFrame, -4 - addedFrame, 5 + addedFrame, 5 + addedFrame, 0x90000000 | effectiveColor.getHex() & 0xFFFFFF);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179098_w();
            }
            Minecraft.func_71410_x().field_71466_p.func_175065_a(initials, (float)(-halfW + 1), -2.0f, effectiveColor.getHex(), false);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71466_p.func_175065_a(initials, (float)(-halfW), -3.0f, -1, false);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
    }
}

