/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar.tracker;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.radar.tracker.PlayerTrackerIconRenderer;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElement;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementCollector;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementReader;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderContext;
import xaero.common.minimap.radar.tracker.PlayerTrackerMinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;

public final class PlayerTrackerMinimapElementRenderer
extends MinimapElementRenderer<PlayerTrackerMinimapElement<?>, PlayerTrackerMinimapElementRenderContext> {
    private final PlayerTrackerMinimapElementCollector elementCollector;
    private final PlayerTrackerIconRenderer playerTrackerIconRenderer;
    private final IXaeroMinimap modMain;

    private PlayerTrackerMinimapElementRenderer(PlayerTrackerMinimapElementCollector elementCollector, IXaeroMinimap modMain, PlayerTrackerMinimapElementRenderContext context, PlayerTrackerMinimapElementRenderProvider<PlayerTrackerMinimapElementRenderContext> provider, PlayerTrackerMinimapElementReader reader, PlayerTrackerIconRenderer playerTrackerIconRenderer) {
        super(reader, provider, context);
        this.elementCollector = elementCollector;
        this.modMain = modMain;
        this.playerTrackerIconRenderer = playerTrackerIconRenderer;
    }

    public ResourceLocation getPlayerSkin(EntityPlayer player, NetworkPlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayer ? ((AbstractClientPlayer)player).func_110306_p() : info.func_178837_g();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
        }
        return skinTextureLocation;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo) {
        if (this.modMain.getSupportMods().worldmap()) {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = this.modMain.getSupportMods().worldmapSupport.getMapDimension();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getLastPlayerDimDiv();
        } else {
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimId = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
            ((PlayerTrackerMinimapElementRenderContext)this.context).mapDimDiv = 1.0;
        }
        ((PlayerTrackerMinimapElementRenderContext)this.context).helper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo) {
        this.elementCollector.resetRenderedOnRadarFlags();
    }

    @Override
    public boolean renderElement(PlayerTrackerMinimapElement<?> e, boolean highlit, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo) {
        if (!outOfBounds && e.wasRenderedOnRadar()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        NetworkPlayerInfo info = mc.func_147114_u().func_175102_a(e.getPlayerId());
        if (info != null) {
            EntityPlayer clientPlayer = mc.field_71441_e.func_152378_a(e.getPlayerId());
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)optionalDepth);
            GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
            Gui.func_73734_a((int)-5, (int)-5, (int)5, (int)5, (int)-1);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.01);
            this.playerTrackerIconRenderer.renderIcon(mc, ((PlayerTrackerMinimapElementRenderContext)this.context).helper, clientPlayer, this.getPlayerSkin(clientPlayer, info));
            GlStateManager.func_179121_F();
        }
        return false;
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        return this.modMain.getSettings().displayTrackedPlayers;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public PlayerTrackerMinimapElementCollector getCollector() {
        return this.elementCollector;
    }

    public static final class Builder {
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            return this;
        }

        public PlayerTrackerMinimapElementRenderer build() {
            PlayerTrackerMinimapElementCollector collector = new PlayerTrackerMinimapElementCollector(this.modMain.getPlayerTrackerSystemManager());
            return new PlayerTrackerMinimapElementRenderer(collector, this.modMain, new PlayerTrackerMinimapElementRenderContext(), new PlayerTrackerMinimapElementRenderProvider(collector), new PlayerTrackerMinimapElementReader(), new PlayerTrackerIconRenderer());
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

