/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.lwjgl.opengl.GLContext;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.tracker.synced.ClientSyncedTrackedPlayerManager;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.module.MinimapSession;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private IXaeroMinimap modMain;
    private MinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private MinimapRadar entityRadar;
    private MinimapInterface minimapInterface;
    private EntityRadarCategoryManager entityCategoryManager;
    private ClientSyncedTrackedPlayerManager clientSyncedTrackedPlayerManager;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap;
    private boolean manualCaveMode;
    private boolean noMinimapMessageReceived;
    private boolean fairPlayOnlyMessageReceived;

    public MinimapProcessor(IXaeroMinimap modMain, MinimapSession minimapSession, MinimapWriter minimapWriter, MinimapRadar entityRadar, ClientSyncedTrackedPlayerManager clientSyncedTrackedPlayerManager) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.entityRadar = entityRadar;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
        this.clientSyncedTrackedPlayerManager = clientSyncedTrackedPlayerManager;
    }

    public int getMinimapSize(double scale) {
        return this.enlargedMap ? 500 : this.modMain.getSettings().getMinimapSize(scale) * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        int bufferSize = 128 * (int)Math.pow(2.0, Math.ceil(Math.log((double)minimapSize / 128.0) / Math.log(2.0)));
        if (bufferSize < 128) {
            return 128;
        }
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    public boolean isCaveModeDisplayed() {
        return this.minimapWriter.getLoadedCaving() != -1;
    }

    public double getTargetZoom() {
        float target;
        float settingsZoom = this.modMain.getSettings().zooms[this.modMain.getSettings().zoom];
        if (this.enlargedMap && this.modMain.getSettings().zoomOnEnlarged > 0) {
            settingsZoom = this.modMain.getSettings().zoomOnEnlarged;
        }
        if ((target = settingsZoom * (this.modMain.getSettings().caveZoom > 0 && this.isCaveModeDisplayed() ? (float)(1 + this.modMain.getSettings().caveZoom) : 1.0f)) > this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1]) {
            target = this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1];
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)MultiplyAnimationHelper.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return !(!GLContext.getCapabilities().OpenGL14 || !GLContext.getCapabilities().GL_ARB_framebuffer_object && !GLContext.getCapabilities().GL_EXT_framebuffer_object && !GLContext.getCapabilities().OpenGL30 || !GLContext.getCapabilities().OpenGL15 && !GLContext.getCapabilities().GL_ARB_vertex_buffer_object || !GLContext.getCapabilities().OpenGL21 && !GLContext.getCapabilities().GL_EXT_pixel_buffer_object && !GLContext.getCapabilities().GL_ARB_pixel_buffer_object);
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        World world = null;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70170_p instanceof WorldClient) {
            world = player.field_70170_p;
        }
        this.entityRadar.updateRadar((WorldClient)world, (EntityPlayer)player, Minecraft.func_71410_x().func_175606_aa(), this);
    }

    public void onPlayerTick() {
    }

    public void checkFBO() {
        if (this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
            this.minimapInterface.getMinimapFBORenderer().setLoadedFBO(false);
            this.minimapInterface.getMinimapFBORenderer().deleteFramebuffers();
            this.toResetImage = true;
        }
        if (!(this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() || this.modMain.getSettings().mapSafeMode || this.minimapInterface.getMinimapFBORenderer().isTriedFBO())) {
            this.minimapInterface.getMinimapFBORenderer().loadFrameBuffer(this);
        }
    }

    public void onRender(int x, int y, int width, int height, ScaledResolution scaledRes, int size, int boxSize, float partial) {
        try {
            if (this.enlargedMap && this.modMain.getSettings().centeredEnlarged) {
                x = (width - boxSize) / 2;
                y = (height - boxSize) / 2;
            }
            if (this.minimapInterface.usingFBO()) {
                this.minimapInterface.getMinimapFBORenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scaledRes, size, partial);
            } else {
                this.minimapInterface.getMinimapSafeModeRenderer().renderMinimap(this.minimapSession, this, x, y, width, height, scaledRes, size, partial);
            }
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
            this.minimapInterface.checkCrashes();
        }
    }

    public static boolean hasMinimapItem(EntityPlayer player) {
        return Misc.hasItem(player, ModSettings.minimapItem);
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public MinimapRadar getEntityRadar() {
        return this.entityRadar;
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }

    public boolean isManualCaveMode() {
        return this.manualCaveMode || this.modMain.getSettings().usesWorldMapScreenValue(ModOptions.MANUAL_CAVE_MODE_START) && this.modMain.getSupportMods().worldmapSupport.getManualCaveStart() != -1;
    }

    public void toggleManualCaveMode() {
        this.manualCaveMode = !this.isManualCaveMode();
    }

    public MinimapInterface getMinimapInterface() {
        return this.minimapInterface;
    }

    public boolean getNoMinimapMessageReceived() {
        return this.noMinimapMessageReceived;
    }

    public void setNoMinimapMessageReceived(boolean noMinimapMessageReceived) {
        this.noMinimapMessageReceived = noMinimapMessageReceived;
    }

    public boolean getForcedFairPlay() {
        return this.fairPlayOnlyMessageReceived;
    }

    public void setFairPlayOnlyMessageReceived(boolean fairPlayOnlyMessageReceived) {
        this.fairPlayOnlyMessageReceived = fairPlayOnlyMessageReceived;
    }

    public ClientSyncedTrackedPlayerManager getClientSyncedTrackedPlayerManager() {
        return this.clientSyncedTrackedPlayerManager;
    }

    public boolean serverHasMod() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData != null && worldData.serverLevelId != null;
    }

    public void setServerModNetworkVersion(int networkVersion) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return;
        }
        worldData.setServerModNetworkVersion(networkVersion);
    }

    public int getServerModNetworkVersion() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return 0;
        }
        return worldData.getServerModNetworkVersion();
    }
}

