/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.TooltipButton;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactory;
    private Function<IXaeroMinimap, CursorBox> tooltipSupplier;
    private boolean active;

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, final CursorBox tooltip, boolean active) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = new Function<IXaeroMinimap, CursorBox>(){

            @Override
            public CursorBox apply(IXaeroMinimap t) {
                return tooltip;
            }
        };
        this.active = active;
    }

    @Override
    public String getStringForSearch(IXaeroMinimap modMain) {
        CursorBox entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.apply(modMain);
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (entryTooltip != null ? " " + entryTooltip.getFullCode().replace("gui.xaero", "") + " " + I18n.func_135052_a((String)entryTooltip.getFullCode(), (Object[])new Object[0]) : "");
    }

    @Override
    public GuiButton createWidget(int x, int y, int w, IXaeroMinimap modMain, int width, boolean canEditIngameSettings) {
        TooltipButton button = new TooltipButton(x, y, w, 20, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), this.tooltipSupplier){

            @Override
            protected void onPress() {
                Minecraft mc = Minecraft.func_71410_x();
                GuiScreen current = mc.field_71462_r;
                GuiScreen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                GuiScreen targetScreen = (GuiScreen)ScreenSwitchSettingEntry.this.screenFactory.apply(current, currentEscScreen);
                if (current instanceof ScreenBase) {
                    ((ScreenBase)current).onExit(targetScreen);
                } else {
                    mc.func_147108_a(targetScreen);
                }
            }
        };
        button.field_146124_l = this.active;
        return button;
    }

    public BiFunction<GuiScreen, GuiScreen, GuiScreen> getScreenFactory() {
        return this.screenFactory;
    }
}

