/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import xaero.common.category.ObjectCategory;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorAdderData;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.GuiCategoryUIEditorSettingsData;
import xaero.common.category.ui.entry.CategorySettingsListEntryCategory;
import xaero.common.category.ui.entry.CategorySettingsListMainEntry;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;

public abstract class GuiCategoryUIEditorCategoryData<C extends ObjectCategory<?, C>, SD extends GuiCategoryUIEditorSettingsData<?>, ED extends GuiCategoryUIEditorCategoryData<C, SD, ED>>
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> {
    private final ED self = this;
    private boolean cut;
    private final List<ED> subCategories;
    private final GuiCategoryUIEditorAdderData topAdder;
    private final Function<GuiCategoryUIEditorAdderData, ED> newCategorySupplier;
    private final SD settingsData;

    protected GuiCategoryUIEditorCategoryData(@Nonnull SD settingData, @Nonnull List<ED> subCategories, @Nonnull GuiCategoryUIEditorAdderData topAdder, @Nonnull Function<GuiCategoryUIEditorAdderData, ED> newCategorySupplier, boolean movable, int subIndex, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> tooltipSupplier) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.settingsData = settingData;
        this.subCategories = subCategories;
        this.topAdder = topAdder;
        this.newCategorySupplier = newCategorySupplier;
    }

    public SD getSettingsData() {
        return this.settingsData;
    }

    public final List<ED> getSubCategories() {
        return this.subCategories;
    }

    public String getName() {
        return ((GuiCategoryUIEditorSettingsData)this.settingsData).getNameOption().getResult();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    private BiConsumer<GuiCategoryUIEditorAdderData, Integer> getAdderHandler() {
        return new BiConsumer<GuiCategoryUIEditorAdderData, Integer>(){

            @Override
            public void accept(GuiCategoryUIEditorAdderData adder, Integer i) {
                if (adder.isConfirmed()) {
                    GuiCategoryUIEditorCategoryData newCategory = (GuiCategoryUIEditorCategoryData)GuiCategoryUIEditorCategoryData.this.newCategorySupplier.apply(adder);
                    GuiCategoryUIEditorCategoryData.this.subCategories.add(i, newCategory);
                    adder.reset();
                }
            }
        };
    }

    private Runnable getDeletionHandler() {
        return new Runnable(){

            @Override
            public void run() {
                Iterator subIterator = GuiCategoryUIEditorCategoryData.this.subCategories.iterator();
                while (subIterator.hasNext()) {
                    GuiCategoryUIEditorCategoryData subCategory = (GuiCategoryUIEditorCategoryData)subIterator.next();
                    if (!((GuiCategoryUIEditorSettingsData)subCategory.getSettingsData()).isToBeDeleted()) continue;
                    subIterator.remove();
                }
            }
        };
    }

    public Supplier<Boolean> getMoveAction(final int subIndex, final int direction, final GuiCategorySettings.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                int newSlot = subIndex + direction;
                GuiCategoryUIEditorCategoryData subCategoryToMove = (GuiCategoryUIEditorCategoryData)GuiCategoryUIEditorCategoryData.this.subCategories.get(subIndex);
                if (newSlot < 0) {
                    GuiCategoryUIEditorCategoryData.this.subCategories.remove(subCategoryToMove);
                    GuiCategoryUIEditorCategoryData.this.subCategories.add(subCategoryToMove);
                } else if (newSlot >= GuiCategoryUIEditorCategoryData.this.subCategories.size()) {
                    GuiCategoryUIEditorCategoryData.this.subCategories.remove(subCategoryToMove);
                    GuiCategoryUIEditorCategoryData.this.subCategories.add(0, subCategoryToMove);
                } else {
                    rowList.restoreScrollAfterUpdate();
                    GuiCategoryUIEditorCategoryData subCategoryToReplace = (GuiCategoryUIEditorCategoryData)GuiCategoryUIEditorCategoryData.this.subCategories.get(newSlot);
                    GuiCategoryUIEditorCategoryData.this.subCategories.set(subIndex, subCategoryToReplace);
                    GuiCategoryUIEditorCategoryData.this.subCategories.set(newSlot, subCategoryToMove);
                }
                rowList.setLastExpandedData(subCategoryToMove);
                return true;
            }
        };
    }

    public Supplier<Boolean> getDuplicateAction(final int subIndex, final GuiCategorySettings.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                if (subIndex < 0 || subIndex >= GuiCategoryUIEditorCategoryData.this.subCategories.size()) {
                    return false;
                }
                final GuiCategoryUIEditorCategoryData subCategoryToDuplicate = (GuiCategoryUIEditorCategoryData)GuiCategoryUIEditorCategoryData.this.subCategories.get(subIndex);
                final GuiCategorySettings screenToRestore = (GuiCategorySettings)Minecraft.func_71410_x().field_71462_r;
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int i) {
                        if (result) {
                            Object convertedCategory = rowList.getDataConverter().convert(subCategoryToDuplicate);
                            Object reconstructedEditorData = rowList.getDataConverter().convert(convertedCategory, false);
                            ((GuiCategoryUIEditorCategoryData)reconstructedEditorData).removeProtectionRecursive();
                            GuiCategoryUIEditorCategoryData.this.subCategories.add(subIndex + 1, reconstructedEditorData);
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)screenToRestore);
                            GuiCategorySettings.SettingRowList newRowList = screenToRestore.getRowList();
                            newRowList.setLastExpandedData((GuiCategoryUIEditorExpandableData<?>)reconstructedEditorData);
                            newRowList.updateEntries();
                            return;
                        }
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)screenToRestore);
                    }
                }, I18n.func_135052_a((String)"gui.xaero_category_duplicate_confirm", (Object[])new Object[0]), "\u00a7e" + I18n.func_135052_a((String)subCategoryToDuplicate.getDisplayName(), (Object[])new Object[0]), 0));
                return true;
            }
        };
    }

    public Supplier<Boolean> getCutAction(final ED parent, final GuiCategorySettings.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                rowList.setCutCategory(GuiCategoryUIEditorCategoryData.this.self, parent);
                rowList.setLastExpandedData(GuiCategoryUIEditorCategoryData.this);
                rowList.restoreScrollAfterUpdate();
                return true;
            }
        };
    }

    public Supplier<Boolean> getPasteAction(final GuiCategorySettings.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                rowList.pasteTo(GuiCategoryUIEditorCategoryData.this.self);
                rowList.restoreScrollAfterUpdate();
                return true;
            }
        };
    }

    @Override
    public List<GuiCategoryUIEditorExpandableData<?>> getSubExpandables() {
        BiConsumer<GuiCategoryUIEditorAdderData, Integer> adderHandler = this.getAdderHandler();
        adderHandler.accept(this.topAdder, 0);
        this.getDeletionHandler().run();
        ArrayList result = new ArrayList(this.subCategories);
        result.add(0, this.topAdder);
        result.add(0, (GuiCategoryUIEditorExpandableData<?>)this.settingsData);
        return result;
    }

    public void removeProtectionRecursive() {
        ((GuiCategoryUIEditorSettingsData)this.getSettingsData()).setProtected(false);
        for (GuiCategoryUIEditorCategoryData sub : this.subCategories) {
            sub.removeProtectionRecursive();
        }
    }

    public static abstract class Builder<C extends ObjectCategory<?, C>, ED extends GuiCategoryUIEditorCategoryData<C, SD, ED>, SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends GuiCategoryUIEditorSettingsData.Builder<SD, SDB>, EDB extends Builder<C, ED, SD, SDB, EDB>>
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorExpandableData<?>, EDB> {
        protected final EDB self;
        protected String name;
        protected final SDB settingsDataBuilder;
        protected final List<EDB> subCategoryBuilders;
        protected final ListFactory listFactory;
        protected final GuiCategoryUIEditorAdderData.Builder topAdderBuilder;
        protected Function<GuiCategoryUIEditorAdderData, ED> newCategorySupplier;
        protected int subIndex;

        public Builder(ListFactory listFactory, SDB settingsDataBuilder) {
            if (settingsDataBuilder == null) {
                throw new IllegalStateException("settings data builder cannot be null!");
            }
            this.settingsDataBuilder = settingsDataBuilder;
            this.subCategoryBuilders = listFactory.get();
            this.listFactory = listFactory;
            this.topAdderBuilder = GuiCategoryUIEditorAdderData.Builder.getDefault(listFactory);
            this.self = this;
        }

        @Override
        public EDB setDefault() {
            super.setDefault();
            this.setName(null);
            ((GuiCategoryUIEditorSettingsData.Builder)this.settingsDataBuilder).setDefault();
            this.subCategoryBuilders.clear();
            this.topAdderBuilder.setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_add_subcategory", (Object[])new Object[0]));
            this.setMovable(true);
            this.setListEntryFactory(new CategorySettingsListMainEntryFactory(){

                @Override
                public CategorySettingsListMainEntry<?> get(GuiCategoryUIEditorExpandableData<?> data, GuiCategoryUIEditorExpandableData<?> parent, int index, ConnectionLineType lineType, GuiCategorySettings.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
                    return new CategorySettingsListEntryCategory(screenWidth, index, rowList, lineType, (GuiCategoryUIEditorCategoryData)data, (GuiCategoryUIEditorCategoryData)parent, data.getTooltipSupplier(parent), isFinalExpanded);
                }
            });
            this.setSubIndex(0);
            this.setTooltipSupplier(new BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>>(){

                @Override
                public Supplier<CursorBox> apply(GuiCategoryUIEditorExpandableData<?> parent, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> data) {
                    final CursorBox tooltip = new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_category", (Object[])new Object[]{I18n.func_135052_a((String)data.getDisplayName(), (Object[])new Object[0])}));
                    tooltip.setAutoLinebreak(false);
                    return new Supplier<CursorBox>(){

                        @Override
                        public CursorBox get() {
                            return tooltip;
                        }
                    };
                }
            });
            return this.self;
        }

        public EDB setNewCategorySupplier(Function<GuiCategoryUIEditorAdderData, ED> newCategorySupplier) {
            this.newCategorySupplier = newCategorySupplier;
            return this.self;
        }

        public EDB setSubIndex(int subIndex) {
            this.subIndex = subIndex;
            return this.self;
        }

        public EDB setName(String name) {
            this.name = name;
            return this.self;
        }

        public SDB getSettingDataBuilder() {
            return this.settingsDataBuilder;
        }

        public EDB addSubCategoryBuilder(EDB subCategory) {
            ((Builder)subCategory).setSubIndex(this.subCategoryBuilders.size());
            this.subCategoryBuilders.add(subCategory);
            return this.self;
        }

        protected List<ED> buildSubCategories() {
            return (List)this.subCategoryBuilders.stream().map(new Function<EDB, Object>(){

                @Override
                public Object apply(EDB b) {
                    return ((Builder)b).build();
                }
            }).collect(new Supplier<List<ED>>(){

                @Override
                public List<ED> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<ED>, Object>(){

                @Override
                public void accept(List<ED> l, Object e) {
                    l.add((GuiCategoryUIEditorCategoryData)e);
                }
            }, new BiConsumer<List<ED>, List<ED>>(){

                @Override
                public void accept(List<ED> l1, List<ED> l2) {
                    l1.addAll(l2);
                }
            });
        }

        public ED build() {
            if (this.name == null || this.newCategorySupplier == null) {
                throw new IllegalStateException("required fields not set!");
            }
            ((GuiCategoryUIEditorSettingsData.Builder)this.settingsDataBuilder).getNameOptionBuilder().setInput(this.name);
            ((GuiCategoryUIEditorSettingsData.Builder)this.settingsDataBuilder).getNameOptionBuilder().setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_name", (Object[])new Object[0]));
            ((GuiCategoryUIEditorSettingsData.Builder)this.settingsDataBuilder).getNameOptionBuilder().setMaxLength(200);
            GuiCategoryUIEditorCategoryData result = (GuiCategoryUIEditorCategoryData)super.build();
            return (ED)result;
        }
    }
}

